# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

import numpy as np

def formatPlotTrans(x, run1_m2, run1_m3, run2_m2, run2_m3):
    
    _series1={}
    _list=[]

    _point = []
    for i in range(len(x)):
        _point.append([x[i], run1_m2[i]])

    _line={}
    _line['name']='Run1: M2'
    _line['data'] = _point

    _list.append(_line)

    _point = []
    for i in range(len(x)):
        _point.append([x[i], run2_m2[i]])

    _line={}
    _line['name']='Run2: M2'
    _line['data'] = _point

    _list.append(_line)

    _series1['series'] = _list

    _series2={}
    _list=[]

    _point = []
    for i in range(len(x)):
        _point.append([x[i], run1_m3[i]])

    _line={}
    _line['name']='Run1: M3'
    _line['data'] = _point

    _list.append(_line)

    _point = []
    for i in range(len(x)):
        _point.append([x[i], run2_m3[i]])

    _line={}
    _line['name']='Run2: M3'
    _line['data'] = _point

    _list.append(_line)

    _series2['series'] = _list

    _series={}
    _series['series1']=_series1
    _series['series2']=_series2

    return _series


def formatCalcTrans(x, trans_raw, trans_fit):
    _series={}
    _list=[]

    _point = []
    for i in range(len(x)):
        _point.append([x[i], trans_raw[i]])

    _line={}
    _line['name']='Trans: raw'
    #_line['dataLabels']='M2'
    _line['data'] = _point

    _list.append(_line)

    _point = []
    for i in range(len(x)):
        _point.append([x[i], trans_fit[i]])

    _line={}
    _line['name']='Trans: fitted'
    #_line['dataLabels']='M2'
    _line['data'] = _point

    _list.append(_line)

    _series['series'] = _list

    return _series

def format0D(self, data):
    return data

def format1D(self, x, y, xlabel, ylabel, title):
    _point = []
    for i in range(len(x)):
        _point.append([x[i], y[i]])

    _data={}
    _data['xlabel'] = xlabel
    _data['ylabel'] = ylabel
    _data['title'] = title
    _data['data'] = _point
    return _data

def format2D(self, x, y, z, xlabel, ylabel, zlabel, title):
    _point = []
    for i in range(len(x)-1):
        for j in range(len(y)-1):
            _point.append([x[i], y[j], z[j][i]])

    _data = {}
    _data['colormin']= np.min(z)
    _data['colormax']= np.max(z)
    _data['xmin']= np.min(x)
    _data['xmax']= np.max(x)
    _data['ymin']= np.min(y)
    _data['ymax']= np.max(y)
    _data['data']= _point

    _data['xlabel'] = xlabel
    _data['ylabel'] = ylabel
    _data['zlabel'] = zlabel
    _data['title'] = title

    return _data
