# coding:utf-8

from app.views import views


import eventlet
eventlet.monkey_patch()

import os
import sys
import random
import time
from flask import session, render_template, url_for, send_from_directory, request, flash
from flask_login import LoginManager, current_user, login_required, login_user, logout_user
from flask_socketio import emit, Namespace
from auth import PermissionChecker
from auth_helper import app, clearSession, icatHelper, socketio
import signal
import rq
import psutil
import redis
from jobs import plotTrans, calcTrans


from models import getRedisServer
ip="10.1.31.120"
myredis=getRedisServer(ip)

import threading
reduceLock = threading.Lock()

global ipList
ipList={}
global nsList
nsList={}

class myNamespace(Namespace):
    def __init__(self, namespace=None, check=False):
        super().__init__()
        self.namespace = namespace

    def on_trans_sample_plot(self, data):
        _n = len(data['runs'])
        _tmp = []
        for _i in range(_n):
            _d = []
            for i in range(50):
                _d.append(random.randint(0,100))
            _tmp.append({"name": "test" + str(_i), "data": _d})
        emit('trans_sample_plot', _tmp)

    def on_trans_plot(self, data):
        print("<==================================")
        print("on plot trans")
        print (self.namespace[0:]," to redis", data)

        job = app.queue.enqueue(plotTrans, self.namespace, data)

    def on_trans_calc(self, data):
        print("<==================================")
        print("on calc trans")
        print (self.namespace[0:]," to redis", data)

        job = app.queue.enqueue(calcTrans, self.namespace, data)

    def on_connect(self):
        print("<==================================")
        print("3: connect")
        if True:
            _uuid = self.namespace[1:]
            _ip=dict(request.event['args'][0])['REMOTE_ADDR']
            if _uuid in ipList.keys():
                if ipList[_uuid]!=_ip:
                    ipList[_uuid]=_ip
                    nsList[_uuid]=self
                    print("Warning: ", _uuid, " not match ", _ip)
            else:
                ipList[_uuid]=_ip
                nsList[_uuid]=self
                myredis.setRedisData("flask_client",ipList)
                print("Add tab: ", _uuid, _ip)
            print("All clients: ", ipList)
            print("All clients: ", nsList)
        else:
            print("Warning: first contact!")

    def on_disconnect(self):
        #reduceLock.acquire()
        print("<==================================")
        print("5: disconnect")
        try:
            _uuid = self.namespace[1:]
            if _uuid in ipList.keys():
                ipList.pop(_uuid)
                nsList.pop(_uuid)
                myredis.setRedisData("flask_client",ipList)
                print("Loss tab: ", _uuid)
        except:
            print("Warning: something wrong ", ipList)

        print("All clients: ", ipList)
        print("All clients: ", nsList)
        #reduceLock.release()

@socketio.on('update')
def handle_connect():
    while True:
        emit('update', random.randint(0,1000))
        time.sleep(2)

@app.route('/')
def index():
    if 'icatSessionId' in session:
        _icatSession = icatHelper.getSessionById(session['icatSessionId'])
        if PermissionChecker.isSessionValid(_icatSession):
            _icatSession.refresh()
        else:
            clearSession()
    else:
        clearSession()

    _username = session.get('username', None)
    _p = []
    if _username is not None:
        _session = icatHelper.getSessionById(session['icatSessionId'])
        _facilities = _session.search('SELECT f FROM Facility f')
        _proposals = icatHelper.getOwnProposals(_session)
        for _proposal in _proposals:
            _temp = {}
            _id = _proposal['Investigation']['id']
            _datasets = icatHelper.getDatasetsForProposal(_session, _id)
            _facility = icatHelper.getFacilityForProposal(_session, _id)
            _instruments = icatHelper.getInstrumentsForProposal(_session, _id)
            _temp['id'] = _id
            _temp['investigation'] = _proposal['Investigation']
            _temp['datasets'] = _datasets
            _temp['facility'] = _facility
            _temp['instruments'] = _instruments
            _p.append(_temp)
    return render_template('index.html', proposals = _p)

@app.route('/favicon.ico')
def favicon():
    return send_from_directory(os.path.join(app.root_path, 'static'), 'img/csns-logo.png', mimetype='image/png')

@app.route('/analysis', methods=['GET','POST'])
@login_required
def analysis():
    if request.method == 'POST':
        _facility_id = request.form['f_id']
        _instrument_id = request.form['i_id']
        _proposal_id = request.form['p_id']
        _uuid = request.form['uuid']
    else:
        _proposal_id = request.args.get('p_id')
        _uuid = request.args.get('uuid')

    print("<==================================")
    print("analysis")
    
    _icatSessionId = session.get("icatSessionId", None)
    if _icatSessionId is None:
        return redirect('/login')

    try:
        _icatSession = icatHelper.getSessionById(_icatSessionId)
        if not PermissionChecker.isSessionValid(_icatSession):
            return redirect('/login')

        if PermissionChecker.isAccessPermitted(_icatSession, int(_proposal_id)):
            _proposal = icatHelper.getProposalById(_icatSession, int(_proposal_id))
        else:
            print('Access not permitted')

        _ip=request.remote_addr
        if _uuid in ipList.keys():
            if ipList[_uuid]!=_ip:
                print(_uuid, " not match ", _ip)
            _success=False
        else:
            ipList[_uuid]=_ip
            nsList[_uuid]=self(myNamespace('/'+ _uuid))
            myredis.setRedisData("flask_client",ipList)
            _success=True

        if _success:
            print("create new tab: ", _uuid)
        else:
            print("refresh old tab: ", _uuid)
        
        socketio.on_namespace(myNamespace('/'+ _uuid))
    except Exception as ex:
        print(ex)
        flash(str(ex))

    return render_template('analysis.html', proposal=_proposal, uuid = _uuid)

def singleton(isStop=False):
    pidList=[]
    mypid = os.getpid()
    myname = os.path.basename(__file__)

    for proc in psutil.process_iter(['pid', 'name']):
        try:
            if proc.name() == u"python3" or proc.name() == u"python":
                if myname in proc.cmdline():
                    pidList.append(proc.info['pid'])
        except psutil.AccessDenied:
            print ("error: access denied")

    for p in pidList:
        if p != mypid:
            psutil.Process(p).kill()

    if isStop:
        psutil.Process(mypid).kill()
        
def clearon():
    #myredis.delete("flask_client")
    try:
        _ipList=myredis.getRedisData("flask_client")
    except:
        _ipList={}

    print("info: restore the existing connections: ",_ipList)
    for (k,v) in _ipList.items():
        socketio.on_namespace(myNamespace("/"+k, True))

def ctrlc_handler(signum, frame):
    print ("What is Ctrl + C ?")

signal.signal(signal.SIGINT, ctrlc_handler)

if __name__ == '__main__':
        # allow one process only
    singleton()
    # attemp to connect the existing connections
    clearon()

    socketio.run(app, host='0.0.0.0', port='5000', debug=False)
