# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from app.sans import sans_bp

import os
import sys
import random
import time
from flask import session, render_template, url_for, send_from_directory, request, flash
from flask_login import LoginManager, current_user, login_required, login_user, logout_user
from flask_socketio import emit, Namespace
#from auth import PermissionChecker
#from auth_helper import app, clearSession, icatHelper, socketio
import signal
import rq
import psutil
import redis
from app.jobs import plotTrans, calcTrans
from flask import current_app as app
from app.auth import icat_helper, auth_helper, auth

global ipList
ipList={}
global nsList
nsList={}

class myNamespace(Namespace):
    def __init__(self, namespace=None, check=False):
        super().__init__()
        self.namespace = namespace

    def on_trans_sample_plot(self, data):
        _n = len(data['runs'])
        _tmp = []
        for _i in range(_n):
            _d = []
            for i in range(50):
                _d.append(random.randint(0,100))
            _tmp.append({"name": "test" + str(_i), "data": _d})
        emit('trans_sample_plot', _tmp)

    def on_trans_plot(self, data):
        print("<==================================")
        print("on plot trans")
        print (self.namespace[0:]," to redis", data)

        job = app.queue.enqueue(plotTrans, self.namespace, data)

    def on_trans_calc(self, data):
        print("<==================================")
        print("on calc trans")
        print (self.namespace[0:]," to redis", data)

        job = app.queue.enqueue(calcTrans, self.namespace, data)

    def on_connect(self):
        print("<==================================")
        print("3: connect")
        if True:
            _uuid = self.namespace[1:]
            _ip=dict(request.event['args'][0])['REMOTE_ADDR']
            if _uuid in ipList.keys():
                if ipList[_uuid]!=_ip:
                    ipList[_uuid]=_ip
                    nsList[_uuid]=self
                    print("Warning: ", _uuid, " not match ", _ip)
            else:
                ipList[_uuid]=_ip
                nsList[_uuid]=self
                myredis.setRedisData("flask_client",ipList)
                print("Add tab: ", _uuid, _ip)
            print("All clients: ", ipList)
            print("All clients: ", nsList)
        else:
            print("Warning: first contact!")

    def on_disconnect(self):
        print("<==================================")
        print("5: disconnect")
        try:
            _uuid = self.namespace[1:]
            if _uuid in ipList.keys():
                ipList.pop(_uuid)
                nsList.pop(_uuid)
                myredis.setRedisData("flask_client",ipList)
                print("Loss tab: ", _uuid)
        except:
            print("Warning: something wrong ", ipList)

        print("All clients: ", ipList)
        print("All clients: ", nsList)

@sans_bp.route('/')
def index():
    if 'icatSessionId' in session:
        _icatSession = auth_helper.icatHelper.getSessionById(session['icatSessionId'])
        if auth.PermissionChecker.isSessionValid(_icatSession):
            _icatSession.refresh()
        else:
            auth_helper.learSession()
    else:
        auth_helper.clearSession()

    _username = session.get('username', None)
    _p = []
    if _username is not None:
        _session = auth_helper.icatHelper.getSessionById(session['icatSessionId'])
        _facilities = _session.search('SELECT f FROM Facility f')
        _proposals = auth_helper.icatHelper.getOwnProposals(_session)
        for _proposal in _proposals:
            _temp = {}
            _id = _proposal['Investigation']['id']
            _datasets = auth_helper.icatHelper.getDatasetsForProposal(_session, _id)
            _facility = auth_helper.icatHelper.getFacilityForProposal(_session, _id)
            _instruments = auth_helper.icatHelper.getInstrumentsForProposal(_session, _id)
            _temp['id'] = _id
            _temp['investigation'] = _proposal['Investigation']
            _temp['datasets'] = _datasets
            _temp['facility'] = _facility
            _temp['instruments'] = _instruments
            _p.append(_temp)
    return render_template('index.html', proposals = _p)

@sans_bp.route('/favicon.ico')
def favicon():
    return send_from_directory(os.path.join(app.root_path, 'static'), 'img/csns-logo.png', mimetype='image/png')

 
def clearon():
    #myredis.delete("flask_client")
    try:
        _ipList=myredis.getRedisData("flask_client")
    except:
        _ipList={}

    print("info: restore the existing connections: ",_ipList)
    for (k,v) in _ipList.items():
        socketio.on_namespace(myNamespace("/"+k, True))
