# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

import warnings
with warnings.catch_warnings():
    warnings.simplefilter('ignore')

import os
import sys
import psutil

def singleton(isStop=False):
    pidList=[]
    mypid = os.getpid()
    myname = os.path.basename(__file__)

    for proc in psutil.process_iter(['pid', 'name']):
        try:
            if proc.name() == u"python3" or proc.name() == u"python":
                if myname in proc.cmdline():
                    pidList.append(proc.info['pid'])
        except psutil.AccessDenied:
            print ("error: access denied")

    for p in pidList:
        if p != mypid:
            psutil.Process(p).kill()

    if isStop:
        psutil.Process(mypid).kill()

#def ctrlc_handler(signum, frame):
#    print ("What is Ctrl + C ?")

#signal.signal(signal.SIGINT, ctrlc_handler)

from application import create_app, socketio

app = create_app()

if __name__ == "__main__":
    singleton()

    #app.run(host='0.0.0.0', port=5000)

    socketio.run(app, host='0.0.0.0', port=5000, debug=False)
