# -*- coding: utf-8 -*-

"""
    :author: Ming Tang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""
from flask import current_app as app
from app.auth import auth_bp
from . import icat

class IcatHelper:
    def __init__(self, icatUri):
        self._icatUri = icatUri
        self._icatService = icat.ICAT(icatUri, True)
        #print(self._icatService.getVersion())
    
    def getSessionById(self, icatSessionId):
        return icat.Session(self._icatService, str(icatSessionId))

    def loginIcat(self, username, password, plugin = "ldap"):
        credentials = []
        credentials.append({"username": username})
        credentials.append({"password": password})
        _icatSession = self._icatService.login(plugin, {"credentials": credentials})
        credentials.clear()
        return _icatSession

    def logoutIcat(self, icatSession):
        try:
            icatSession.logout()
        except:
            pass
    
    def isLoggedIn(self, username):
        return self._icatService.isLoggedIn(username)
    
    def getIcatUserByName(self, icatSession, userName):
        _tmp = icatSession.search("SELECT u From User u where u.name=" + "'" + userName + "'")
        if(len(_tmp)):
            return _tmp[0]['User']
        else:
            return None
    
    def getIcatUserById(self, icatSession, userId):
        if userId is None:
            return None
    
        _tmp = icatSession.search("SELECT u From User u where u.id=%i" % (int(userId)))
        if(len(_tmp)):
            return _tmp[0]['User']
        else:
            return None
    
    def getProposalsForInstrument(self, icatSession, beamlineName):
        #return icatSession.search("SELECT i From Investigation i JOIN i.investigationUsers iu JOIN iu.user u where u.name=" + "'" + userName + "' INCLUDE i.investigationUsers, i.investigationInstruments")
        return icatSession.search("SELECT i From Investigation i JOIN i.investigationInstruments ii JOIN ii.instrument inst where inst.name=" + "'" + beamlineName + "'")
    
    def getOwnProposals(self, icatSession):
        _username = icatSession.getUserName()
        return icatSession.search("SELECT i From Investigation i JOIN i.investigationUsers iu JOIN iu.user u where u.name=" + "'" + _username + "'")
    
    def getInstrumentsForProposal(self, icatSession, proposalId):
        return icatSession.search("SELECT i From Instrument i JOIN i.investigationInstruments ii JOIN ii.investigation inv where inv.id='%s'" % (proposalId))
    
    def getFacilityForProposal(self, icatSession, proposalId):
        return icatSession.search("SELECT f From Facility f JOIN f.investigations i where i.id='%s'" % (proposalId))
    
    def getDatasetsForProposal(self, icatSession, proposalId):
        return icatSession.search("SELECT ds FROM Dataset ds JOIN ds.investigation i WHERE i.id = '%s'" % proposalId)

    def getProposalById(self, icatSession, proposalId):
        return icatSession.get("Investigation i INCLUDE i.facility, i.datasets, i.investigationUsers iu, iu.user, i.investigationInstruments ii, ii.instrument", proposalId)
