# -*- coding: utf-8 -*-

"""
    :author: Ming Tang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from flask import current_app as app
from app.auth import auth_bp
from flask import session, flash, redirect, request, render_template
from flask_login import LoginManager, current_user, login_required, login_user, logout_user
from .icat_helper import IcatHelper
from . import auth
from . import icat

icatHelper = IcatHelper(app.config['ICAT_URL'])

login_manager = LoginManager()
login_manager.session_protection = "strong"
login_manager.init_app(app)
login_manager.login_view= "login"

@login_manager.user_loader
def load_user(id):
    if id == None:
        return None

    _icatSessionId = session.get("icatSessionId", None)
    if _icatSessionId is None:
        return None

    try:
        _icatSession = icatHelper.getSessionById(_icatSessionId)
        _icatUser = icatHelper.getIcatUserById(_icatSession, id)
        if _icatUser is None:
            return None
        _user = auth.User()
        _user.id = _icatUser['id']
        _user.icatSessionId = _icatSession.sessionId
        _user.name = _icatUser['name']
        #_user.icatSessionId = _icatSessionId
        _user.isAuthenticated = True
        _user.isAnonymous = False
        _user.isActive = True
        return _user
    except Exception as ex:
        return None

@auth_bp.route("/login", methods=['GET', 'POST'])
def login():
    _username = ""
    try:
        if current_user.is_authenticated:
            flash('You have been logged in')
            return redirect(request.args.get("next") or "/")
    except:
        pass

    if request.method == 'POST':
        _username = request.form.get('username')
        _password = request.form.get('password')
        _user = None
        try:
            _user = auth.try_login(icatHelper, _username, _password)
            session['icatSessionId'] = _user.icatSessionId
            session['username'] = _user.name
        except icat.IcatException as ex:
            flash(ex.getMessage())
            print(ex.getMessage())
            return render_template('login.html', u=_username, r=request)
        except Exception as ex:
            print(str(ex))
            return render_template('login.html', u=_username, r=request)
        login_user(_user, remember = False, fresh = True)
        flash('Login successfully.')
        return redirect(request.args.get("next") or "/")

    return render_template('login.html', u=_username)

@auth_bp.route("/logout")
@login_required
def logout():
    logout_user()
    try:
        _icatSessionId = session.get("icatSessionId", None)
        if _icatSessionId is not None:
            #_icatSession = icat.Session(icatService, _icatSessionId)
            _icatSession = icatHelper.getSessionById(_icatSessionId)
            icatHelper.logoutIcat(_icatSession)
    except:
        pass
    clearSession()
    _username = None
    flash("You have logout successfully")
    return redirect("/")

@login_manager.unauthorized_handler
def unauthorized():
    return render_template('login.html')

def clearSession():
    session.pop('username', None)
    session.pop('icatSessionId', None)
    session.clear()
