# -*- coding: utf-8 -*-

"""
    :author: Ming Tang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from . import icat

def try_login(icatHelper, username, password, plugin = "ldap"):
    _icatSession = icatHelper.loginIcat(username, password, plugin)
    _username = _icatSession.getUserName()
    _icatUser = icatHelper.getIcatUserByName(_icatSession, _username)
    _userId = _icatUser['id']
    _user = User()
    _user.name = _username
    _user.id = _userId
    _user.icatSessionId = _icatSession.sessionId
    _user.isAuthenticated = True
    _user.isAnonymous = False
    _user.isActive = True
    return _user

class User():
    def __init__(self, id =  None, name = None, icatSessionId =None, isAuthenticated = False, isAnonymous = True, isActive = False):
        self.id = id
        self.name = name
        self.icatSessionId = icatSessionId
        self.isAuthenticated = isAuthenticated
        self.isAnonymous = isAnonymous
        self.isActive = isActive

    def is_authenticated(self):
        return self.isAuthenticated

    def is_active(self):
        return self.isActive

    def is_anonymous(self):
        return self.isAnonymous

    def get_id(self):
        return self.id

    def __str__(self):
        return str(self.__dict__)

    def toJson(self):
        return json.dumps(self, default=lambda o: o.__dict__)

class PermissionChecker(object):
    def __init__(self):
        pass

    @classmethod
    def isSessionValid(self, icatSession):
        try:
            if icatSession.getRemainingMinutes() > 0:
                return True
            return False
        except icat.IcatException:
            return False

    @classmethod
    def isInstrumentScientist(self, icatSession, beamlineName):
        try:
            _username = icatSession.getUserName()
            _scientists = icatSession.search("SELECT u.name FROM User u JOIN u.instrumentScientists isc JOIN isc.instrument inst WHERE inst.name='%s'" % (str(beamlineName).upper()))
            return _username in _scientists
        except icat.IcatException:
            return False

    @classmethod
    def isProposalOwner(self, icatSession, proposalId):
        try:
            _username = icatSession.getUserName()
            _proposals = icatSession.search("SELECT i.id FROM Investigation i JOIN i.investigationUsers iu JOIN iu.user u WHERE u.name='%s'" % (str(_username)))
            return int(proposalId) in _proposals
        except icat.IcatException as ex:
            return False

    @classmethod
    def isDatasetsOwner(self, icatSession, proposalId, datasetIdList):
        if not self.isProposalOwner(icatSession, proposalId):
            return False
        try:
            _datasets = icatSession.search("SELECT d.id FROM Dataset d JOIN d.investigation i WHERE i.id=%i" % (int(proposalId)))
            for _id in datasetIdList:
                if int(_id) not in _datasets:
                    return False
            return True
        except icat.IcatException as ex:
            return False

    @classmethod
    def isPublicProposal(self, icatSession, proposalId):
        try:
            _pub_proposals = icatSession.search("SELECT i FROM Investigation i WHERE i.releaseDate < CURRENT_TIMESTAMP")
            return int(proposalId) in _pub_proposals
        except icat.IcatException as ex:
            return False

    @classmethod
    def isPublicDatasets(self, icatSession, proposalId, datasetIdList):
        if not self.isPublicProposal(icatSession, proposalId):
            return False
        try:
            _pub_datasets = icatSession.search("SELECT d.id FROM Dataset d JOIN d.investigation i WHERE i.id=%i" % (int(proposalId)))
            for _id in datasetIdList:
                if int(_id) not in _pub_datasets:
                    return False
            return True
        except icat.IcatException as ex:
            return False

    @classmethod
    def isAccessPermitted(self, icatSession, proposalId, datasetIdList = []):
        if self.isProposalOwner(icatSession, proposalId):
            if len(datasetIdList):
                return self.isDatasetsOwner(icatSession, proposalId, datasetIdList)
            else:
                return True
        elif self.isPublicProposal(icatSession, proposalId):
            if len(datasetIdList):
                return self.isPublicDatasets(icatSession, proposalId, datasetIdList)
            else:
                return True
        else:
            return False
