# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from app.sans import sans_bp

import os
import sys
import random
import time
import json
from flask import session, render_template, url_for, send_from_directory, request, flash
from flask_login import LoginManager, current_user, login_required, login_user, logout_user
from flask_socketio import emit, Namespace
import signal
from flask import current_app as app
from app.jobs import plot_trans_empty_trans, plot_trans_sample_trans, cal_trans
from app.auth import icat_helper, auth_helper, auth
from app import socketio
from app import myredis

global ipList
ipList={}
global nsList
nsList={}

class myNamespace(Namespace):
    def __init__(self, namespace=None, check=False):
        super().__init__()
        self.namespace = namespace

    def on_plot_trans_empty_trans(self, data):
        print("<==================================")
        print("on plot trans empty trans")
        print (self.namespace[0:]," to redis", data)

        #data['Trans_SampleTransRun']=['RUN0006095']
        #data['Trans_EmptyTransRun']=['RUN0006096']
        #job = myrq.get_queue().enqueue(plotTrans, args=(self.namespace, data))
        #job = myrq.get_queue(name=plotTrans).enqueue(args=(self.namespace, data))
        job=plot_trans_empty_trans.queue(self.namespace, data)
        
    def on_plot_trans_sample_trans(self, data):
        print("<==================================")
        print("on plot trans sample trans")
        print (self.namespace[0:]," to redis", data)

        #data['Trans_SampleTransRun']=['RUN0006095']
        #data['Trans_EmptyTransRun']=['RUN0006096']
        #job = myrq.get_queue().enqueue(plotTrans, args=(self.namespace, data))
        #job = myrq.get_queue(name=plotTrans).enqueue(args=(self.namespace, data))
        job=plot_trans_sample_trans.queue(self.namespace, data)

    def on_cal_trans(self, data):
        print("<==================================")
        print("on cal trans")
        print (self.namespace[0:]," to redis", data)

        #data['Trans_SampleTransRun']=['RUN0006095']
        #data['Trans_EmptyTransRun']=['RUN0006096']
        #job =myrq.get_queue().enqueue(calcTrans, args=(self.namespace, data))
        #job = myrq.get_queue(calcTrans).enqueue(args=(self.namespace, data))
        job=cal_trans.queue(self.namespace, data)

    def on_connect(self):
        print("<==================================")
        print("3: connect")
        myredis.set("flask_client",json.dumps(ipList))
        if True:
            _uuid = self.namespace[1:]
            _ip=dict(request.event['args'][0])['REMOTE_ADDR']
            if _uuid in ipList.keys():
                if ipList[_uuid]!=_ip:
                    ipList[_uuid]=_ip
                    nsList[_uuid]=self
                    print("Warning: ", _uuid, " not match ", _ip)
            else:
                ipList[_uuid]=_ip
                nsList[_uuid]=self
                myredis.set("flask_client",json.dumps(ipList))
                print("Add tab: ", _uuid, _ip)
            print("All clients: ", ipList)
            print("All clients: ", nsList)
        else:
            print("Warning: first contact!")

    def on_disconnect(self):
        print("<==================================")
        print("5: disconnect")
        try:
            _uuid = self.namespace[1:]
            if _uuid in ipList.keys():
                ipList.pop(_uuid)
                nsList.pop(_uuid)
                myredis.set("flask_client",json.dumps(ipList))
                print("Loss tab: ", _uuid)
        except:
            print("Warning: something wrong ", ipList)

        print("All clients: ", ipList)
        print("All clients: ", nsList)

@sans_bp.route('/')
def index():
    if 'icatSessionId' in session:
        _icatSession = auth_helper.icatHelper.getSessionById(session['icatSessionId'])
        if auth.PermissionChecker.isSessionValid(_icatSession):
            _icatSession.refresh()
        else:
            auth_helper.learSession()
    else:
        auth_helper.clearSession()

    _username = session.get('username', None)
    _p = []
    if _username is not None:
        _session = auth_helper.icatHelper.getSessionById(session['icatSessionId'])
        _facilities = _session.search('SELECT f FROM Facility f')
        _proposals = auth_helper.icatHelper.getOwnProposals(_session)
        for _proposal in _proposals:
            _temp = {}
            _id = _proposal['Investigation']['id']
            _datasets = auth_helper.icatHelper.getDatasetsForProposal(_session, _id)
            _facility = auth_helper.icatHelper.getFacilityForProposal(_session, _id)
            _instruments = auth_helper.icatHelper.getInstrumentsForProposal(_session, _id)
            _temp['id'] = _id
            _temp['investigation'] = _proposal['Investigation']
            _temp['datasets'] = _datasets
            _temp['facility'] = _facility
            _temp['instruments'] = _instruments
            _p.append(_temp)
    return render_template('index.html', proposals = _p)

@sans_bp.route('/favicon.ico')
def favicon():
    return send_from_directory(os.path.join(app.root_path, 'static'), 'img/csns-logo.png', mimetype='image/png')

@sans_bp.route('/sans/analysis', methods=['GET','POST'])
@login_required
def analysis():
    if request.method == 'POST':
        _facility_id = request.form['f_id']
        _instrument_id = request.form['i_id']
        _proposal_id = request.form['p_id']
        _uuid = request.form['uuid']
    else:
        _proposal_id = request.args.get('p_id')
        _uuid = request.args.get('uuid')

    print("<==================================")
    print("analysis")

    _icatSessionId = session.get("icatSessionId", None)
    if _icatSessionId is None:
        return redirect('/login')

    try:
        _icatSession = auth_helper.icatHelper.getSessionById(_icatSessionId)
        if not auth.PermissionChecker.isSessionValid(_icatSession):
            return redirect('/login')

        if auth.PermissionChecker.isAccessPermitted(_icatSession, int(_proposal_id)):
            _proposal = auth_helper.icatHelper.getProposalById(_icatSession, int(_proposal_id))
        else:
            print('Access not permitted')

        _ip=request.remote_addr
        if _uuid in ipList.keys():
            if ipList[_uuid]!=_ip:
                print(_uuid, " not match ", _ip)
            _success=False
        else:
            ipList[_uuid]=_ip
            nsList[_uuid]=myNamespace('/'+ _uuid)
            myredis.set("flask_client",json.dumps(ipList))
            _success=True

        if _success:
            print("create new tab: ", _uuid)
        else:
            print("refresh old tab: ", _uuid)

        socketio.on_namespace(myNamespace('/'+ _uuid))
    except Exception as ex:
        flash(str(ex))

    print("<==================================")
    return render_template('analysis.html', proposal=_proposal, uuid = _uuid)
 
def clearon():
    #myredis.delete("flask_client")
    try:
        _ipList=myredis.get("flask_client")
        _ipList=json.loads(_iplist)
    except:
        _ipList={}

    print("info: restore the existing connections: ",_ipList)
    for (k,v) in _ipList.items():
        socketio.on_namespace(myNamespace("/"+k, True))
