# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

# default Websocket transport using eventlet 
import eventlet
eventlet.monkey_patch()

from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_redis import FlaskRedis
from flask_rq2 import RQ
from flask_socketio import SocketIO
from flask_bcrypt import Bcrypt

# define
mybcrypt = Bcrypt()

# define db
mydb = SQLAlchemy()

# define redis
myredis = FlaskRedis(strict=True)

# define rq
myrq=RQ(burst=True)

# define socketio
socketio = SocketIO(logger=False, engineio_logger=False, async_mode="eventlet", allow_upgrades=True, monitor_clients=False, always_connect=False)

def create_app():
    """Initialize the core application."""
    app = Flask(__name__, instance_relative_config=False)
    #app.config.from_object('config.development')
    app.config.from_pyfile('config/development.py')

    # Initialize Plugins
    mybcrypt.init_app(app)
    mydb.init_app(app)
    myredis.init_app(app)
    #from app.jobs import myrq
    myrq.init_app(app)
    socketio.init_app(app, message_queue=app.config['REDIS_URL'])
    
    with app.app_context():
        from app.sans import sans_bp
        app.register_blueprint(sans_bp)
        from app.auth import auth_bp
        app.register_blueprint(auth_bp)
        return app
