# -*- coding: utf-8 -*-

"""
    :author: Ming Tang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

from flask import Flask, session, flash, redirect, request, render_template
from flask_login import LoginManager, current_user, login_required, login_user, logout_user
from flask_socketio import SocketIO
from icat_helper import IcatHelper
import auth
import icat
import os
import datetime
import rq
import redis
from auth import PermissionChecker

icatHelper = IcatHelper("https://test.csns.ihep.ac.cn:8181")

#app = Flask(__name__)
app = Flask('analysi_app')
app.secret_key = b'\xa0?$0\xd1\x00F\x12\xc8OX\x8d1k\xed\xa5\x11|`\xc3\x87\xb5\xc4\xc1'
app.config['SECRET_KEY'] = os.urandom(64)
app.config['PERMANENT_SESSION_LIFETIME'] = datetime.timedelta(days=7)
app.config['REDIS_URL'] = "redis://:sanlie;123@10.1.31.120:9000/0"

login_manager = LoginManager()
login_manager.session_protection = "strong"
login_manager.init_app(app)
login_manager.login_view= "login"

app.queue = rq.Queue('tasks', connection=redis.Redis.from_url(app.config['REDIS_URL']))
socketio = SocketIO(app, logger=False, engineio_logger=False, async_mode="eventlet", allow_upgrades=True, monitor_clients=False, always_connect=False)
socketio.init_app(app, message_queue=app.config['REDIS_URL'])


@login_manager.user_loader
def load_user(id):
    if id == None:
        return None

    _icatSessionId = session.get("icatSessionId", None)
    if _icatSessionId is None:
        return None

    try:
        _icatSession = icatHelper.getSessionById(_icatSessionId)
        _icatUser = icatHelper.getIcatUserById(_icatSession, id)
        if _icatUser is None:
            return None
        _user = auth.User()
        _user.id = _icatUser['id']
        _user.icatSessionId = _icatSession.sessionId
        _user.name = _icatUser['name']
        #_user.icatSessionId = _icatSessionId
        _user.isAuthenticated = True
        _user.isAnonymous = False
        _user.isActive = True
        return _user
    except Exception as ex:
        return None

@app.route("/login", methods=['GET', 'POST'])
def login():
    _username = ""
    try:
        if current_user.is_authenticated:
            flash('You have been logged in')
            return redirect(request.args.get("next") or "/")
    except:
        pass

    if request.method == 'POST':
        _username = request.form.get('username')
        _password = request.form.get('password')
        _user = None
        try:
            _user = auth.try_login(icatHelper, _username, _password)
            session['icatSessionId'] = _user.icatSessionId
            session['username'] = _user.name
        except icat.IcatException as ex:
            flash(ex.getMessage())
            print(ex.getMessage())
            return render_template('login.html', u=_username, r=request)
        except Exception as ex:
            print(str(ex))
            return render_template('login.html', u=_username, r=request)
        login_user(_user, remember = False, fresh = True)
        flash('Login successfully.')
        return redirect(request.args.get("next") or "/")

    return render_template('login.html', u=_username)

@app.route("/logout")
@login_required
def logout():
    logout_user()
    try:
        _icatSessionId = session.get("icatSessionId", None)
        if _icatSessionId is not None:
            #_icatSession = icat.Session(icatService, _icatSessionId)
            _icatSession = icatHelper.getSessionById(_icatSessionId)
            icatHelper.logoutIcat(_icatSession)
    except:
        pass
    clearSession()
    _username = None
    flash("You have logout successfully")
    return redirect("/")

@login_manager.unauthorized_handler
def unauthorized():
    return render_template('login.html')

def clearSession():
    session.pop('username', None)
    session.pop('icatSessionId', None)
    session.clear()
