# -*- coding: utf-8 -*-

"""
    :author: Junrong Zhang
    :copyright: © 2020 CSNS
    :license: GPL V3, see LICENSE for more details.
"""

import numpy as np

def hcline(data, name, *args, **kwargs):
    '''
    data: array[x, y1, y2 ....]
    name: array[y1, y2 ...]
    '''
    
    output={}
    
    output['chart']={}
    output['chart']['type']='line'

    if "title" in kwargs:
        output['title']={"text": kwargs["title"]}

    if "xlabel" in kwargs:
        output['xAxis']={}
        output['xAxis']['title']={"text": kwargs["xlabel"]}
    
    if "xlog" in kwargs:
        output['xAxis']={}
        output['xAxis']['type']="logarithmic"
        #output["xAxis"]["type"] = "datetime"
    
    if "xdate" in kwargs:
        output['xAxis']={}
        output["xAxis"]["type"] = "datetime"

    if "xmin" in kwargs:
        output['xAxis']={}
        output['xAxis']['min']=kwargs["xmin"]

    if "xmax" in kwargs:
        output['xAxis']={}
        output['xAxis']['max']=kwargs["xmax"]

    if "ylabel" in kwargs:
        output['yAxis']={}
        output['yAxis']['title']={"text": kwargs["ylabel"]}

    if "ylog" in kwargs:
        output['yAxis']={}
        output['yAxis']['type']="logarithmic"
    
    if "ydate" in kwargs:
        output['yAxis']={}
        output["yAxis"]["type"] = "datetime"

    if "ymin" in kwargs:
        output['yAxis']={}
        output['yAxis']['min']=kwargs["xmin"]

    if "ymax" in kwargs:
        output['yAxis']={}
        output['yAxis']['max']=kwargs["ymax"]

    if "zoom" in kwargs:
        if kwargs["zoom"] not in ("x", "y", "xy"):
            raise ValueError("zoom must be in ('x', 'y', 'xy')")
        output["chart"]["zoomType"] = kwargs["zoom"]

    if len(name)!=len(data)-1:
            raise ValueError("data column must match")

    _series=[]
    for i in range(1,len(name)+1):
        _line={}
        _point = []
        for j in range(len(data[0])):
            _point.append([data[0][j], data[i][j]])

        _line['name']=name[i]
        _line['data']=_point

        _series.append(_line)


    output["series"]=_series

    return output
