'''
Created on 2015.6.2
@author: yll
'''
# configure
from conf.constants import *

# user defined
from model.readData import *
from model.slitModel import *
from presenter.slitSignal import *
from viewer.canvas import *

class CSNSSlitPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSSlitPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
#        self.horizontalLayoutWidget = QtGui.QWidget(self.tab_slit)
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        #slit tab control
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)
         
        # canvas for slitImage
        #self.slitImageCanvas= CSNSCanvas(self)
        self.slitImageCanvas = figureCanvas(
            self,
            6,
            8,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            )

        #self.dataX, self.dataY, self.dataZ = CSNSRead3DData("./dat/3d1.dat")
        #self.slitImageCanvas.clear()
        #cset = self.slitImageCanvas.ax.contourf(self.dataY, self.dataX, self.dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        self.slitImageCanvas.x1 = self.slitImageCanvas.ax.axhline(52,color='gray')
        self.slitImageCanvas.x2 = self.slitImageCanvas.ax.axhline(48,color='gray')
        self.slitImageCanvas.y1 = self.slitImageCanvas.ax.axvline(48,color='gray')
        self.slitImageCanvas.y2 = self.slitImageCanvas.ax.axvline(52,color='gray')
        self.slitImageCanvas.draw()

        self.slitImageEvents()

        _xsize = 3
        _ysize = 2

        # canvas for slit x
        #self.slitXCanvas = CSNSCanvas(self, 3, 2)
        self.slitXCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            )

        #nx, dataX = CSNSRead2DData("./dat/2d-x.dat")
        #_tmp=self.slitXCanvas.ax.plot(dataX[0],dataX[1],color='red')
        #self.slitXCanvas.slitXFigure=_tmp[0]
        #self.slitXCanvas.draw()

        # canvas for slit y
        #self.slitYCanvas = CSNSCanvas(self, 3, 2)
        self.slitYCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            )

        #ny, dataY = CSNSRead2DData("./dat/2d-y.dat")
        #_tmp=self.slitYCanvas.ax.plot(dataY[0],dataY[1],color='green')
        #self.slitYCanvas.slitYFigure=_tmp[0]
        #self.slitYCanvas.draw()

        # parameter grid
        self.directBeamLabel =  QtGui.QLabel("<font color=red>Direct Beam:</font>")
        self.directBeamText=QtGui.QLabel("( , ) ")

        self.reflectedBeamLabel =  QtGui.QLabel("<font color=red>Reflected Beam:</font>")
        self.reflectedBeamText=QtGui.QLabel("( , )")

        _nline = 0
        self.mainGrid.addWidget(self.slitImageCanvas,_nline,0,2,5)
        self.mainGrid.addWidget(self.slitXCanvas,_nline,5,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.slitYCanvas,_nline,5,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.directBeamLabel,_nline,0,1,1)
        self.mainGrid.addWidget(self.directBeamText,_nline,1,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.reflectedBeamLabel,_nline,0,1,1)
        self.mainGrid.addWidget(self.reflectedBeamText,_nline,1,1,1)

        self.horizontalLayout.addWidget(self.scrollArea)

    def slitImageEvents(self):
        self.slitImageCanvas.mpl_connect('button_press_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)
        self.slitImageCanvas.mpl_connect('button_press_event', self.changeXYFigure)

    def changeRegion(self,event):
        _canvas = self.slitImageCanvas

        if event.button == 1:
            _canvas.x1.set_ydata([event.ydata,event.ydata])
            _canvas.draw()
            self.slitXCanvas.draw()
        elif event.button == 3:
            _canvas.y1.set_xdata([event.xdata,event.xdata])
            _canvas.draw()
        else:
            pass

    def changeXYFigure(self,event):

        if event.button == 1:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitXCanvas.slitXFigure.set_xdata(dataYZ[0])
            self.slitXCanvas.slitXFigure.set_ydata(dataYZ[1])
            self.slitYCanvas.slitYFigure.set_xdata(dataXZ[0])
            self.slitYCanvas.slitYFigure.set_ydata(dataXZ[1])
            self.slitXCanvas.draw()
            self.slitYCanvas.draw()
        elif event.button == 3:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitYCanvas.slitYFigure.set_xdata(dataXZ[0])
            self.slitYCanvas.slitYFigure.set_ydata(dataXZ[1])
            self.slitYCanvas.draw()
        else:
            pass
