#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from detector import *
from slit import *
from monitor import *
from analysis import *
from reflectivity import *
from experiment import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.detectorPage = CSNSDetectorPage(self)
        self.slitPage = CSNSSlitPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.analysisPage = CSNSAnalysisPage(self)
        self.imagePage = CSNSReflectivityPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.detectorPage, 'Reflected spectrum')
        self.addTab(self.slitPage, 'Detector')
        self.addTab(self.monitorPage, 'Monitor Counts')
        self.addTab(self.analysisPage, 'Analysis')
        self.addTab(self.imagePage, 'Image')
        self.addTab(self.experimentPage, 'Experiment Progress')
    
        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getHistogramPath(self):
        groupStatus = []
        groupTOFPath = []
        groupCountsPath = []
        for i in range(len(self.histogramPage.patternDock)):
            groupStatus.append(self.histogramPage.patternDock[i].pauseButton.text())
            groupTOFPath.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/tof')
            groupCountsPath.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/counts')
        return groupStatus, groupTOFPath, groupCountsPath

    def getDetectorPath(self):
        pidXaxisPath = []
        pidValuePath = []
        xyXaxisPath = []        
        xyYaxisPath = []        
        xyValuePath = []        
        for i in range (bankIndex+1):
            pidXaxisPath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/pid_image/x")
            pidValuePath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/pid_image/value")
            xyXaxisPath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/xy_image/x") 
            xyYaxisPath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/xy_image/y") 
            xyValuePath.append("/GPPD/workspace/MantidData/bank"+str(bankIndex+1).zfill(2)+"/xy_image/value") 
        return pidXaxisPath, pidValuePath, xyXaxisPath, xyYaxisPath, xyValuePath

    def getMonitorPath(self):
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            monitorAxisXPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_x')
            monitorAxisYPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_y')
            monitorValuePath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/value')
            monitorTOFPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/tof')
            monitorCountsPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/counts')
        return monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath

    def getExperimentPath(self):
        protonPath = []
        neutronPath = []
        pulsePath = []
        protonPath='/GPPD/drone/proton_charge'
        neutronPath='/GPPD/workspace/MantidData/neutron_counts'
        pulsePath='/GPPD/drone/pulse_counts'
        return protonPath, neutronPath, pulsePath
    
    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        groupStatus = []
        groupTOFPath = []
        groupCountsPath = []
        pidXaxisPath = []
        pidValuePath = []
        xyXaxisPath = []
        xyYaxisPath = []
        xyValuePath = []
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        protonPath = []
        neutronPath = []
        pulsePath = []
        tabIndex = self.currentIndex()

        if tabIndex == 0:
            pass
            #groupStatus, groupTOFPath, groupCountsPath = self.getHistogramPath() 
            #kwargs = {"tabIndex": tabIndex, "path1": groupCountsPath, "path2": groupTOFPath,  "status": groupStatus}
        elif tabIndex == 1:
            pass
            #pidXaxisPath, pidValuePath, xyXaxisPath, xyYaxisPath, xyValuePath = self.getDetectorPath()
            #kwargs = {'tabIndex': tabIndex, 'path1': pidXaxisPath, 'path2': pidValuePath, 'path3': xyXaxisPath, 'path4': xyYaxisPath, 'path5': xyValuePath}
        elif tabIndex == 2:
            monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath = self.getMonitorPath()
            kwargs = {"tabIndex": tabIndex, "path1": monitorValuePath, "path2": monitorAxisXPath, "path3": monitorAxisYPath, "path4": monitorTOFPath,"path5": monitorCountsPath, "status": monitorStatus}

        elif tabIndex == 3:
            protonPath, neutronPath, pulsePath = self.getExperimentPath()
            kwargs = {"tabIndex": tabIndex, "path1": pulsePath, "path2": protonPath, "path3": neutronPath}
       
        #self.parent.setDataPath(kwargs)


