#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined

from canvas import *
from conf.constants import *
import time
import redis
from model import jsonArray
import numpy as np

class CSNSReflectionPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSReflectionPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.neutron = QtGui.QFrame(self)
        self.neutron.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaNeutron = QtGui.QScrollArea()
        self.scrollAreaNeutron.setWidgetResizable(True)
        self.scrollAreaNeutron.setWidget(self.neutron)
        #self.scrollAreaNeutron.setMinimumWidth(135)
        #self.scrollAreaNeutron.setMinimumHeight(180)
        #self.neutron.setMaximumHeight(450)

        self.line1 = QtGui.QFrame(self)
        self.line1.setGeometry(QtCore.QRect())
        self.line1.setFrameShape(QtGui.QFrame.HLine)
        self.line1.setFrameShadow(QtGui.QFrame.Sunken)

        self.line2 = QtGui.QFrame(self)
        self.line2.setGeometry(QtCore.QRect())
        self.line2.setFrameShape(QtGui.QFrame.HLine)
        self.line2.setFrameShadow(QtGui.QFrame.Sunken)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)
        self.splitter.addWidget(self.scrollAreaNeutron)
        self.splitter.addWidget(self.scrollArea2)

        self.splitter.setSizes([500, 500])  # , 150])

        # main Grid
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.neutronGrid = QtGui.QGridLayout(self.neutron)
        
        self.roiCheckBox = QtGui.QCheckBox('Use ROI', self)
        self.roiCheckBox.stateChanged.connect(self.roiCheckBoxChange)
        #self.button = QtGui.QPushButton('Submit')
        #self.button.setMaximumHeight(30)
        #self.button.setMaximumWidth(70)
        #self.button.clicked.connect(self.buttonClicked)
       
        self.defaultButton = QtGui.QPushButton('Default', self)
        self.defaultButton.setMaximumHeight(30)
        #self.defaultButton.setMaximumWidth(80)
        self.defaultButton.clicked.connect(self.defaultClicked)
 
        self.leftLabel = QtGui.QLabel('Left:',self)
        self.leftLabel.setMaximumWidth(50)
        self.leftTextEdit = QtGui.QTextEdit('87.0')
        #self.leftTextEdit.setMaximumWidth(80)
        self.leftTextEdit.setMaximumHeight(31)
        #self.leftTextEdit.setDisabled(True) 
        self.leftTextEdit.textChanged.connect(self.textChange) 
        self.rightLabel = QtGui.QLabel('Right:',self)
        self.rightLabel.setMaximumWidth(50)
        self.rightTextEdit = QtGui.QTextEdit('97.0')
        #self.rightTextEdit.setMaximumWidth(80)
        self.rightTextEdit.setMaximumHeight(31) 
        #self.rightTextEdit.setDisabled(True) 
        self.rightTextEdit.textChanged.connect(self.textChange) 
        self.topLabel = QtGui.QLabel('Top:',self)
        self.topLabel.setMaximumWidth(50)
        self.topTextEdit = QtGui.QTextEdit('130.0')
        #self.topTextEdit.setMaximumWidth(80)
        self.topTextEdit.setMaximumHeight(31) 
        self.topTextEdit.textChanged.connect(self.textChange) 
        self.bottomLabel = QtGui.QLabel('Bottom:',self)
        self.bottomLabel.setMaximumWidth(60)
        self.bottomTextEdit = QtGui.QTextEdit('0.0')
        #self.bottomTextEdit.setMaximumWidth(80)
        self.bottomTextEdit.setMaximumHeight(31) 
        self.bottomTextEdit.textChanged.connect(self.textChange) 

        self.neutronLabel = QtGui.QLabel('Neutron Range:', self)
        self.neutronLabel.setMaximumHeight(30)
        self.minNeutron = QtGui.QLabel('Min:', self)
        self.minNeutron.setMaximumHeight(30)
        self.minNeutronText = QtGui.QTextEdit('', self)
        self.minNeutronText.setMaximumHeight(30)
        #self.minNeutronText.setMaximumWidth(80)
        self.maxNeutron = QtGui.QLabel('Max:', self)
        self.maxNeutron.setMaximumHeight(30)
        self.maxNeutronText = QtGui.QTextEdit('', self)
        self.maxNeutronText.setMaximumHeight(30)
        #self.maxNeutronText.setMaximumWidth(80)
        self.setButton = QtGui.QPushButton('Set', self)
        self.setButton.setMaximumHeight(30)
        self.setButton.setMaximumWidth(80)
        self.setButton.clicked.connect(self.setButtonClicked)

        self.sendButton = QtGui.QPushButton('Send Online Data', self)
        self.sendButton.setMaximumHeight(30)
        #self.sendButton.setMaximumWidth(80)
        self.sendButton.clicked.connect(self.sendButtonClicked)

        _xsize = 16  # 6
        _ysize = 8  # 3

        '''
        self.canvas1Fig = Figure((5,5), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=True)
        self.canvas1Fig.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.canvas1 = FigureCanvas(self.canvas1Fig)
        self.canvas1.setParent(self)
        self.canvas1.ax = self.canvas1Fig.add_subplot(111,projection='3d')
        self.canvas1.ax.tick_params(axis='both', which='major', labelsize=0.1)
        self.canvas1.ax.axis('off')
        self.canvas1.ax.set_xlabel('qx')
        self.canvas1.ax.set_ylabel('qy')
        '''
        self.canvas1 = refCanvas(  # _xsize,
                                    # _ysize,
                                    # self.plotColor,
                                    # self.title,
            self,
            10,
            10,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )

        self.pix = None
        self.canvas1.ax.set_aspect('equal')
        self.canvas1.draw()
        self.canvas2 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'TOF / us',
            'Neutron Counts',
            )

        self.canvas3 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Scattering Intensity',
            )
        self.comboBoxUnit1 = QtGui.QComboBox()
        self.comboBoxUnit1.addItem('TOF')
        self.comboBoxUnit1.addItem('theta')
        self.comboBoxUnit1.addItem('Wavelength')
        self.comboBoxUnit1.setMaximumWidth(150)
        self.comboBoxUnit1.activated.connect(self.comboBoxUnit1Change)
        self.comboBoxLog1 = QtGui.QComboBox()
        self.comboBoxLog1.addItem('linear')
        self.comboBoxLog1.addItem('logarithmic')
        self.comboBoxLog1.setMaximumWidth(150)
        self.comboBoxLog1.activated.connect(self.comboBoxLog1Change)

        self.normLabel = QtGui.QLabel('Normalization by')
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        self.comboBoxNorm.setCurrentIndex(1)
        self.comboBoxNorm.activated.connect(self.comboNormChange)
        self.comboBoxLog2x = QtGui.QComboBox()
        self.comboBoxLog2x.addItem('x:linear')
        self.comboBoxLog2x.addItem('x:logarithmic')
        self.comboBoxLog2x.setMaximumWidth(150)
        self.comboBoxLog2x.activated.connect(self.comboBoxLog2xChange)
        self.comboBoxLog2y = QtGui.QComboBox()
        self.comboBoxLog2y.addItem('y:linear')
        self.comboBoxLog2y.addItem('y:logarithmic')
        self.comboBoxLog2y.setMaximumWidth(150)
        self.comboBoxLog2y.activated.connect(self.comboBoxLog2yChange)

        _nline = 1
        self.neutronGrid.addWidget(self.line1, _nline, 0, 1,8, QtCore.Qt.AlignBottom)
        _nline += 1
        self.neutronGrid.addWidget(self.roiCheckBox, _nline, 0, 1, 1, QtCore.Qt.AlignBottom)
        self.neutronGrid.addWidget(self.defaultButton, _nline, 6, 1, 2, QtCore.Qt.AlignBottom)
        _nline += 1
        self.neutronGrid.addWidget(self.leftLabel, _nline, 0, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.leftTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.rightLabel, _nline, 2, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.rightTextEdit, _nline, 3, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.bottomLabel, _nline, 4, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.bottomTextEdit, _nline, 5, 1, 1, QtCore.Qt.AlignRight)
        #_nline += 1
        self.neutronGrid.addWidget(self.topLabel, _nline, 6, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.topTextEdit, _nline, 7, 1, 1, QtCore.Qt.AlignRight)
        #_nline += 1
        #self.neutronGrid.addWidget(self.topLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        #self.neutronGrid.addWidget(self.topTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)
        #_nline += 1
        #self.neutronGrid.addWidget(self.bottomLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        #self.neutronGrid.addWidget(self.bottomTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)
        #_nline += 1
        #self.neutronGrid.addWidget(self.line2, _nline, 0, 1,4, QtCore.Qt.AlignBottom)
        _nline += 1
        self.neutronGrid.addWidget(self.neutronLabel, _nline, 0, 1, 1, QtCore.Qt.AlignBottom)
        _nline += 1
        self.neutronGrid.addWidget(self.setButton, _nline, 4, 1, 1,QtCore.Qt.AlignLeft)
        self.neutronGrid.addWidget(self.minNeutron, _nline, 0, 1, 1, QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.minNeutronText, _nline, 1, 1, 1, QtCore.Qt.AlignRight)
        #_nline += 1
        self.neutronGrid.addWidget(self.maxNeutron, _nline, 2, 1, 1,QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.maxNeutronText, _nline, 3, 1, 1,QtCore.Qt.AlignRight)
        self.neutronGrid.addWidget(self.sendButton, _nline, 6, 1, 2,QtCore.Qt.AlignRight)
        #_nline += 1

        _nline = 0
        #self.firstGrid.addWidget(self.scrollAreaNeutron, _nline, 0, 1, 1)
        self.neutronGrid.addWidget(
            self.canvas1,
            _nline,
            0,
            1,
            8,
            #QtCore.Qt.AlignCenter | QtCore.Qt.AlignBottom,
            )

        _nline = 0
        self.secondGrid.addWidget(self.comboBoxUnit1, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.comboBoxLog1, _nline, 1, 1, 1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas2, _nline, 0, 1, 7)
        _nline += 1
        self.secondGrid.addWidget(self.normLabel, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.comboBoxNorm, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.comboBoxLog2x, _nline, 2, 1, 1)
        self.secondGrid.addWidget(self.comboBoxLog2y, _nline, 3, 1, 1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas3, _nline, 0, 1, 7)

        self.verticalLayout.addWidget(self.splitter)

        self.tube1Check = True
        self.tube2Check = True
        self.tube3Check = True
        self.tube4Check = True

        self.roiCheckBoxIndex = 0
        self.colorbar = None
        self.zoomClick = False
        self.zoomSelected = False
        self.roiSelected = False
        self.value = None
        self.neonServer = None

        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

        self.color3D = cm.rainbow

        self.initRoi()
        #self.clearRoi()
    '''
    def buttonClicked(self):
        coord = {}
        path = '/MR/workspace/MantidData/roi'
        if self.roiCheckBoxIndex == 1:
            self.roiSelected = True
        try:
            if self.neonServer == None:
                (neonStatus, self.neonServer) = \
                    self.parent.parent.parent.getNeon()
            if self.roiCheckBoxIndex == 0:
                coord['pos'] = [self.canvas1.x1, self.canvas1.y1, self.canvas1.x2, self.canvas1.y2]
            else:
                coord['pos'] = self.getPos()
                self.canvas1.setRect(coord['pos'])
            _num = self.getComboBoxTube() + 1
            coord['tubeNo'] = _num
            coord['roi'] = self.roiSelected
            _coord_json = jsonArray.jsonEncoder(coord)
            self.neonServer.set(path, _coord_json)
        except:
            pass
        self.parent.tabChange()
        self.getReflectionData()
    '''

    def defaultClicked(self):
        self.leftTextEdit.setText(format(87,'.2f'))
        self.rightTextEdit.setText(format(97,'.2f'))
        self.topTextEdit.setText(format(130,'.2f'))
        self.bottomTextEdit.setText(format(60,'.2f'))

    def sendButtonClicked(self):
        path = '/MR/workspace/MantidData/SendOnline'
        if self.neonServer == None:
            (neonStatus, self.neonServer) = \
                    self.parent.parent.parent.getNeon()
        self.neonServer.set(path, jsonArray.jsonEncoder(1))

    def setButtonClicked(self):
        #try:
        if self.setButton.text() == 'Auto':
            self.canvas1.ax.clear()
            self.pix1 = \
                    self.canvas1.ax.pcolormesh(self.value[0], self.value[1], self.value[2], cmap=self.color3D)
            self.canvas1.ax.set_aspect('equal')
            self.canvas1.draw()
            self.setButton.setText('Set')
        elif self.setButton.text() == 'Set':
            if (self.minNeutronText.toPlainText() != '') & (self.maxNeutronText.toPlainText() != ''):
                self.minZ = float(self.minNeutronText.toPlainText())
                self.maxZ = float(self.maxNeutronText.toPlainText())
                self.canvas1.ax.clear()
                self.pix1 = \
                    self.canvas1.ax.pcolormesh(self.value[0], self.value[1], self.value[2], cmap=self.color3D)
                self.pix1.set_clim(self.minZ,self.maxZ)
                self.canvas1.ax.set_aspect('equal')
                self.canvas1.draw()
                self.setButton.setText('Auto')
            elif self.minNeutronText.toPlainText() == '':
                msgBox = QtGui.QMessageBox.information(self,"Warning","Min Text can not be empty.",QtGui.QMessageBox.Yes)
            elif self.maxNeutronText.toPlainText() == '':
                msgBox = QtGui.QMessageBox.information(self,"Warning","Max Text can not be empty.",QtGui.QMessageBox.Yes)
            else:
                pass
        else:
            pass
        #except:
        #    pass

    def setPos(self,x1,y1,x2,y2):
        self.leftTextEdit.setText(format(min(x1,x2),'.2f'))
        self.rightTextEdit.setText(format(max(x1,x2),'.2f'))
        self.topTextEdit.setText(format(max(y1,y2),'.2f'))
        self.bottomTextEdit.setText(format(min(y1,y2),'.2f'))

    def getPos(self):
        x1 = float(self.leftTextEdit.toPlainText())
        #y1 = 0.0
        y1 = float(self.topTextEdit.toPlainText())
        x2 = float(self.rightTextEdit.toPlainText())
        #y2 = 0.0
        y2 = float(self.bottomTextEdit.toPlainText())
        return [x1, y1, x2, y2]

    def roiCheckBoxChange(self):
        if self.roiCheckBox.isChecked():
            self.roiCheckBoxIndex = 1
            self.zoomSelected = True
            self.roiSelected = True
            self.canvas2.zoomSelected = True
            #[_x1,_y1,_x2,_y2] = self.getPos()
        else:
            self.roiCheckBoxIndex = 0
            self.roiSelected = False
            self.zoomSelected = False
            self.canvas2.zoomSelected = False
            self.canvas1.setRect([0,0,0,0])
            self.canvas1.draw()
        self.setRoi()

    def roiSelectedFunc(self):
        return self.roiSelected

    def textChange(self):
        self.setRoi()

    def clearRoi(self):
        coord = {}
        path = '/MR/workspace/MantidData/roi'
        if self.neonServer == None:
            (neonStatus, self.neonServer) = \
                self.parent.parent.parent.getNeon()
        coord['pos'] = [0,200,200,0]
        coord['roi'] = False
        coord['tubeNo'] = 0
        _coord_json = jsonArray.jsonEncoder(coord)
        self.neonServer.set(path, _coord_json)

    def setRoi(self):
        coord = {"roi": True, "pos": [87.0, 130.0, 97.0, 60.0]}
        path = '/MR/workspace/MantidData/roi'
        #try:
        if self.neonServer == None:
            (neonStatus, self.neonServer) = \
                self.parent.parent.parent.getNeon()
        if self.roiCheckBox.isChecked():
            self.roiSelected = True
            self.roiCheckBoxIndex = 1
            coord['pos'] = self.getPos()
            self.canvas1.setRect(coord['pos'])
        else:
            self.roiSelected = False
            self.roiCheckBoxIndex = 0
            coord['pos'] = [self.canvas1.x1, self.canvas1.y1, self.canvas1.x2, self.canvas1.y2]
        #_num = self.getComboBoxTube() + 1
        #coord['tubeNo'] = 1#_num
        coord['tubeNo'] = 0
       
        coord['roi'] = self.roiSelected
        _coord_json = jsonArray.jsonEncoder(coord)
        self.neonServer.set(path, _coord_json)
        #except:
        #    pass
        self.parent.tabChange()
        #self.getReflectionData()

    def tubeCheckBoxChange(self):
        if self.tube1CheckBox.isChecked():
            self.tube1Check = True
        else:
            self.tube1Check = False
        if self.tube2CheckBox.isChecked():
            self.tube2Check = True
        else:
            self.tube2Check = False
        if self.tube3CheckBox.isChecked():
            self.tube3Check = True
        else:
            self.tube3Check = False
        if self.tube4CheckBox.isChecked():
            self.tube4Check = True
        else:
            self.tube4Check = False

    def getTube1Check(self):
        return self.tube1Check

    def getTube2Check(self):
        return self.tube2Check

    def getTube3Check(self):
        return self.tube3Check

    def getTube4Check(self):
        return self.tube4Check

    def comboBoxTubeChange(self):
        index = self.comboBoxTube.currentIndex()
        self.parent.tabChange()
        self.getReflectionData()
        #self.canvas1.ax.set_xlabel('Tube' + str(index + 1))
        self.setRoi()

    def comboBoxUnit1Change(self):
        self.pix2 = None
        self.canvas2.zoomSelected = False
        self.parent.tabChange()
        self.getReflectionData()
        index = self.comboBoxUnit1.currentIndex()
        if index == 0:
            self.canvas2.ax.set_xlabel('TOF / us')  # q (A-1)')
        elif index == 1:
            self.canvas2.ax.set_xlabel('theta')  # q (A-1)')
        elif index == 2:
            self.canvas2.ax.set_xlabel('Wavelength')  # q (A-1)')
        self.canvas2.draw()

    def comboNormChange(self):
        self.pix3 = None
        self.canvas3.zoomSelected = False
        self.parent.tabChange()
        self.getReflectionData()

    def comboBoxLog1Change(self):
        try:
            self.pix2 = None
            self.canvas2.zoomSelected = False
            index = self.comboBoxLog1.currentIndex()
            if index == 0:
                self.canvas2.ax.set_yscale('linear')
            else:
                self.canvas2.ax.set_yscale('log')
            self.canvas2.draw()
        except:
            pass

    def comboBoxLog2xChange(self):
        try:
            self.pix3 = None
            self.canvas3.zoomSelected = False
            index = self.comboBoxLog2x.currentIndex()
            if index == 0:
                self.canvas3.ax.set_xscale('linear')
            else:
                self.canvas3.ax.set_xscale('log')
            self.canvas3.draw()
        except:
            pass

    def comboBoxLog2yChange(self):
        try:
            self.pix3 = None
            self.canvas3.zoomSelected = False
            index = self.comboBoxLog2y.currentIndex()
            if index == 0:
                self.canvas3.ax.set_yscale('linear')
            else:
                self.canvas3.ax.set_yscale('log')
            self.canvas3.draw()
        except:
            pass

    def getComboBoxTube(self):
        index = self.comboBoxTube.currentIndex()
        return index

    
    def getRoiVar(self):
        return self.roiSelected

    def log1Selected(self):
        index = self.comboBoxLog1.currentIndex()
        return index

    def unit1Selected(self):
        index = self.comboBoxUnit1.currentIndex()
        return index

    def log2Selected(self):
        index = self.comboBoxLog2.currentIndex()
        return index

    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        return index

    def getNeon(self):
        (neonStatus, self.neonServer) = \
            self.parent.parent.parent.getNeon()

    def getReflectionData(self):
        self.parent.getReflectionData()
    
    def getRoiInfo(self):
        _roi = {}
        _roi['roiSelected'] = self.roiSelected 
        _roi['roiPos'] = self.getPos()
        return _roi
    
    def setRoiInfo(self):
        return self.parent.setRoiInfo()

    def initRoi(self):
        try:
            _roi = {}
            _roi = self.setRoiInfo()
            self.roiCheckBox.setChecked(_roi['roiSelected'])
            self.setPos(_roi['roiPos'][0], _roi['roiPos'][1],_roi['roiPos'][2],_roi['roiPos'][3])
        except:
            pass

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        self.value = value
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
            #try:
            #(_x, _y)=np.meshgrid(value[0],value[1])
            #self.canvas1.ax.plot_surface(_x, _y, np.array(value[2]), cmap=cm.coolwarm,linewidth=0, antialiased=False)
            #self.canvas1.ax.axis('off')
            #except:
            #    pass
            
        try:
            if str(value[2]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.ax.set_aspect('equal')
                self.canvas1.draw()
            elif not value[2]:
                pass
            elif len(value[2]) == 0 or len(self.value[2]) \
                != len(value[2]):
                self.pix1 = None
            else:
                #if self.pix1 == None:
                self.canvas1.ax.clear()
                # pcolormesh one more data than coutourf x and y add one data to list, the last data add the last two data's seperate
                value[0].append(value[0][-1]+value[0][-1]-value[0][-2])
                value[1].append(value[1][-1]+value[1][-1]-value[1][-2])
                self.pix1 = \
                        self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap=self.color3D)
                #        self.canvas1.ax.contourf(value[0], value[1], value[2], cmap=self.color3D)
                if self.setButton.text() == 'Auto':
                    self.pix1.set_clim(self.minZ,self.maxZ)
                self.canvas1.ax.add_patch(self.canvas1.rect)
                self.canvas1.ax.set_xlabel('X / mm')  # q (A-1)')
                self.canvas1.ax.set_ylabel('Y / mm')
                #else:
                #    self.pix1.set_array(np.array(value[2]).ravel())
                # self.canvas1.ax.axis('equal', adjustable='box')
                try:
                    #if self.canvas1.zoomSelected:
                    #    self.pix1 = None
                    #if self.canvas1.zoomSelected \
                    #    and self.canvas1.minX != self.canvas1.maxX \
                    #    and self.canvas1.minY != self.canvas1.maxY:
                    #    self.canvas1.ax.set_xlim(self.canvas1.minX,
                    #            self.canvas1.maxX)
                    #    self.canvas1.ax.set_ylim(self.canvas1.minY,
                    #            self.canvas1.maxY)
                    if self.canvas1.scale_factor != 1.0:
                        self.canvas1.ax.set_xlim([self.canvas1.xdata - self.canvas1.new_width * (1-self.canvas1.relx), self.canvas1.xdata + self.canvas1.new_width * (self.canvas1.relx)])
                        self.canvas1.ax.set_ylim([self.canvas1.ydata - self.canvas1.new_height * (1-self.canvas1.rely), self.canvas1.ydata + self.canvas1.new_height * (self.canvas1.rely)])

                    if not self.colorbar:
                        self.colorbar = \
                            self.canvas1.fig.colorbar(self.pix1,
                                ax=self.canvas1.ax,
                                extend='max')
                        self.colorbar.ax.tick_params(labelsize=4)
                    elif self.pix1 is None:
                        pass
                    else:
                        self.colorbar.on_mappable_changed(self.pix1)
                except:
                    pass
                self.canvas1.ax.set_aspect('equal')
                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        #try:
        if True:
            if self.roiSelected:
                self.pix2 = None
            if str(value[3]) == 'clear' or str(value[4]) == 'clear':
                self.canvas2.ax.clear()
                self.canvas2.draw()
            elif not value[3]:
                pass
            elif len(value[3]) != len(value[4]) or len(value[4]) \
                == 0:
                pass
            else:
                index = self.comboBoxUnit1.currentIndex()
                
                if index == 2:
                    _before = 0
                    _after = 0
                    for i in range(len(value[4])):
                        if value[4][i] == 0:
                            _before = i
                        else:
                            break

                    for i in range(len(value[4])):
                        if value[4][len(value[4])-1-i] == 0:
                            _after = len(value[4])-1-i
                        else:
                            break

                    #if self.pix2 == None:
                    self.canvas2.ax.clear()
                    #(self.pix2, ) = \
                    self.canvas2.ax.plot(value[3][_before:_after],
                            value[4][_before:_after], color='b')
                else:
                    self.canvas2.ax.clear()
                    self.canvas2.ax.plot(value[3], value[4], color='b') 
                
                self.canvas2.ax.add_patch(self.canvas2.rect)
                #self.roiSelected = False
                self.canvas2.ax.set_ylabel('Neutron Counts')
                
                if index == 0:
                    self.canvas2.ax.set_xlabel('TOF / us')  # q (A-1)')
                elif index == 1:
                    self.canvas2.ax.set_xlabel('theta')  # q (A-1)')
                elif index == 2:
                    self.canvas2.ax.set_xlabel('Wavelength')  # q (A-1)')
                #else:
                    # self.pix2.set_xdata(value[3])
                    #self.pix2.set_ydata(value[4])
                if self.canvas2.zoomSelected \
                    and self.canvas2.minX != self.canvas2.maxX \
                    and self.canvas2.minY != self.canvas2.maxY:
                    self.canvas2.ax.set_xlim(self.canvas2.minX,
                            self.canvas2.maxX)
                    self.canvas2.ax.set_ylim(self.canvas2.minY,
                            self.canvas2.maxY)
                elif self.canvas2.scale_factor != 1.0:
                    self.canvas2.ax.set_xlim([self.canvas2.xdata - self.canvas2.new_width * (1-self.canvas2.relx), self.canvas2.xdata + self.canvas2.new_width * (self.canvas2.relx)])
                    self.canvas2.ax.set_ylim([self.canvas2.ydata - self.canvas2.new_height * (1-self.canvas2.rely), self.canvas2.ydata + self.canvas2.new_height * (self.canvas2.rely)])

                _index = self.comboBoxLog1.currentIndex()
                try:
                    if _index == 0:
                        self.canvas2.ax.set_yscale('linear')
                    else:
                        #if 0 not in value[4]:
                        self.canvas2.ax.set_yscale('log')
                except:
                    pass
                self.canvas2.ax.relim()
                self.canvas2.ax.autoscale_view()
                self.canvas2.draw()
        #except:
        #    pass
            #self.pix2 = None
        try:
            if str(value[5]) == 'clear' or str(value[6]) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif not value[5]:
                pass
            elif len(value[5]) != len(value[6]) or len(value[6]) \
                == 0:
                    pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
          
                # cut y not 0 from the last index 
                _before = 0 
                _after = 0 
                for i in range(len(value[6])):
                    if value[6][i] == 0:
                        _before = i
                    else:
                        break

                for i in range(len(value[6])):
                    if value[6][len(value[6])-1-i] == 0:
                        _after = len(value[5])-1-i
                    else:
                        break

                #(self.pix3, ) = \
                self.canvas3.ax.plot(value[5][_before:_after],
                        value[6][_before:_after], color='g')
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_xlabel('q (A-1)')
                self.canvas3.ax.set_ylabel('Neutron Counts')
                #else:
                    # self.pix3.set_xdata(value[5])
                    #self.pix3.set_ydata(value[6])
                if self.canvas3.zoomSelected \
                    and self.canvas3.minX != self.canvas3.maxX \
                    and self.canvas3.minY != self.canvas3.maxY:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                elif self.canvas3.scale_factor != 1.0:
                    self.canvas3.ax.set_xlim([self.canvas3.xdata - self.canvas3.new_width * (1-self.canvas3.relx), self.canvas3.xdata + self.canvas3.new_width * (self.canvas3.relx)])
                    self.canvas3.ax.set_ylim([self.canvas3.ydata - self.canvas3.new_height * (1-self.canvas3.rely), self.canvas3.ydata + self.canvas3.new_height * (self.canvas3.rely)])

                xIndex = self.comboBoxLog2x.currentIndex()
                try:
                    if xIndex == 0:
                        self.canvas3.ax.set_xscale('linear')
                    else:
                        #if 0 not in value[5]:
                        self.canvas3.ax.set_xscale('log')
                except:
                    pass

                yIndex = self.comboBoxLog2y.currentIndex()
                try:
                    if yIndex == 0:
                        self.canvas3.ax.set_yscale('linear')
                    else:
                        #if 0 not in value[6]:
                        self.canvas3.ax.set_yscale('log')
                except:
                    pass

                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
            #self.pix3 = None
