#!/usr/bin/python
# -*- coding: utf-8 -*-

from conf.constants import *
import json

from viewer.mainTab import *
from viewer.subTab import *


class CSNSMainSetInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSMainSetInfo, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.downRightTab = CSNSSubTab(self)
        self.upRightTab = CSNSMainTab(self)
        self.progressBar = QtGui.QProgressBar(self)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)

        self.splitter.addWidget(self.upRightTab)
        self.splitter.addWidget(self.progressBar)
        self.splitter.addWidget(self.downRightTab)
        self.splitter.setSizes([800, 30, 30])
        self.verticalLayout.addWidget(self.splitter)

        # self.createTimeProgress(0,2000)
    
    def clearCanvas(self):
        self.upRightTab.clearCanvas()

    def setDataPath(self, kwargs):
        self.parent.setDataPath(kwargs)

    # time Progress Thread

    def createProgressBar(self, mini, maxi):
        global CSNSThreadID
        CSNSThreadID += 1
        self.progressThread = updateProgressBar(self, CSNSThreadID,
                mini, maxi)
        self.progressThread.partDone.connect(self.updateTimeProgress)
        self.progressThread.procDone.connect(self.fin)
        self.progressThread.start()

    @QtCore.pyqtSlot(int)
    def updateTimeProgress(self, val):
        self.progressBar.setValue(val)
        perct = '{0}%'.format(val)

    def fin(self):
        pass

    def getProgressValue(self):
        return self.parent.getProgressValue()

    def setIndex(self,index):
        self.upRightTab.setIndex(index)

    # get canvas data from getNeonData
    def getReflectionData(self):
        self.parent.getReflectionData()
    def getMonitorData(self):
        self.parent.getMonitorData()

    # get tube neutron choose in reflection
    def getTube1Check(self):
        return self.upRightTab.getTube1Check()
    def getTube2Check(self):
        return self.upRightTab.getTube2Check()
    def getTube3Check(self):
        return self.upRightTab.getTube3Check()
    def getTube4Check(self):
        return self.upRightTab.getTube4Check()

    def roiSelected(self):
        return self.upRightTab.roiSelected()

    def getRoiInfo(self):
        return self.upRightTab.getRoiInfo()

    def setRoiInfo(self):
        return self.parent.setRoiInfo()
