#!/usr/bin/python
# -*- coding: utf-8 -*-

# main

'''
Created on 2015.9.25
'''
import warnings
from scipy.optimize import OptimizeWarning

warnings.simplefilter("error", OptimizeWarning)

from conf.constants import *
import json
from json import *
import atexit
import redis
import subprocess

#import warnings

# viewer defined
from viewer.user import *
from viewer.menuBar import *
from viewer.statusBar import *
from viewer.mainSet import *
from viewer import logWindow

# model defined
from model import neonReceiver
from model import jsonArray

#from model import saveScreen

class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, MainWindow):

        self.myMenuBar = menuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = statusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        self.dataThread = None
        self.roiInfo = {}
        self.loadConfigure()
        self.userWidget = CSNSUserInfo(self)
        self.mainSetWidget = CSNSMainSetInfo(self)

        self.mainSplitter.addWidget(self.userWidget)
        self.mainSplitter.addWidget(self.mainSetWidget)

        self.neonStatus = None
        self.writeServer = None    
        self.myStatus = 'waiting'
        logging.info("Status is waiting")
        self.ip_port = ""
        self.mainSplitterLeft=100
        self.mainSplitterRight=900 
        self.myCommand = None
        self.commandList = ['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList = ['waiting','unconfigured','configuring','ready','running','paused','error'] 
        self.started = True
        # data update time
        self.refreshtime = 1.0
        # progress value
        self.progressName = ''
        self.progressValue = 0
        self.protonValue = 0
        self.neutronValue = 0
        self.pulseValue = 0

        self.runNo = None
        self.userInfo = None

        self.setCentralWidget(self.mainSplitter)
        self.setConfigure()
        
        self.userWidget.setStatusLabel(self.myStatus)
        
        self.createThread()

    # get tube neutron choose in reflection
    def getTube1Check(self):
        return self.mainSetWidget.getTube1Check()
    def getTube2Check(self):
        return self.mainSetWidget.getTube2Check()
    def getTube3Check(self):
        return self.mainSetWidget.getTube3Check()
    def getTube4Check(self):
        return self.mainSetWidget.getTube4Check()

    def updateDiffractionSimulator(self):
        self.upRightTab.updateDiffractionSimulator()

    def updateDataStreaming(self):
        self.upRightTab.updateDataStreaming()

    def updateProton(self, threadID):
        self.upRightTab.updateProton(threadID)

    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return screen_resolution.width(), screen_resolution.height()

    def loadConfigure(self):
        _confFile='./conf/configure.json'
        _mainWidth, _mainHeight=self.getDisplay()

        if not os.path.exists(_confFile):
            self.mainWidth=_mainWidth
            self.mainHeight=_mainHeight
            self.ip_port=self.userWidget.getIP_PORT()
            self.mainSplitterLeft=(self.mainWidth + 50) / 9.0
            self.mainSplitterRight=self.mainWidth / 9.0 * 8
        else:
            try:
                layoutParameter = json.loads(open(_confFile, "r").read())
                self.mainWidth=layoutParameter['mainWidth']
                self.mainHeight=layoutParameter['mainHeight']
                self.ip_port=layoutParameter['ip_port']
                #self.ip=layoutParameter['ip']
                #self.port=layoutParameter['port']
                self.mainSplitterLeft=layoutParameter['mainSplitterLeft']
                self.mainSplitterRight=layoutParameter['mainSplitterRight']
            except:
                self.mainWidth=_mainWidth
                self.mainHeight=_mainHeight
                self.ip_port=[('10.1.31.116', 9001), ('10.1.31.116',9011)]

            try:
                self.roiInfo = layoutParameter['roiInfo']
            except:
                pass

    def setConfigure(self):
        self.resize(self.mainWidth, self.mainHeight)
        self.mainSplitter.setSizes([self.mainSplitterLeft,self.mainSplitterRight])
        #self.userWidget.hostTextEdit.setText(self.ip+":"+str(self.port))

    def saveConfigure(self):
        _mainWidth=self.mainSplitter.geometry().width()
        _mainHeight=self.mainSplitter.geometry().height()
        _ip_port=self.userWidget.getIP_PORT()
        #_ip=self.userWidget.getIP()
        #_port=self.userWidget.getPort()
        _mainSplitterLeft=self.mainSplitter.sizes()[0]
        _mainSplitterRight=self.mainSplitter.sizes()[1]
        
        _roiInfo = self.getRoiInfo()

        _data = {"mainWidth": _mainWidth, "mainHeight": _mainHeight, "mainSplitterLeft":_mainSplitterLeft,"mainSplitterRight":_mainSplitterRight, "ip_port":_ip_port, "roiInfo":_roiInfo}
        #_data = {"mainWidth": _mainWidth, "firstLayout": _firstLayout, "mainHeight": _mainHeight, "mainSplitterLeft":_mainSplitterLeft,"mainSplitterRight":_mainSplitterRight, "ip":_ip, "port":_port }
        
        _confFile='./conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)

    def setNeonStatus(self, value):
	    self.userWidget.setNeonStatus(value)
 
    def getNeon(self):
	    self.neonStatus, self.writeServer=self.userWidget.getNeon()
	    return self.neonStatus, self.writeServer
  
    def getStatus(self):
    	return self.statusList.index(self.myStatus)
    
    def setHeartBeat(self):
    	
        if len(sys.argv) == 1:
            neonpath="/MR/heartbeat/pilot"
            #neonpath="/MR/heartbeat/pilot"
        else:
            neonpath="/MR/heartbeat/pilot1"

    	logging.info("Creating heartbeat thread")
    	self.heartbeatThread = neonReceiver.setHeartbeat(self, self.writeServer, 1.0, neonpath, self.getStatus())
    	self.heartbeatThread.setDaemon(True)

    def getApp(self):
        return self.parent

    def getCommand(self, parent, gui):
        logging.info("Creating Command Thread...")
        commandPath = '/MR/control/command/pilot'
        self.commandThread = neonReceiver.commandThread(parent, gui, self.writeServer, commandPath, 1.0)

    def getMyCommand(self):
        return self.myCommand
    
    def getMyStatus(self):
        return self.myStatus

    def getRunNo(self):
        return self.runNo

    @QtCore.pyqtSlot(str)
    def setCommand(self, value):
        try:
            value = json.loads(value)
            _command = self.commandList[int(value)]
            if self.myCommand!=_command:
                logging.info(str("Received command: " + _command))
                
                # start stateMachine
                self.stateMachine(_command) 
                self.userWidget.setCommandLabel(_command)
                self.myCommand = _command
                
                # set receive command to wechat
                path = '/MR/wechat/command'
                if self.writeServer == None:
                    (neonStatus, self.writeServer) = self.getNeon()
                _command_json = jsonArray.jsonEncoder(self.myCommand)
                self.writeServer.set(path, _command_json)

        except:
            pass

    @QtCore.pyqtSlot(str)
    def setLog(self, value):
        logging.debug(value)
   
    def getCanvasData(self, parent, gui):
        logging.info("Creating Canvas data Thread...")
     
        progressPath='/MR/cockpit/progress'        
 
        protonPath='/MR/drone/proton_charge'
        detectorPath='/MR/drone/detector_counts'
        detectorRatePath='/MR/drone/detector_rates'
        roiPath='/MR/drone/ROI/detector_counts'
        roiRatePath='/MR/drone/ROI/detector_rates'
        monitorPath='/MR/drone/monitor_counts'
        monitorRatePath='/MR/drone/monitor_rates'
        #neutronPath='/MR/drone/neutron_counts'
        pulsePath='/MR/drone/pulse_counts'
        startPath='/MR/drone/startTime'
        endPath='/MR/drone/endTime'
        userPath='/MR/drone/sample'
        
        #self.dataThread = neonReceiver.dataThread(parent, gui, self.writeServer, progressPath, protonPath, neutronPath, pulsePath, startPath, endPath, self.refreshtime)
        self.dataThread = neonReceiver.dataThread(parent, gui, self.writeServer, progressPath, protonPath, detectorPath, detectorRatePath, roiPath, roiRatePath, monitorPath, monitorRatePath, pulsePath, startPath, endPath, userPath, self.refreshtime)
 
    def setDataPath(self, kwargs):
        if not self.dataThread:
            logging.info("No data availabel")
        else:
            self.dataThread.setDataPath(kwargs)

    def getDetectorIndex(self):
        return self.mainSetWidget.upRightTab.detectorPage.getDetectorIndex()
    
    # get canvas data from getNeonData
    def getReflectionData(self):
        self.dataThread.getReflectionData()
    def getMonitorData(self):
        self.dataThread.getMonitorData()
 
    @QtCore.pyqtSlot(object)
    def setCanvasData(self, value):
        tabIndex = self.dataThread.getTabIndex()
        _started = self.started
        _command = self.myCommand
        #elif tabIndex == 1:
        #    self.mainSetWidget.upRightTab.roiPage.updateCanvas(value, _started, _command)
        if tabIndex == 1:
            self.mainSetWidget.upRightTab.detectorPage.updateCanvas(value, _started, _command)
        elif tabIndex == 0:
            self.mainSetWidget.upRightTab.reflectionPage.updateCanvas(value, _started, _command)      
        elif tabIndex == 2:
            self.mainSetWidget.upRightTab.tubeRefPage.updateCanvas(value, _started, _command)      
        elif tabIndex == 3:
            self.mainSetWidget.upRightTab.tubeRoiPage.updateCanvas(value, _started, _command)      
        elif tabIndex == 4:
            self.mainSetWidget.upRightTab.tubeDetPage.updateCanvas(value, _started, _command)      
        elif tabIndex == 5:
            self.mainSetWidget.upRightTab.monitorPage.updateCanvas(value, _started, _command)
        #elif tabIndex == 4:
        #    self.mainSetWidget.upRightTab.scanPage.updateCanvas(value, _started, _command)
        elif tabIndex == 6:    
            self.mainSetWidget.upRightTab.polarizationPage.updateCanvas(value, _started, _command)
        elif tabIndex == 7: 
            self.mainSetWidget.upRightTab.gisansPage.updateCanvas(value, _started, _command)
        elif tabIndex == 8:    
            self.mainSetWidget.upRightTab.experimentPage.updateCanvas(value, _started, _command) 
    
    @QtCore.pyqtSlot(object)
    def setMonitorCanvas(self, value):
        #xdata = self.dataThread.getMonitorTOFData()
        #self.userWidget.updateMonitorCanvas(xdata,value,self.started,self.myCommand)
        pass

    @QtCore.pyqtSlot(object, object, object, object, object)
    def setUserData(self, _proton, _detector, _detectorRate, _monitor, _monitorRate):
        try:
            #_proton = json.loads(_proton)
            self.userWidget.setProtonNeutron(_proton, _detector, _detectorRate, _monitor, _monitorRate)
            if not _proton:
                self.protonValue = int(_proton)
            if not _detector:
                self.neutronValue = int(_detector)
            #self.pulseValue = int(_pulse)
        except:
            pass

    @QtCore.pyqtSlot(object, object)
    def setROI(self, _roi, _roiRate):
        #try:
        self.userWidget.setROI(_roi, _roiRate)
        #except:
        #    pass

    @QtCore.pyqtSlot(object, object)
    def setUserTime(self, _start, _end):
        try:
            self.userWidget.setStartEndTime(_start, _end)
        except:
            pass

    @QtCore.pyqtSlot(object)
    def setUserValue(self, _value):
        self.userWidget.setUserValue(_value)

    @QtCore.pyqtSlot(str)
    def setProgressData(self, value):
        self.progressValue = json.loads(str(value))

    # set max and min value for progressBar
    def setProgressBar(self, mini, maxi):
        self.mainSetWidget.createProgressBar(mini, maxi)

    #get current value for progressBar
    def getProgressValue(self):
        return self.progressValue
  
    # get reflection page ROI checkBox
    def roiSelected(self):
        return self.mainSetWidget.roiSelected()

    def getRoiInfo(self):
        return self.mainSetWidget.getRoiInfo()

    def setRoiInfo(self):
        return self.roiInfo
 
    def getUserInfo(self):
        try:
            userPath = '/MR/control/configure'
            _neonStatus, _writeServer = self.getNeon()
            if _neonStatus:
                #get json date after json.dumps from neon
                _userInfo = self.writeServer.get(userPath)
                if _userInfo is None:
                    logging.info("Empty User Information Data!")
                else:
                    self.userInfo = _userInfo
                    _userInfo=json.loads(_userInfo)
                    self.userWidget.setUserInfo(_userInfo)
                    #self.runNo = str(_userInfo['runNo'])
                    self.setWechatConf()

                    _progressMin = float(_userInfo['progressMin'])
                    _progressMax = float(_userInfo['progressMax'])
                    self.setProgressBar(_progressMin, _progressMax)
                    print _userInfo

                    if str(_userInfo['mode']) == 'MWPC':
                        self.mainSetWidget.upRightTab.setTabEnabled(0,True)
                        self.mainSetWidget.upRightTab.setTabEnabled(1,True)
                        self.mainSetWidget.upRightTab.setTabEnabled(2,False)
                        self.mainSetWidget.upRightTab.setTabEnabled(3,False)
                        self.mainSetWidget.upRightTab.setTabEnabled(4,False)
                        self.setIndex(0)
                    else:
                        self.mainSetWidget.upRightTab.setTabEnabled(0,False)
                        self.mainSetWidget.upRightTab.setTabEnabled(1,False)
                        self.mainSetWidget.upRightTab.setTabEnabled(2,True)
                        self.mainSetWidget.upRightTab.setTabEnabled(3,True)
                        self.mainSetWidget.upRightTab.setTabEnabled(4,True)
                        self.setIndex(2)
        except:
            pass

    def setWechatConf(self):
        # set run no to wechat
        path = '/MR/wechat/configure'
        if self.writeServer == None:
            (neonStatus, self.writeServer) = self.getNeon()
        #_run_json = jsonArray.jsonEncoder(self.runNo)
        self.writeServer.set(path, self.userInfo)
 
    def saveScreen(self):
        index = self.mainSetWidget.upRightTab.currentIndex()
        self.saveScreenThread = saveScreen.saveScreen(self, index)
        self.saveScreenThread.setDaemon(True)

    def createThread(self):
        # connect neon
        _neonStatus, _writeServer = self.getNeon()
        #self.setNeonStatus(_neonStatus)
        if _neonStatus:
            # set heartbeat
            self.setHeartBeat()
            # get command
            self.getCommand(self.parent, self)
            # get canvas data
            self.getCanvasData(self.parent, self)
    
            # create save screen thread
            #self.saveScreen()            

            self.myStatus = 'unconfigured'
            logging.info("Status change to unconfigured")
            self.userWidget.setStatusLabel(self.myStatus) 
    
    def startThread(self):
    	self.heartbeatThread.start()
    	logging.info("Start heartbeat successfully")
        self.commandThread.start() 
        logging.info("Start Command Thread successfully")
        # start save screen thread
        #self.saveScreenThread.start()

    def clearCanvas(self):
        self.mainSetWidget.clearCanvas() 
        #self.userWidget.clearCanvas()
    
    def setIndex(self,index):
        self.mainSetWidget.setIndex(index)

    def stateMachine(self, command):
        _command = command
        _index = self.getStatus()
        _status = self.statusList[_index]
        try:
            if _command == 'configure':
                if _status == 'unconfigured':
                    _status = 'configuring'
                    logging.info("status change to configuring")
                    self.getUserInfo()
                    self.mainSetWidget.upRightTab.reflectionPage.setRoi()
                    self.mainSetWidget.upRightTab.tubeRefPage.setRoi()
                    _status = 'ready'
                    logging.info("status change to ready")
                elif _status == 'ready':
                    logging.info("ready now")
                else:#waiting/configuring/running/paused
                    logging.info(_status+' status cannot receive abort command')
            elif _command == 'unconfigure':
                if _status == 'unconfigured':
                    logging.info("unconfigured now")
                elif _status == 'ready':
                    self.started = False
                    #self.dataThread.pause()
                    _status = 'unconfigured'
                    logging.info("status change to unconfigured")
                else:#waiting/configuring/running/paused
                    logging.info(_status+' status cannot receive abort command')
            elif _command == 'start':
                if len(sys.argv) == 1:
                    if _status == 'ready':
                        #clear canvas
                        self.clearCanvas()                
                        # start get data from neon
                        self.started = True
                        self.dataThread.start()
                        logging.info("Start Canvas Data Thread successfully")
                        # set canvas data path
                        self.mainSetWidget.upRightTab.tabChange()
                        _status = 'running'
                        logging.info("status change to running")
                        self.startTime = time.time()
                    elif _status == 'running':
                        logging.info("running now")
                    else:#waiting/unconfigured/configuring/paused
                        logging.info(_status+' status cannot receive abort command')
                else:
                    if _status != 'ready':
                        _status = 'configuring'
                        logging.info("status change to configuring")
                        self.getUserInfo()
                        _status = 'ready'
                        logging.info("status change to ready")

                    #clear canvas
                    self.clearCanvas()
                    # start get data from neon
                    self.started = True
                    self.dataThread.start()
                    logging.info("Start Canvas Data Thread successfully")
                    # set canvas data path
                    self.mainSetWidget.upRightTab.tabChange()

                    self.userWidget.startTime=time.time()
                    _status = 'running'
                    logging.info("status change to running")
            elif _command == 'pause':
                if _status == 'running':
                    # pause get date from neon
                    self.dataThread.pause()
                    _status = 'paused'
                    logging.info("status change to paused")
                else:#waiting/unconfigured/configuring/ready/paused
                    logging.info(_status+' status cannot receive abort command')
            elif _command == 'resume':
                if _status == 'paused':
                    self.dataThread.resume()
                    _status = 'running'
                    logging.info("status change to runninig")
                else:#waiting/unconfigured/configuring/ready/running
                    logging.info(_status+' status cannot receive abort command')
            elif _command == 'stop':
                if _status == 'ready':
                    logging.info("ready now")
                elif _status == 'running':
                    #self.setIndex(0)
                    #self.mainSetWidget.upRightTab.setCurrentIndex(0)
                    self.started = False
                    #time.sleep(self.refreshtime)
                    #self.dataThread.pause()
                    _status = 'ready'
                    logging.info("status change to ready")
                else:#waiting/unconfigured/configuring/paused
                    logging.info(_status+' status cannot receive abort command')   
            elif _command == 'abort':
                _status = 'unconfigured'
                logging.info("status change to unconfigured")

            self.userWidget.setStatusLabel(_status) 
            self.myStatus = _status
        except:
            pass

def exit_handler(top):
    top.saveConfigure()

def run_this():
    import shlex
    mypid=str(os.getpid())
    myname=os.path.basename(__file__)
    #_cmd="ps -ef | grep "+myname+" | grep -v grep | awk '{print $2}'"
    _cmd="ps -C "+myname+" -o pid="
    pid=subprocess.check_output(_cmd, shell=True)
    pid=shlex.split(pid)
    for p in pid:
        if p != mypid:
            try:
                _cmd="/usr/bin/kill -9 "+str(p)
                #_cmd = shlex.split(_cmd)
                subprocess.check_call(_cmd, shell=True)
                logging.warning("Self process killed")
            except:
                logging.warning("Self process not killed")
        else:
            pass

if __name__ == '__main__':
    #run_this()
    
    #myapp = QtGui.QApplication(sys.argv)
    myapp = QtGui.QApplication.instance()
    mytop = mywindow(myapp)
    icon = QtGui.QIcon('img/logo.jpg')
    mytop.setWindowIcon(icon)
    mytop.setWindowTitle('MR')
    mytop.show()
    time.sleep(0.1)
    mytop.startThread()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
