#!/usr/bin/python
# -*- coding: utf-8 -*-
# configure

'''
Created on 2015.6.2
@author: yll
'''

from conf.constants import *

# user defined
# from model.readData import *
# from model.slitModel import *
# from presenter.slitSignal import *

from canvas import *


class TubeRoiPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(TubeRoiPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, Widget):
        self.horizontalLayout = QtGui.QHBoxLayout(self)

        # for main  grid
        self.canvas = []
        self.first = []
        self.scrollArea = []
        self.firstGrid = []
        self.peakLabel = []
        self.fwhmLabel = []
        _width = 3.5
        _tube = 4
        for i in range(_tube):
            self.first.append(QtGui.QFrame(self))
            self.first[i].setFrameShape(QtGui.QFrame.StyledPanel)
            self.scrollArea.append(QtGui.QScrollArea())
            self.scrollArea[i].setWidgetResizable(True)
            self.scrollArea[i].setWidget(self.first[i])

            self.firstGrid.append(QtGui.QGridLayout(self.first[i]))       

            self.canvas.append(zoomCanvas(
                self.first[i],
                _width,
                _width,
                150,
                'r',
                ' ',
                'X / mm',
                '',
                ))
            #self.canvas[i].set_rotation(90)
            #self.canvas[i].ax.tick_params(axis='y', left='off',labelleft='off')
            self.peakLabel.append(QtGui.QLabel('Peak: 0.00'))
            self.peakLabel[i].setMaximumWidth(150)
            self.fwhmLabel.append(QtGui.QLabel('FWHM: 0.00'))
            self.fwhmLabel[i].setMaximumWidth(150)

        _nline = 0
        for i in range(len(self.canvas)):
            self.firstGrid[i].addWidget(self.canvas[i], _nline, 0, 1, 2)
            _nline += 1
            self.firstGrid[i].addWidget(self.peakLabel[i], _nline, 0, 1, 1)
            self.firstGrid[i].addWidget(self.fwhmLabel[i], _nline, 1, 1, 1)
            _nline += 1
        for i in range(len(self.canvas)):
            self.horizontalLayout.addWidget(self.scrollArea[i])

        self.value = None
        self.xdata = 0
        self.ydata = 0
        self.mouseClicked = False

        self.pix1 = []
        self.pix2 = []
        for i in range(len(self.canvas)):
            self.pix1.append('')
            self.pix2.append('')

    def curveFit(self, x0, y0):
        from scipy.optimize import curve_fit

        def func(x, *params):
            y = np.zeros_like(x)
            for i in range(0, len(params), 3):
                ctr = params[i]
                amp = params[i + 1]
                wid = params[i + 2]
                y = y + amp * np.exp(-((x - ctr) / wid) ** 2 / 2.0)
            return y

        _max = max(y0)
        _imax=y0.index(max(y0))
        _center=x0[int(_imax)]
        guess = [_center, _max, 40]

        # for i in range(1):
        #    guess += [(i-0.5)*20, _max, 20]

        (popt, pcov) = curve_fit(func, x0, y0, p0=guess)
        fit = func(x0, *popt)
        return fit, popt

    def clearCanvas(self):
        for i in range(len(self.canvas)):
            self.canvas[i].ax.clear()
            self.canvas[i].draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        if _command in ('configure', 'abort'):
            self.pix1 = []
            self.pix2 = []
            for i in range(len(self.canvas)):
                self.canvas[i].draw()
                self.pix1.append('')
                self.pix2.append('')
        #elif not started:
        #    pass
        #else:
        color2D = ['r', 'g', 'b', 'r']
        try:
            type(value[0])
            type(value[1])
        except:
            return
        for i in range(len(self.canvas)):
            if str(value[0][i]) == 'clear' or str(value[1][i]) == 'clear':
                self.canvas[i].ax.clear()
                self.canvas[i].draw()
            elif len(value[0][i]) != len(value[1][i]) \
                or len(value[1][i]) == 0:
                pass
            else:
                try:
                    #if not self.pix1[i]:
                    self.canvas[i].ax.clear()
                    (self.pix1[i], ) = \
                    self.canvas[i].ax.plot(value[1][i],
                            value[0][i], '.')  # color=color2D[i])
                    self.canvas[i].ax.add_patch(self.canvas[i].rect)
                    self.canvas[i].ax.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(10))
                    self.canvas[0].ax.set_ylabel('Y / mm',
                            fontsize=5)
                    #else:
                    #    self.pix1[i].set_ydata(value[1][i])
                except:
                    pass
                try:
                    _y, _popt = self.curveFit(value[0][i], value[1][i])
                except:
                    self.canvas[i].ax.relim()
                    self.canvas[i].ax.autoscale_view()
                    self.canvas[i].ax.set_ylim(0, 300)
                    self.canvas[i].draw()
                    continue
                try:
                    self.peakLabel[i].setText('Peak:' + format(_popt[0], '.2f'))
                    self.fwhmLabel[i].setText('FWHM:' + format(_popt[2] * 2.3548, '.2f'))
                except:
                    pass
                try:
                    #if not self.pix2[i]:
                    (self.pix2[i], ) = \
                    self.canvas[i].ax.plot(_y, value[0][i], 'r')  # color=color2D[i])
                    #else:
                    #    self.pix2[i].set_ydata(_y)
                except:
                    pass
                    #self.pix2[i] = None
                try:
                    if self.canvas[i].zoomSelected \
                        and self.canvas[i].minX \
                        != self.canvas[i].maxX \
                        and self.canvas[i].minY \
                        != self.canvas[i].maxY:
                        self.canvas[i].ax.set_xlim(self.canvas[i].minX,
                                self.canvas[i].maxX)
                        self.canvas[i].ax.set_ylim(self.canvas[i].minY,
                                self.canvas[i].maxY)
                    elif self.canvas[i].scale_factor != 1.0:
                        self.canvas[i].ax.set_xlim([self.canvas[i].xdata - self.canvas[i].new_width * (1-self.canvas[i].relx), self.canvas[i].xdata + self.canvas[i].new_width * (self.canvas[i].relx)])
                        self.canvas[i].ax.set_ylim([self.canvas[i].ydata - self.canvas[i].new_height * (1-self.canvas[i].rely), self.canvas[i].ydata + self.canvas[i].new_height * (self.canvas[i].rely)])                    

                    self.canvas[i].ax.relim()
                    self.canvas[i].ax.autoscale_view()
                    self.canvas[i].ax.set_ylim(0, 300)
                    self.canvas[i].draw()
                except:
                    pass
