#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined

from canvas import *
from conf.constants import *
import time
import redis
from model import jsonArray
import numpy as np

class TubeRefPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(TubeRefPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.neutron = QtGui.QFrame(self)
        self.neutron.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaNeutron = QtGui.QScrollArea()
        self.scrollAreaNeutron.setWidgetResizable(True)
        self.scrollAreaNeutron.setWidget(self.neutron)
        #self.scrollAreaNeutron.setMinimumWidth(135)
        #self.scrollAreaNeutron.setMinimumHeight(180)
        self.neutron.setMaximumHeight(450)

        self.line1 = QtGui.QFrame(self)
        self.line1.setGeometry(QtCore.QRect())
        self.line1.setFrameShape(QtGui.QFrame.HLine)
        self.line1.setFrameShadow(QtGui.QFrame.Sunken)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)
        self.splitter.addWidget(self.scrollAreaNeutron)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)

        self.splitter.setSizes([150, 10, 500])  # , 150])

        # main Grid
        self.canvasGrid = QtGui.QGridLayout(self.first)
        #self.canvasGrid = QtGui.QGridLayout(self.rightUp)
        #self.rightDownGrid = QtGui.QGridLayout(self.rightDown)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.neutronGrid = QtGui.QGridLayout(self.neutron)
        
        self.roiCheckBox = QtGui.QCheckBox('Use ROI', self)
        self.roiCheckBox.stateChanged.connect(self.roiCheckBoxChange)
        #self.button = QtGui.QPushButton('Submit')
        #self.button.setMaximumHeight(30)
        #self.button.setMaximumWidth(70)
        #self.button.clicked.connect(self.buttonClicked)
        
        self.leftLabel = QtGui.QLabel('Left:',self)
        self.leftLabel.setMaximumWidth(50)
        self.leftTextEdit = QtGui.QTextEdit('87.0')
        self.leftTextEdit.setMaximumWidth(80)
        self.leftTextEdit.setMaximumHeight(31)
        self.leftTextEdit.setDisabled(True) 
        self.rightLabel = QtGui.QLabel('Right:',self)
        self.rightLabel.setMaximumWidth(50)
        self.rightTextEdit = QtGui.QTextEdit('97.0')
        self.rightTextEdit.setMaximumWidth(80)
        self.rightTextEdit.setMaximumHeight(31) 
        self.rightTextEdit.setDisabled(True) 
        self.topLabel = QtGui.QLabel('Top:',self)
        self.topLabel.setMaximumWidth(50)
        self.topTextEdit = QtGui.QTextEdit('130.0')
        self.topTextEdit.setMaximumWidth(80)
        self.topTextEdit.setMaximumHeight(31) 
        self.topTextEdit.textChanged.connect(self.textChange) 
        self.bottomLabel = QtGui.QLabel('Bottom:',self)
        self.bottomLabel.setMaximumWidth(80)
        self.bottomTextEdit = QtGui.QTextEdit('60.0')
        self.bottomTextEdit.setMaximumWidth(80)
        self.bottomTextEdit.setMaximumHeight(31) 
        self.bottomTextEdit.textChanged.connect(self.textChange) 

        self.comboBoxTube = QtGui.QComboBox()
        self.comboBoxTube.addItem('Tube 1')
        self.comboBoxTube.addItem('Tube 2')
        self.comboBoxTube.addItem('Tube 3')
        self.comboBoxTube.addItem('Tube 4')
        self.comboBoxTube.setMaximumWidth(150)
        self.comboBoxTube.activated.connect(self.comboBoxTubeChange)
        self.comboBoxTube.setCurrentIndex(1)

        self.tubeLabel = QtGui.QLabel('Neutron Counts:',self)
        self.tubeLabel.setMaximumWidth(100)
        self.tube1CheckBox = QtGui.QCheckBox('Tube 1', self)
        self.tube1CheckBox.setChecked(False)
        self.tube1CheckBox.stateChanged.connect(self.tubeCheckBoxChange)
        self.tube2CheckBox = QtGui.QCheckBox('Tube 2', self)
        self.tube2CheckBox.setChecked(True)
        self.tube2CheckBox.stateChanged.connect(self.tubeCheckBoxChange)
        self.tube3CheckBox = QtGui.QCheckBox('Tube 3', self)
        self.tube3CheckBox.setChecked(True)
        self.tube3CheckBox.stateChanged.connect(self.tubeCheckBoxChange)
        self.tube4CheckBox = QtGui.QCheckBox('Tube 4', self)
        self.tube4CheckBox.setChecked(True)
        self.tube4CheckBox.stateChanged.connect(self.tubeCheckBoxChange)

        _xsize = 16  # 6
        _ysize = 8  # 3
        '''
        self.canvas1Fig = Figure((5,5), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=True)
        self.canvas1Fig.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.canvas1 = FigureCanvas(self.canvas1Fig)
        self.canvas1.setParent(self)
        self.canvas1.ax = self.canvas1Fig.add_subplot(111,projection='3d')
        self.canvas1.ax.tick_params(axis='both', which='major', labelsize=0.1)
        self.canvas1.ax.axis('off')
        self.canvas1.ax.set_xlabel('qx')
        self.canvas1.ax.set_ylabel('qy')
        '''
        self.canvas1 = refCanvas(  # _xsize,
                                    # _ysize,
                                    # self.plotColor,
                                    # self.title,
            self,
            10,
            10,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )

        self.pix = None

        self.canvas1.draw()
        self.canvas2 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'TOF / us',
            'Neutron Counts',
            )

        self.canvas3 = zoomCanvas(  # self.plotColor,
                                    # self.title,
            self,
            _xsize,
            _ysize,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Scattering Intensity',
            )
        self.comboBoxUnit1 = QtGui.QComboBox()
        self.comboBoxUnit1.addItem('TOF')
        self.comboBoxUnit1.addItem('theta')
        self.comboBoxUnit1.addItem('Wavelength')
        self.comboBoxUnit1.setMaximumWidth(150)
        self.comboBoxUnit1.activated.connect(self.comboBoxUnit1Change)
        self.comboBoxLog1 = QtGui.QComboBox()
        self.comboBoxLog1.addItem('linear')
        self.comboBoxLog1.addItem('logarithmic')
        self.comboBoxLog1.setMaximumWidth(150)
        self.comboBoxLog1.activated.connect(self.comboBoxLog1Change)

        self.normLabel = QtGui.QLabel('Normalization by')
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        self.comboBoxNorm.setCurrentIndex(1)
        self.comboBoxNorm.activated.connect(self.comboNormChange)
        self.comboBoxLog2x = QtGui.QComboBox()
        self.comboBoxLog2x.addItem('x:linear')
        self.comboBoxLog2x.addItem('x:logarithmic')
        self.comboBoxLog2x.setMaximumWidth(150)
        self.comboBoxLog2x.activated.connect(self.comboBoxLog2xChange)
        self.comboBoxLog2y = QtGui.QComboBox()
        self.comboBoxLog2y.addItem('y:linear')
        self.comboBoxLog2y.addItem('y:logarithmic')
        self.comboBoxLog2y.setMaximumWidth(150)
        self.comboBoxLog2y.activated.connect(self.comboBoxLog2yChange)

        _nline = 0
        self.neutronGrid.addWidget(self.tubeLabel, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.tube1CheckBox, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.tube2CheckBox, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.tube3CheckBox, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.tube4CheckBox, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.line1, _nline, 0, 1,2, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.roiCheckBox, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.comboBoxTube, _nline, 1, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.leftLabel, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        self.neutronGrid.addWidget(self.leftTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.rightLabel, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        self.neutronGrid.addWidget(self.rightTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.topLabel, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        self.neutronGrid.addWidget(self.topTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignTop)
        _nline += 1
        self.neutronGrid.addWidget(self.bottomLabel, _nline, 0, 1, 1, QtCore.Qt.AlignTop)
        self.neutronGrid.addWidget(self.bottomTextEdit, _nline, 1, 1, 1, QtCore.Qt.AlignTop)
        _nline = 0
        #self.firstGrid.addWidget(self.scrollAreaNeutron, _nline, 0, 1, 1)
        self.canvasGrid.addWidget(
            self.canvas1,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter | QtCore.Qt.AlignBottom,
            )

        _nline = 0
        self.secondGrid.addWidget(self.comboBoxUnit1, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.comboBoxLog1, _nline, 1, 1, 1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas2, _nline, 0, 1, 7)
        _nline += 1
        self.secondGrid.addWidget(self.normLabel, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.comboBoxNorm, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.comboBoxLog2x, _nline, 2, 1, 1)
        self.secondGrid.addWidget(self.comboBoxLog2y, _nline, 3, 1, 1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas3, _nline, 0, 1, 7)

        self.verticalLayout.addWidget(self.splitter)

        self.tube1Check = True
        self.tube2Check = True
        self.tube3Check = True
        self.tube4Check = True

        self.roiCheckBoxIndex = 0
        self.colorbar = None
        self.zoomClick = False
        self.zoomSelected = False
        self.roiSelected = False
        self.value = None
        self.neonServer = None

        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None


    def buttonClicked(self):
        coord = {}
        path = '/MR/workspace/MantidData/roi'
        if self.roiCheckBoxIndex == 1:
            self.roiSelected = True
        try:
            if self.neonServer == None:
                (neonStatus, self.neonServer) = \
                    self.parent.parent.parent.getNeon()
            if self.roiCheckBoxIndex == 0:
                coord['pos'] = [self.canvas1.x1, self.canvas1.y1, self.canvas1.x2, self.canvas1.y2]
            else:
                coord['pos'] = self.getPos()
                self.canvas1.setRect(coord['pos'])
            _num = self.getComboBoxTube() + 1
            coord['tubeNo'] = _num
            coord['roi'] = self.roiSelected
            _coord_json = jsonArray.jsonEncoder(coord)
            self.neonServer.set(path, _coord_json)
        except:
            pass
        self.parent.tabChange()
        self.getReflectionData()

    def setPos(self,x1,y1,x2,y2):
        self.leftTextEdit.setText(format(x1,'.2f'))
        self.rightTextEdit.setText(format(x2,'.2f'))
        #self.topTextEdit.setText(format(y1,'.2f'))
        #self.bottomTextEdit.setText(format(y2,'.2f'))

    def getPos(self):
        x1 = float(self.leftTextEdit.toPlainText())
        y1 = 0.0
        #y1 = float(self.topTextEdit.toPlainText())
        x2 = float(self.rightTextEdit.toPlainText())
        y2 = 0.0
        #y2 = float(self.bottomTextEdit.toPlainText())
        return [x1, y1, x2, y2]

    def roiCheckBoxChange(self):
        if self.roiCheckBox.isChecked():
            self.roiCheckBoxIndex = 1
            self.zoomSelected = True
            self.roiSelected = True
            self.canvas2.zoomSelected = True
            [_x1,_y1,_x2,_y2] = self.getPos()
            
            self.setRoi()
        else:
            self.roiCheckBoxIndex = 0
            self.roiSelected = False
            self.zoomSelected = False
            self.canvas2.zoomSelected = False
            self.canvas1.setRect([0,0,0,0])

    def textChange(self):
        self.setRoi()

    def setRoi(self):
        coord = {"roi": True, "pos": [87.0, 130.0, 97.0, 60.0]}
        path = '/MR/workspace/MantidData/roi'
        try:
            if self.neonServer == None:
                (neonStatus, self.neonServer) = \
                    self.parent.parent.parent.getNeon()
            if self.roiCheckBox.isChecked():
                self.roiSelected = True
                self.roiCheckBoxIndex = 1
                coord['pos'] = self.getPos()
                self.canvas1.setRect(coord['pos'])
            else:
                self.roiSelected = False
                self.roiCheckBoxIndex = 0
                coord['pos'] = [self.canvas1.x1, self.canvas1.y1, self.canvas1.x2, self.canvas1.y2]
            _num = self.getComboBoxTube() + 1
            coord['tubeNo'] = _num
            
            #self.roiCheckBoxChange()
            coord['roi'] = self.roiSelected
            _coord_json = jsonArray.jsonEncoder(coord)
            self.neonServer.set(path, _coord_json)
        except:
            pass
        self.parent.tabChange()
        self.getReflectionData()

    def tubeCheckBoxChange(self):
        if self.tube1CheckBox.isChecked():
            self.tube1Check = True
        else:
            self.tube1Check = False
        if self.tube2CheckBox.isChecked():
            self.tube2Check = True
        else:
            self.tube2Check = False
        if self.tube3CheckBox.isChecked():
            self.tube3Check = True
        else:
            self.tube3Check = False
        if self.tube4CheckBox.isChecked():
            self.tube4Check = True
        else:
            self.tube4Check = False

    def getTube1Check(self):
        return self.tube1Check

    def getTube2Check(self):
        return self.tube2Check

    def getTube3Check(self):
        return self.tube3Check

    def getTube4Check(self):
        return self.tube4Check

    def comboBoxTubeChange(self):
        index = self.comboBoxTube.currentIndex()
        self.parent.tabChange()
        self.getReflectionData()
        #self.canvas1.ax.set_xlabel('Tube' + str(index + 1))
        self.setRoi()

    def comboBoxUnit1Change(self):
        self.pix2 = None
        self.canvas2.zoomSelected = False
        self.parent.tabChange()
        self.getReflectionData()
        index = self.comboBoxUnit1.currentIndex()
        if index == 0:
            self.canvas2.ax.set_xlabel('TOF / us')  # q (A-1)')
        elif index == 1:
            self.canvas2.ax.set_xlabel('theta')  # q (A-1)')
        elif index == 2:
            self.canvas2.ax.set_xlabel('Wavelength')  # q (A-1)')
        self.canvas2.draw()

    def comboNormChange(self):
        self.pix3 = None
        self.canvas3.zoomSelected = False
        self.parent.tabChange()
        self.getReflectionData()

    def comboBoxLog1Change(self):
        self.pix2 = None
        self.canvas2.zoomSelected = False
        index = self.comboBoxLog1.currentIndex()
        if index == 0:
            self.canvas2.ax.set_yscale('linear')
        else:
            self.canvas2.ax.set_yscale('log')
        self.canvas2.draw()

    def comboBoxLog2xChange(self):
        self.pix3 = None
        self.canvas3.zoomSelected = False
        index = self.comboBoxLog2x.currentIndex()
        if index == 0:
            self.canvas3.ax.set_xscale('linear')
        else:
            self.canvas3.ax.set_xscale('log')
        self.canvas3.draw()

    def comboBoxLog2yChange(self):
        self.pix3 = None
        self.canvas3.zoomSelected = False
        index = self.comboBoxLog2y.currentIndex()
        if index == 0:
            self.canvas3.ax.set_yscale('linear')
        else:
            self.canvas3.ax.set_yscale('log')
        self.canvas3.draw()

    def getComboBoxTube(self):
        index = self.comboBoxTube.currentIndex()
        return index

    def getRoiVar(self):
        return self.roiSelected

    def log1Selected(self):
        index = self.comboBoxLog1.currentIndex()
        return index

    def unit1Selected(self):
        index = self.comboBoxUnit1.currentIndex()
        return index

    def log2Selected(self):
        index = self.comboBoxLog2.currentIndex()
        return index

    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        return index

    def getNeon(self):
        (neonStatus, self.neonServer) = \
            self.parent.parent.parent.getNeon()

    def getReflectionData(self):
        self.parent.getReflectionData()

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        self.value = value
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
            #try:
            #(_x, _y)=np.meshgrid(value[0],value[1])
            #self.canvas1.ax.plot_surface(_x, _y, np.array(value[2]), cmap=cm.coolwarm,linewidth=0, antialiased=False)
            #self.canvas1.ax.axis('off')
            #except:
            #    pass
            
        try:
            if str(value[2]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.draw()
            elif len(value[2]) == 0 or len(self.value[2]) \
                != len(value[2]):
                self.pix1 = None
            else:
                #if self.pix1 == None:
                self.canvas1.ax.clear()
                self.pix1 = \
                    self.canvas1.ax.pcolormesh(value[0],
                        value[1], value[2], cmap='rainbow',
                        zorder=1)
                self.canvas1.ax.add_patch(self.canvas1.rect)
                self.canvas1.ax.set_xlabel('X / mm')  # q (A-1)')
                self.canvas1.ax.set_ylabel('Y / mm')
                #else:
                #    self.pix1.set_array(np.array(value[2]).ravel())
                # self.canvas1.ax.axis('equal', adjustable='box')
                
                if self.canvas1.zoomSelected:
                    self.pix1 = None
                '''
                if self.canvas1.zoomSelected \
                    and self.canvas1.minX != self.canvas1.maxX \
                    and self.canvas1.minY != self.canvas1.maxY:
                    self.canvas1.ax.set_xlim(self.canvas1.minX,
                            self.canvas1.maxX)
                    self.canvas1.ax.set_ylim(self.canvas1.minY,
                            self.canvas1.maxY)
                if not self.colorbar:
                    self.colorbar = \
                        self.canvas1.fig.colorbar(self.pix1,
                            ax=self.canvas1.ax,
                            extend='max')
                    self.colorbar.ax.tick_params(labelsize=4)
                else:
                    self.colorbar.on_mappable_changed(self.pix1)
                '''
                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        try:
            index = self.comboBoxLog1.currentIndex()
            if self.roiSelected:
                self.pix2 = None
            if str(value[3]) == 'clear' or str(value[4]) == 'clear':
                self.canvas2.ax.clear()
                self.canvas2.draw()
            elif len(value[3]) != len(value[4]) or len(value[4]) \
                == 0:
                pass
            else:
                #if self.pix2 == None:
                self.canvas2.ax.clear()
                #(self.pix2, ) = \
                self.canvas2.ax.plot(value[3],
                        value[4], color='b')
                self.canvas2.ax.add_patch(self.canvas2.rect)
                self.roiSelected = False
                self.canvas2.ax.set_ylabel('Neutron Counts')
                index = self.comboBoxUnit1.currentIndex()
                if index == 0:
                    self.canvas2.ax.set_xlabel('TOF / us')  # q (A-1)')
                elif index == 1:
                    self.canvas2.ax.set_xlabel('theta')  # q (A-1)')
                elif index == 2:
                    self.canvas2.ax.set_xlabel('Wavelength')  # q (A-1)')
                #else:
                    # self.pix2.set_xdata(value[3])
                    #self.pix2.set_ydata(value[4])
                if self.canvas2.zoomSelected \
                    and self.canvas2.minX != self.canvas2.maxX \
                    and self.canvas2.minY != self.canvas2.maxY:
                    self.canvas2.ax.set_xlim(self.canvas2.minX,
                            self.canvas2.maxX)
                    self.canvas2.ax.set_ylim(self.canvas2.minY,
                            self.canvas2.maxY)
                _index = self.comboBoxLog1.currentIndex()
                if _index == 0:
                    self.canvas2.ax.set_yscale('linear')
                else:
                    #if 0 not in value[4]:
                    self.canvas2.ax.set_yscale('log')
                self.canvas2.ax.relim()
                self.canvas2.ax.autoscale_view()
                self.canvas2.draw()
        except:
            pass
            #self.pix2 = None
        try:
            if str(value[5]) == 'clear' or str(value[6]) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif len(value[5]) != len(value[6]) or len(value[6]) \
                == 0:
                pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
                #(self.pix3, ) = \
                self.canvas3.ax.plot(value[5],
                        value[6], color='g')
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_xlabel('q (A-1)')
                self.canvas3.ax.set_ylabel('Neutron Counts')
                #else:
                    # self.pix3.set_xdata(value[5])
                    #self.pix3.set_ydata(value[6])
                if self.canvas3.zoomSelected \
                    and self.canvas3.minX != self.canvas3.maxX \
                    and self.canvas3.minY != self.canvas3.maxY:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                xIndex = self.comboBoxLog2x.currentIndex()
                if xIndex == 0:
                    self.canvas3.ax.set_xscale('linear')
                else:
                    #if 0 not in value[5]:
                    self.canvas3.ax.set_xscale('log')
                yIndex = self.comboBoxLog2y.currentIndex()
                if yIndex == 0:
                    self.canvas3.ax.set_yscale('linear')
                else:
                    #if 0 not in value[6]:
                    self.canvas3.ax.set_yscale('log')
                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
            #self.pix3 = None
