#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.6.2
@author: yll
'''

from conf.constants import *

# user defined
# from model.readData import *
# from model.slitModel import *
# from presenter.slitSignal import *

from viewer.canvas import *
from math import asin

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)
        self.parent = parent

    def setupUi(self, Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # for main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        _width = 3.5
        self.canvas1 = figureCanvas(  # self.plotColor,
            self,
            _width,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )
        self.canvas1.ax.set_aspect('equal')

        self.canvas1.y1 = self.canvas1.ax.axhline(0, color='gray'
                , zorder=2)
        self.canvas1.x1 = self.canvas1.ax.axvline(0, color='gray'
                , zorder=2)
        self.canvas1.draw()
        self.mouseClickedEvents()

        # canvas for y, horizontal

        self.canvas3 = zoomCanvas(  # self.plotColor,
                                     # self.title,
            self,
            _width,
            1,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'X'
            'Qx',
            #'Neutron Counts',
            )
        self.canvas3.fig.subplots_adjust(left=0.25, bottom=0.40, right=0.95,
                                 top=0.95)
        self.canvas3.setMinimumHeight(50)

        # canvas for x, vertical

        self.canvas2 = zoomCanvas(  # self.plotColor,
                                       # self.title,
            self,
            1,
            _width,
            150,
            'AccentNeutron Distribution',
            'SpecNo',
            'Qy',
            'Y',
            #'Neutron Counts',
            )
        self.canvas2.fig.subplots_adjust(left=0.40, bottom=0.25, right=0.95,
                                 top=0.95)
        self.canvas2.setMinimumWidth(50)

        # self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)

        self.x1Label = QtGui.QLabel('X1:',self)
        self.x1Label.setMaximumWidth(31)
        self.x1TextEdit = QtGui.QTextEdit('0.0')
        self.x1TextEdit.setMaximumHeight(31)
        self.x1TextEdit.setMaximumWidth(91)
        
        self.x2Label = QtGui.QLabel('X2:',self)
        self.x2Label.setMaximumWidth(31)
        self.x2TextEdit = QtGui.QTextEdit('0.0')
        self.x2TextEdit.setMaximumHeight(31)
        self.x2TextEdit.setMaximumWidth(91)
        
        self.l2Label = QtGui.QLabel('L2:',self)
        self.l2Label.setMaximumWidth(31)
        self.l2TextEdit = QtGui.QTextEdit('2.0950')
        self.l2TextEdit.setMaximumHeight(31)
        self.l2TextEdit.setMaximumWidth(91)

        self.thetaLabel = QtGui.QLabel('theta:',self)
        self.thetaLabel.setMaximumWidth(41)
        self.thetaTextEdit = QtGui.QTextEdit('')
        self.thetaTextEdit.setMaximumHeight(31)
        self.thetaTextEdit.setMaximumWidth(91)
       
        self.fitButton = QtGui.QPushButton('Fit', self)
        self.fitButton.setMaximumHeight(30)
        self.fitButton.setMaximumWidth(100)
        self.fitButton.clicked.connect(self.fitButtonClicked)
 
        self.calButton = QtGui.QPushButton('Calculation', self)
        self.calButton.setMaximumHeight(30)
        self.calButton.setMaximumWidth(100)
        self.calButton.clicked.connect(self.calButtonClicked)

        self.posLabel = QtGui.QLabel('',self)
        self.posLabel.setMaximumHeight(31)

        _nline = 0
        self.mainGrid.addWidget(self.canvas3, _nline, 0, 3, 1)#,QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.x1Label, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.x1TextEdit, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.x2Label, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.x2TextEdit, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.l2Label, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.l2TextEdit, _nline, 2, 1, 3)
        _nline += 1
        self.mainGrid.addWidget(self.thetaLabel, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.thetaTextEdit, _nline, 2, 1, 3)
        _nline += 1
        self.mainGrid.addWidget(self.fitButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.calButton, _nline, 2, 1, 1)
        #_nline = 0
        #self.mainGrid.addWidget(self.first, _nline, 0, 1, 2,QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.canvas1, _nline, 0, 3, 1)#,QtCore.Qt.AlignVCenter)
        self.mainGrid.addWidget(
            self.canvas2,
            _nline,
            2,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.mainGrid.addWidget(self.posLabel, _nline, 0, 1, 2,QtCore.Qt.AlignCenter)

        # self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        # _nline += 1
        # self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)

        self.horizontalLayout.addWidget(self.scrollArea)

        self.value = None
        self.xdata = 0
        self.ydata = 0
        self.mouseClicked = False

        # horizontal canvas's x and y
        self.xFit = []
        self.yFit = []

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def setPeakText(self, x1, x2):
        self.x1TextEdit.setText(str(x1))
        self.x2TextEdit.setText(str(x2))

    def multiGaussianFit(self, x, y):
        from scipy.optimize import curve_fit
        def func(x,*param):
            return param[0]*np.exp(-np.power(x - param[2], 2.) / (2 * np.power(param[4], 2.)))+param[1]*np.exp(-np.power(x - param[3], 2.) / (2 * np.power(param[5], 2.)))

        _yMax1 = max(y)
        _yMax2 = y[0]
        for i in range(len(y)):
            if (y[i] > _yMax2) and (i != y.index(_yMax1)):
                _yMax2 = y[i]

        print _yMax1,_yMax2
        _xMax1 = x[y.index(_yMax1)]
        _xMax2 = x[y.index(_yMax2)]
        print _xMax1, _xMax2
        guess = [_yMax1, _yMax2, _xMax1, _xMax2, 10, 10]

        (popt, pcov) = curve_fit(func, x, y, p0=guess)
        #fit = func(x, *popt)
        print popt[2], popt[3]
        return popt[2], popt[3]

    def fitButtonClicked(self):
        try:
            _x1, _x2 = self.multiGaussianFit(self.xFit, self.yFit)
            self.setPeakText(_x1, _x2)
            #self.canvas3.x1 = self.canvas3.ax.axvline(_x1, color='gray', zorder=2)
            #self.canvas3.x2 = self.canvas3.ax.axvline(_x2, color='gray', zorder=2)
            _width = abs(float(_x2) - float(_x1))
            _l2 = float(self.l2TextEdit.toPlainText())*1000.0
            _theta = asin(_width/2.0/_l2)*180.0/3.14159*2
            self.thetaTextEdit.setText(str(_theta))
        except:
            logging.info("multi Gaussian Fit failure")

    def calButtonClicked(self):
        #try:
        _x1 = float(self.x1TextEdit.toPlainText())
        _x2 = float(self.x2TextEdit.toPlainText())
        #self.canvas3.x1 = self.canvas3.ax.axvline(_x1, color='gray', zorder=2)
        #self.canvas3.x2 = self.canvas3.ax.axvline(_x2, color='gray', zorder=2)
        _width = abs(float(_x2) - float(_x1))
        _l2 = float(self.l2TextEdit.toPlainText())*1000.0
        _theta = asin(_width/2.0/_l2)*180.0/3.14159*2
        self.thetaTextEdit.setText(str(_theta))
        #except:
        #    logging.info("multi Gaussian Fit failure")

    def mouseClickedEvents(self):
        self.canvas1.mpl_connect('button_press_event',
                                    self.changeRegion)

        # self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        # self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)

        self.canvas1.mpl_connect('button_press_event',
                                    self.changeXYFigure)

    def changeRegion(self, event):
        try:
            self.xdata = event.xdata
            self.ydata = event.ydata
            self.posLabel.setText('X=%.3f, '%self.xdata+'Y=%.3f'%self.ydata)

            _canvas = self.canvas1
            _canvas.ax.clear()
            _canvas.ax.contourf(self.value[0], self.value[1],
                                self.value[2], cmap='hot', zorder=1)
            (_xdata, _ydata, _xindex, _yindex) = \
                self.getXYData(event.xdata, event.ydata, self.value)
            if event.button == 1:

                # _canvas.x1.set_xdata([event.ydata,event.ydata])
                # _canvas.y1.set_ydata([event.xdata,event.xdata])

                _canvas.x1 = _canvas.ax.axhline(event.ydata, color='gray',
                        zorder=2)
                _canvas.y1 = _canvas.ax.axvline(event.xdata, color='gray',
                        zorder=2)
            elif event.button == 3:

                # _canvas.x1.set_xdata([event.ydata,event.ydata])
                # _canvas.y1.set_ydata([event.xdata,event.xdata])

                _canvas.x1 = _canvas.ax.axhline(event.ydata, color='gray',
                        zorder=2)
                _canvas.y1 = _canvas.ax.axvline(event.xdata, color='gray',
                        zorder=2)
            else:
                pass
            _canvas.ax.set_xlabel('X')
            _canvas.ax.set_ylabel('Y')
            _canvas.draw()
        except:
            pass

    def changeXYFigure(self, event):
        color2D = 'r'
        try:
            (_datax, _datay) = self.getCountsData(self.value)
        except:
            pass
        if event.button == 1:
            self.mouseClicked = True
            try:
                self.canvas2.ax.clear()
                self.canvas2.ax.plot(_datax, self.value[1],
                        color=color2D)
                self.canvas2.ax.set_xlabel('Qy')
                self.canvas2.ax.set_ylabel('Y')
                # self.canvas2.fig.set_xdata(_datax, color=color2D)

                self.canvas2.draw()
            except:
                pass
            try:
                self.canvas3.ax.clear()
                self.canvas3.ax.plot(self.value[0], _datay,
                        color=color2D)
                self.canvas3.ax.set_ylabel('Qx')
                self.canvas3.ax.set_xlabel('X')
                self.canvas3.draw()
            except:
                pass
        elif event.button == 3:
            self.mouseClicked = True
            try:
                self.canvas3.ax.clear()
                self.canvas3.ax.plot(self.value[0], _datay,
                        color=color2D)
                self.canvas3.ax.set_ylabel('Qx')
                self.canvas3.ax.set_xlabel('X')
                # self.canvas3.fig.set_ydata(_datay, color=color2D)

                self.canvas3.draw()
            except:
                pass
            try:
                self.canvas2.ax.clear()
                self.canvas2.ax.plot(_datax, self.value[1],
                        color=color2D)
                self.canvas2.ax.set_xlabel('Qy')
                self.canvas2.ax.set_ylabel('Y')
                self.canvas2.draw()
            except:
                pass
                
        self.xFit = self.value[0]
        self.yFit = _datay
    
    def getXYData(
        self,
        xdata,
        ydata,
        value,
        ):
        _xdata = 0
        _ydata = 0
        xlist = []
        ylist = []
        _minx = 0
        _miny = 0
        xindex = 0
        yindex = 0

        for i in range(len(value[0])):
            xlist.append(abs(value[0][i] - xdata))
        _minx = min(xlist)
        xindex = xlist.index(_minx)
        _xdata = value[0][xindex]

        for i in range(len(value[1])):
            ylist.append(abs(value[1][i] - ydata))
        _miny = min(ylist)
        yindex = ylist.index(_miny)
        _ydata = value[1][yindex]

        # self.xEventData = _xdata
        # self.yEventData = _ydata

        return (_xdata, _ydata, xindex, yindex)

    def getCountsData(self, value):
        xcounts = []
        ycounts = []
        (_xdata, _ydata, xindex, yindex) = self.getXYData(self.xdata,
                self.ydata, self.value)
        ytmp = value[2][yindex]
        for j in ytmp:
            ycounts.append(j)

        for i in range(len(value[1])):
            xcounts.append(value[2][i][xindex])
        return (xcounts, ycounts)

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        self.value = value
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
        color2D = 'r'
        color3D = 'hot'
        try:
            if str(value[2]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.draw()
            elif not value[2]:
                pass
            elif len(value[2]) == 0:
                pass
            else:
                #if not self.pix1:
                self.canvas1.ax.clear()
                #self.pix1 = self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                self.pix1 = \
                    self.canvas1.ax.contourf(value[0],
                        value[1], value[2], cmap=color3D,
                        zorder=1)
                self.canvas1.ax.set_xlabel('X')
                self.canvas1.ax.set_ylabel('Y')
                #else:
                #    self.pix1.set_array(np.array(value[2]).ravel())
                self.canvas1.y1 = \
                    self.canvas1.ax.axhline(self.ydata,
                        color='gray', zorder=2)
                self.canvas1.x1 = \
                    self.canvas1.ax.axvline(self.xdata,
                        color='gray', zorder=2)
                try:
                    if self.canvas1.scale_factor != 1.0:
                        self.canvas1.ax.set_xlim([self.canvas1.xdata - self.canvas1.new_width * (1-self.canvas1.relx), self.canvas1.xdata + self.canvas1.new_width * (self.canvas1.relx)])
                        self.canvas1.ax.set_ylim([self.canvas1.ydata - self.canvas1.new_height * (1-self.canvas1.rely), self.canvas1.ydata + self.canvas1.new_height * (self.canvas1.rely)])
                    else:
                        self.pix1 = None
                except:
                    pass
                # self.canvas1.ax.relim()
                # self.canvas1.ax.autoscale_view(True, True, True)

                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        try:
            if not self.mouseClicked:
                (_datax, _datay) = \
                    self.getCountsData(self.value)
                if str(self.value[1]) == 'clear' or str(_datax) == 'clear':
                    self.canvas2.ax.clear()
                    self.canvas2.draw()
                    pass
                elif not self.value[1]:
                    pass
                elif len(self.value[1]) != len(_datax) \
                    or len(_datax) == 0:
                    pass
                else:
                    #if not self.pix2:
                    self.canvas2.ax.clear()
                    (self.pix2, ) = \
                        self.canvas2.ax.plot(_datax,
                            self.value[1], color=color2D)
                    self.canvas2.ax.add_patch(self.canvas2.rect)
                    #self.canvas2.ax.set_xlabel('Neutron Counts')
                    self.canvas2.ax.set_xlabel('Qy')
                    self.canvas2.ax.set_ylabel('Y')
                    #else:
                    #    self.pix2.set_xdata(_datax)
                    #    self.pix2.set_ydata(self.value[1])
                    if self.canvas2.zoomSelected \
                        and self.letfCanvas.minX \
                        != self.canvas2.maxX \
                        and self.canvas2.minY \
                        != self.canvas2.maxY:
                        self.canvas2.ax.set_xlim(self.canvas2.minX,
                                self.canvas2.maxX)
                        self.canvas2.ax.set_ylim(self.canvas2.minY,
                                self.canvas2.maxY)
                    elif self.canvas2.scale_factor != 1.0:
                        self.canvas2.ax.set_xlim([self.canvas2.xdata - self.canvas2.new_width * (1-self.canvas2.relx), self.canvas2.xdata + self.canvas2.new_width * (self.canvas2.relx)])
                        self.canvas2.ax.set_ylim([self.canvas2.ydata - self.canvas2.new_height * (1-self.canvas2.rely), self.canvas2.ydata + self.canvas2.new_height * (self.canvas2.rely)])
                    # self.canvas2.fig.set_xdata(_datax, color=color2D)

                    self.canvas2.ax.relim()
                    self.canvas2.ax.autoscale_view()
                    self.canvas2.draw()
        except:
            pass
            #self.pix2 = None
        try:
            if str(self.value[0]) == 'clear' or str(_datay) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif not self.value[0]:
                pass
            elif len(self.value[0]) != len(_datay) or len(_datay) \
                == 0:
                pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
                (self.pix3, ) = \
                    self.canvas3.ax.plot(self.value[0],
                        _datay, color=color2D)
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_ylabel('Qx'
                        )
                self.canvas3.ax.set_xlabel('X')
                #else:
                #    self.pix3.set_xdata(self.value[0])
                #    self.pix3.set_ydata(_datay)
                if self.canvas3.zoomSelected \
                    and self.canvas3.minX \
                    != self.canvas3.maxX \
                    and self.canvas3.minY \
                    != self.canvas3.maxY:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                elif self.canvas3.scale_factor != 1.0:
                    self.canvas3.ax.set_xlim([self.canvas3.xdata - self.canvas3.new_width * (1-self.canvas3.relx), self.canvas3.xdata + self.canvas3.new_width * (self.canvas3.relx)])
                    self.canvas3.ax.set_ylim([self.canvas3.ydata - self.canvas3.new_height * (1-self.canvas3.rely), self.canvas3.ydata + self.canvas3.new_height * (self.canvas3.rely)])

                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
            #self.pix3 = None
