'''
Created on 2015.6.2
@author: yll
'''
# configure
from conf.constants import *

# user defined
from model.readData import *
from model.slitModel import *
from presenter.slitSignal import *
from viewer.canvas import *

class CSNSSlitPage(QtGui.QWidget):

    def __init__(self):
        super(CSNSSlitPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QWidget):
#        self.horizontalLayoutWidget = QtGui.QWidget(self.tab_slit)
        self.horizontalLayout = QtGui.QHBoxLayout(self)

        #slit tab control
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaLeft = QtGui.QScrollArea()
        self.scrollAreaLeft.setWidgetResizable(True)
        self.scrollAreaLeft.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)

        #for left grid label
        self.slitAnimationLabel = QtGui.QLabel("Slit Animation")

        # canvas for time frame
        self.slitAnimationFigure = Figure((8,2), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)
        self.slitAnimationCanvas = FigureCanvas(self.slitAnimationFigure)

        self.slitAnimationCanvas.setParent(self.first)
        self.slitAnimationAxes = self.slitAnimationFigure.add_subplot(111)
        self.slitAnimationAxes.tick_params(axis='both', which='major', labelsize=5)
        self.slitAnimationCanvas.draw()

        '''
        # canvas for slitImage
        self.slitImageFigure= Figure((3,2), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)
        self.slitImageCanvas = FigureCanvas(self.slitImageFigure)
        self.slitImageAxes = self.slitImageFigure.add_subplot(111, projection='3d')
        self.slitImageAxes.tick_params(axis='both', which='major', labelsize=6)

        dataX, dataY, dataZ = CSNSRead3DData("./dat/3d1.dat")
        self.slitImageAxes.clear()
        self.slitImageAxes.plot_surface(dataX, dataY, dataZ,rstride=8, cstride=8, alpha=0.3, cmap=cm.PiYG)
        cset = self.slitImageAxes.contourf(dataX, dataY, dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        cset = self.slitImageAxes.contourf(dataX, dataY, dataZ, zdir='x', offset=50, cmap=cm.Blues)
        cset = self.slitImageAxes.contourf(dataX, dataY, dataZ, zdir='y',offset=100, cmap=cm.Greens)
        self.slitImageCanvas.draw()
        '''
         # canvas for slitImage
        self.slitImageCanvas= CSNSCanvas(self)

        self.dataX, self.dataY, self.dataZ = CSNSRead3DData("./dat/3d1.dat")
        #self.slitImageCanvas.clear()
        cset = self.slitImageCanvas.ax.contourf(self.dataY, self.dataX, self.dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        self.slitImageCanvas.x1 = self.slitImageCanvas.ax.axhline(52,color='white')
        self.slitImageCanvas.x2 = self.slitImageCanvas.ax.axhline(48,color='white')
        self.slitImageCanvas.y1 = self.slitImageCanvas.ax.axvline(48,color='gray')
        self.slitImageCanvas.y2 = self.slitImageCanvas.ax.axvline(52,color='gray')
        self.slitImageCanvas.draw()

        self.slitImageEvents()

        # canvas for slit x
        self.slitXCanvas = CSNSCanvas(self, 3, 2)

        nx, dataX = CSNSRead2DData("./dat/2d-x.dat")
        _tmp=self.slitXCanvas.ax.plot(dataX[0],dataX[1],color='red')
        self.slitXCanvas.slitXFigure=_tmp[0]
        self.slitXCanvas.draw()

        # canvas for slit y
        self.slitYCanvas = CSNSCanvas(self, 3, 2)

        ny, dataY = CSNSRead2DData("./dat/2d-y.dat")
        _tmp=self.slitYCanvas.ax.plot(dataY[0],dataY[1],color='green')
        self.slitYCanvas.slitYFigure=_tmp[0]
        self.slitYCanvas.draw()

        # parameter grid
        self.incidentAngleLabel = QtGui.QLabel("Incident Angle: ")
        self.incidentAngleText = QtGui.QLabel("3")
        self.reflectedAngleLabel =  QtGui.QLabel("Reflected Angle: ")
        self.reflectedAngleText=QtGui.QLabel("0.1")
        self.divergenceAngleLabel =  QtGui.QLabel("Divergence Angle: ")
        self.divergenceAngleText=QtGui.QLabel("0.3712")
        self.resolutionAngleLabel =  QtGui.QLabel("Angle Resolution: ")
        self.resolutionAngleText=QtGui.QLabel("0.034")

        self.directBeamLabel =  QtGui.QLabel("<font color=red>Direct Beam</font>")
        self.directCenterLabel=QtGui.QLabel("Center: ")
        self.directCenterText=QtGui.QLabel("12")
        self.directLeftLabel=QtGui.QLabel("Left: ")
        self.directLeftText=QtGui.QLabel("10")
        self.directRightLabel=QtGui.QLabel("Right: ")
        self.directRightText=QtGui.QLabel("14")
        self.directTopLabel=QtGui.QLabel("Top: ")
        self.directTopText=QtGui.QLabel("65")
        self.directBottomLabel=QtGui.QLabel("Bottom: ")
        self.directBottomText=QtGui.QLabel("35")

        self.reflectedBeamLabel =  QtGui.QLabel("<font color=red>Reflected Beam</font>")
        self.reflectedCenterLabel=QtGui.QLabel("Center: ")
        self.reflectedCenterText=QtGui.QLabel("12")
        self.reflectedLeftLabel=QtGui.QLabel("Left: ")
        self.reflectedLeftText=QtGui.QLabel("10")
        self.reflectedRightLabel=QtGui.QLabel("Right: ")
        self.reflectedRightText=QtGui.QLabel("14")
        self.reflectedTopLabel=QtGui.QLabel("Top: ")
        self.reflectedTopText=QtGui.QLabel("65")
        self.reflectedBottomLabel=QtGui.QLabel("Bottom: ")
        self.reflectedBottomText=QtGui.QLabel("35")

        self.parameterWidget= QtGui.QWidget(self.first)
        self.parameterGrid = QtGui.QGridLayout(self.parameterWidget)
        self.parameterGrid.addWidget(self.incidentAngleLabel,  0,0,1,1)
        self.parameterGrid.addWidget(self.incidentAngleText,   0,1,1,1)
        self.parameterGrid.addWidget(self.reflectedAngleLabel, 0,2,1,1)
        self.parameterGrid.addWidget(self.reflectedAngleText,  0,3,1,1)
        self.parameterGrid.addWidget(self.divergenceAngleLabel,0,4,1,1)
        self.parameterGrid.addWidget(self.divergenceAngleText, 0,5,1,1)
        self.parameterGrid.addWidget(self.resolutionAngleLabel,0,6,1,1)
        self.parameterGrid.addWidget(self.resolutionAngleText, 0,7,1,1)

        self.parameterGrid.addWidget(self.directBeamLabel,   1,0,1,10)
        self.parameterGrid.addWidget(self.directCenterLabel, 2,0,1,1)
        self.parameterGrid.addWidget(self.directCenterText,  2,1,1,1)
        self.parameterGrid.addWidget(self.directLeftLabel,   2,2,1,1)
        self.parameterGrid.addWidget(self.directLeftText,    2,3,1,1)
        self.parameterGrid.addWidget(self.directRightLabel,  2,4,1,1)
        self.parameterGrid.addWidget(self.directRightText,   2,5,1,1)
        self.parameterGrid.addWidget(self.directBottomLabel, 2,6,1,1)
        self.parameterGrid.addWidget(self.directBottomText,  2,7,1,1)
        self.parameterGrid.addWidget(self.directTopLabel,    2,8,1,1)
        self.parameterGrid.addWidget(self.directTopText,     2,9,1,1)

        self.parameterGrid.addWidget(self.reflectedBeamLabel,   3,0,1,10)
        self.parameterGrid.addWidget(self.reflectedCenterLabel, 4,0,1,1)
        self.parameterGrid.addWidget(self.reflectedCenterText,  4,1,1,1)
        self.parameterGrid.addWidget(self.reflectedLeftLabel,   4,2,1,1)
        self.parameterGrid.addWidget(self.reflectedLeftText,    4,3,1,1)
        self.parameterGrid.addWidget(self.reflectedRightLabel,  4,4,1,1)
        self.parameterGrid.addWidget(self.reflectedRightText,   4,5,1,1)
        self.parameterGrid.addWidget(self.reflectedBottomLabel, 4,6,1,1)
        self.parameterGrid.addWidget(self.reflectedBottomText,  4,7,1,1)
        self.parameterGrid.addWidget(self.reflectedTopLabel,    4,8,1,1)
        self.parameterGrid.addWidget(self.reflectedTopText,     4,9,1,1)

        self.mainGrid.addWidget(self.slitAnimationLabel,0,0,1,4)
        self.mainGrid.addWidget(self.slitAnimationCanvas,1,0,1,4)
        self.mainGrid.addWidget(self.slitImageCanvas,2,1,2,1)
        self.mainGrid.addWidget(self.slitXCanvas,2,2,1,1)
        self.mainGrid.addWidget(self.slitYCanvas,3,2,1,1)
        self.mainGrid.addWidget(self.parameterWidget,4,0,1,4)

        '''
        Window for right panel
        '''
        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaRight = QtGui.QScrollArea()
        self.scrollAreaRight.setWidgetResizable(True)
        self.scrollAreaRight.setWidget(self.second)

        self.rightGrid = QtGui.QGridLayout(self.second)


        # for sample
        self.sampleLabel = QtGui.QLabel("<font color=red>Sample</font>", self.second)

        self.samplePositionLabel = QtGui.QLabel("Position: 0 mm", self.second)
        self.sampleWidthLabel = QtGui.QLabel("Width X Height(mm)", self.second)

        self.sampleWidthTextEdit=QtGui.QTextEdit("0.1")
        self.sampleWidthTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.sampleHeightTextEdit=QtGui.QTextEdit("10")
        self.sampleHeightTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        # for slit1
        self.slit1Label = QtGui.QLabel("<font color=red>Slit1</font>", self.second)

        self.slit1PositionLabel = QtGui.QLabel("Position: -2315 mm", self.second)

        self.slit1CheckBox = QtGui.QCheckBox("Auto Alignment", self.second)
	self.slit1CheckBox.setCheckState(QtCore.Qt.Checked)

        self.slit1WidthLabel = QtGui.QLabel("Width X Height(mm)", self.second)
        self.slit1WidthTextEdit=QtGui.QTextEdit("0.1")
        self.slit1WidthTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit1HeightTextEdit=QtGui.QTextEdit("20")
        self.slit1HeightTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit1OffsetLabel = QtGui.QLabel("Offset: Width X Height(mm)", self.second)
        self.slit1WidthOffsetTextEdit=QtGui.QTextEdit("0.0")
        self.slit1WidthOffsetTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit1HeightOffsetTextEdit=QtGui.QTextEdit("0.0")
        self.slit1HeightOffsetTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        # for slit2
        self.slit2Label = QtGui.QLabel("<font color=red>Slit2</font>", self.second)

        self.slit2PositionLabel = QtGui.QLabel("Position: -635 mm", self.second)

        self.slit2CheckBox = QtGui.QCheckBox(self.second)

        self.slit2WidthLabel = QtGui.QLabel("Width X Height(mm)", self.second)

        self.slit2WidthTextEdit=QtGui.QTextEdit("0.1")
        self.slit2WidthTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit2HeightTextEdit=QtGui.QTextEdit("12.7")
        self.slit2HeightTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit2OffsetLabel = QtGui.QLabel("Offset: Width X Height(mm)", self.second)
        self.slit2WidthOffsetTextEdit=QtGui.QTextEdit("0.0")
        self.slit2WidthOffsetTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit2HeightOffsetTextEdit=QtGui.QTextEdit("0.0")
        self.slit2HeightOffsetTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        # for slit3
        self.slit3Label = QtGui.QLabel("<font color=red>Slit3</font>", self.second)

        self.slit3PositionLabel = QtGui.QLabel("Position: 650 mm", self.second)

        self.slit3CheckBox = QtGui.QCheckBox(self.second)

        self.slit3WidthLabel = QtGui.QLabel("Width X Height(mm)", self.second)
        self.slit3WidthTextEdit=QtGui.QTextEdit("0.1")
        self.slit3WidthTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit3HeightTextEdit=QtGui.QTextEdit("18.366")
        self.slit3HeightTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit3OffsetLabel = QtGui.QLabel("Offset: Width X Height(mm)", self.second)
        self.slit3WidthOffsetTextEdit=QtGui.QTextEdit("0.0")
        self.slit3WidthOffsetTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.slit3HeightOffsetTextEdit=QtGui.QTextEdit("0.0")
        self.slit3HeightOffsetTextEdit.setMaximumHeight(CSNStextMaximumHeight)
        # for button
        self.cancelButton = QtGui.QPushButton("Default",self.second)
        self.okButton = QtGui.QPushButton("Set",self.second)

        #self.slit1TextEdit.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Fixed)

        '''
        # add QVBox
        '''
        nrow=-1
        nrow+=1
        self.rightGrid.addWidget(self.sampleLabel,    nrow, 0, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.samplePositionLabel, nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.sampleWidthLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.sampleWidthTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.sampleHeightTextEdit,nrow, 1, 1, 1)

        nrow+=1
        self.rightGrid.addWidget(self.slit1Label,    nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit1CheckBox, nrow, 1, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.slit1PositionLabel, nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit1WidthLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit1WidthTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit1HeightTextEdit,nrow, 1, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.slit1OffsetLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit1WidthOffsetTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit1HeightOffsetTextEdit,nrow, 1, 1, 1)

        nrow+=1
        self.rightGrid.addWidget(self.slit2Label,    nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit2CheckBox, nrow, 1, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.slit2PositionLabel, nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit2WidthLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit2WidthTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit2HeightTextEdit,nrow, 1, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.slit2OffsetLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit2WidthOffsetTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit2HeightOffsetTextEdit,nrow, 1, 1, 1)

        nrow+=1
        self.rightGrid.addWidget(self.slit3Label,    nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit3CheckBox, nrow, 1, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.slit3PositionLabel, nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit3WidthLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit3WidthTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit3HeightTextEdit,nrow, 1, 1, 1)
        nrow+=1
        self.rightGrid.addWidget(self.slit3OffsetLabel,nrow, 0, 1, 2)
        nrow+=1
        self.rightGrid.addWidget(self.slit3WidthOffsetTextEdit, nrow, 0, 1, 1)
        self.rightGrid.addWidget(self.slit3HeightOffsetTextEdit,nrow, 1, 1, 1)

        nrow+=1
        self.rightGrid.addWidget(self.cancelButton, nrow,0, 1, 1, QtCore.Qt.AlignLeft)
        self.rightGrid.addWidget(self.okButton, nrow,1, 1, 1, QtCore.Qt.AlignLeft)
        nrow+=1
        self.rightGrid.addItem(QtGui.QSpacerItem(-1, -1, QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Expanding), nrow, 0)

        '''
        # add QSplitter
        '''
        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)
        self.splitter.addWidget(self.scrollAreaLeft)
        self.splitter.addWidget(self.scrollAreaRight)
        self.splitter.setSizes([500, 200])
        self.horizontalLayout.addWidget(self.splitter)

    def updateSlitAnimation(self, slitList, heightList):
        self.slitAnimationAxes.clear()
        #self.slitAnimationAxes.YTick=chopperList

        _slitHeight=5
        self.slitAnimationAxes.text(slitList[0],max(heightList)/2+5 , 'Slit1',   fontsize=5)
        self.slitAnimationAxes.text(slitList[1],max(heightList)/2+5 , 'Slit2',   fontsize=5)
        self.slitAnimationAxes.text(slitList[2],max(heightList)/2+5 , 'Sample',   fontsize=5)
        self.slitAnimationAxes.text(slitList[3],max(heightList)/2+5 , 'Slit3',   fontsize=5)

        _x0=slitList[0]
        _y0=heightList[0]/2
        _x1=slitList[1]
        _y1=-heightList[1]/2
        _x3=slitList[3]
        _y3=(_y1-_y0)/(_x1-_x0)*(_x3-_x0)+_y0

        self.slitAnimationAxes.plot((slitList[0],slitList[2]), (heightList[0]/2, heightList[2]/2), color='orange')
        self.slitAnimationAxes.plot((slitList[0],slitList[3]), (heightList[0]/2, -heightList[3]/2), color='green')
        self.slitAnimationAxes.plot((_x0,_x3), (_y0, _y3), color='blue',linestyle='dashed')

        self.slitAnimationAxes.plot((slitList[0],slitList[2]), (-heightList[0]/2, -heightList[2]/2), color='orange')
        self.slitAnimationAxes.plot((slitList[0],slitList[3]), (-heightList[0]/2, heightList[3]/2), color='green')
        self.slitAnimationAxes.plot((_x0,_x3), (-_y0, -_y3), color='blue', linestyle='dashed')

        for i in range(0,len(slitList)):
            if i==2:
                self.slitAnimationAxes.plot( (slitList[i], slitList[i]), (-heightList[i]/2,heightList[i]/2),linewidth=2, color='red')
            elif i==3:
                self.slitAnimationAxes.plot( (slitList[i], slitList[i]), (heightList[i]/2,-_y3+2),linewidth=2, color='black')
                self.slitAnimationAxes.plot( (slitList[i], slitList[i]), (-heightList[i]/2,_y3-2),linewidth=2, color='black')
            else:
                self.slitAnimationAxes.plot( (slitList[i], slitList[i]), (heightList[i]/2,heightList[i]/2+_slitHeight),linewidth=2, color='black')
                self.slitAnimationAxes.plot( (slitList[i], slitList[i]), (-heightList[i]/2,-heightList[i]/2-_slitHeight),linewidth=2, color='black')

        self.slitAnimationCanvas.draw()

    def updateSlitImage(self):
        pass

    def slitImageEvents(self):
        self.slitImageCanvas.mpl_connect('button_press_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)
        self.slitImageCanvas.mpl_connect('button_press_event', self.changeXYFigure)

    def changeRegion(self,event):
        _canvas = self.slitImageCanvas

        if event.button == 1:
            _canvas.x1.set_ydata([event.ydata,event.ydata])
            _canvas.draw()
            self.slitXCanvas.draw()
        elif event.button == 3:
            _canvas.y1.set_xdata([event.xdata,event.xdata])
            _canvas.draw()
        else:
            pass

    def changeXYFigure(self,event):

        if event.button == 1:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitXCanvas.slitXFigure.set_xdata(dataYZ[0])
            self.slitXCanvas.slitXFigure.set_ydata(dataYZ[1])
            self.slitYCanvas.slitYFigure.set_xdata(dataXZ[0])
            self.slitYCanvas.slitYFigure.set_ydata(dataXZ[1])
            self.slitXCanvas.draw()
            self.slitYCanvas.draw()
        elif event.button == 3:
            dataYZ, dataXZ = getXYdata(event.ydata, event.xdata, self.dataX, self.dataY, self.dataZ)
            self.slitYCanvas.slitYFigure.set_xdata(dataXZ[0])
            self.slitYCanvas.slitYFigure.set_ydata(dataXZ[1])
            self.slitYCanvas.draw()
        else:
            pass
