'''
Created on 2015.6.2
@author: yll

sample
'''

from conf.constants import *

from model.sampleModel import *
from model.readData import *

class CSNSSamplePage(QtGui.QWidget):

    def __init__(self):
        super(CSNSSamplePage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.sampleLabel = QtGui.QLabel("Sample")

        self.sampleTableView = QtGui.QTableWidget(self)
        self.sampleTableView.setSizePolicy(CSNSsizePolicy)
        self.sampleTableView.setMinimumHeight(CSNStableMinimumHeight)

        sampleList, peakList, areaList = sampleModel()
        _npoint=len(sampleList)
        self.sampleTableView.setColumnCount(_npoint+1)
        _header=[]
        _header.append(" ")
        for i in range(_npoint):
            _header.append(str(i+1))
        self.sampleTableView.setHorizontalHeaderLabels(_header)

        self.sampleTableView.insertRow(0)
        self.sampleTableView.insertRow(1)
        self.sampleTableView.insertRow(2)
        _tmp=QtGui.QTableWidgetItem("Position")
        self.sampleTableView.setItem(0, 0, _tmp)
        _tmp=QtGui.QTableWidgetItem("Peak")
        self.sampleTableView.setItem(1, 0, _tmp)
        _tmp=QtGui.QTableWidgetItem("Area")
        self.sampleTableView.setItem(2, 0, _tmp)

        for i in range(_npoint):
            _tmp=QtGui.QTableWidgetItem(str(sampleList[i]))
            self.sampleTableView.setItem(0, i+1, _tmp)
            _tmp=QtGui.QTableWidgetItem(str(peakList[i]))
            self.sampleTableView.setItem(1, i+1, _tmp)
            _tmp=QtGui.QTableWidgetItem(str(areaList[i]))
            self.sampleTableView.setItem(2, i+1, _tmp)

        # self.sampleTableView.resizeColumnsToContents()

        # canvas for 3D
        self.sampleFigure = Figure((8,4), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)
        self.sampleCanvas = FigureCanvas(self.sampleFigure)
        self.sampleAxes = self.sampleFigure.add_subplot(111,projection='3d')
        self.sampleFigure.subplots_adjust(left=0.05,bottom=0.05,right=0.95,top=0.95)
        self.sampleAxes.tick_params(axis='both', which='major', labelsize=5)

        dataX, dataY, dataZ = CSNSRead3DData("./dat/3d1.dat")
        self.sampleAxes.clear()
        self.sampleAxes.plot_surface(dataX, dataY, dataZ, rstride=1, cstride=1, alpha=0.7, cmap=cm.coolwarm, linewidth=0, antialiased=True)
        #cset = self.sampleAxes.contourf(dataX, dataY, dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        self.sampleCanvas.draw()

        # canvas for sample 1
        self.samplePeakFigure = Figure((4,3), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)
        self.samplePeakCanvas = FigureCanvas(self.samplePeakFigure)
        self.samplePeakAxes = self.samplePeakFigure.add_subplot(111)
        self.samplePeakFigure.subplots_adjust(left=0.1,bottom=0.25,right=0.95,top=0.95)
        self.samplePeakAxes.tick_params(axis='both', which='major', labelsize=5)
        self.samplePeakAxes.plot(sampleList,peakList,color='red',marker='+')
        self.samplePeakCanvas.draw()

        # canvas for sample 2
        self.sampleAreaFigure = Figure((4,3), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)
        self.sampleAreaCanvas = FigureCanvas(self.sampleAreaFigure)
        self.sampleAreaAxes = self.sampleAreaFigure.add_subplot(111)
        self.sampleAreaFigure.subplots_adjust(left=0.1,bottom=0.25,right=0.95,top=0.95)
        self.sampleAreaAxes.tick_params(axis='both', which='major', labelsize=5)
        self.sampleAreaAxes.plot(sampleList,areaList,color='green',marker='+')
        self.sampleAreaCanvas.draw()

        self.mainWidget= QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainWidget)
        self.mainGrid.setVerticalSpacing(1)

        self.roiLabel =  QtGui.QLabel("<font color=red>Beam ROI: </font>")
        self.roiLeftLabel=QtGui.QLabel("Left: ")
        self.roiLeftText=QtGui.QLabel("10")
        self.roiRightLabel=QtGui.QLabel("Right: ")
        self.roiRightText=QtGui.QLabel("14")
        self.roiTopLabel=QtGui.QLabel("Top: ")
        self.roiTopText=QtGui.QLabel("65")
        self.roiBottomLabel=QtGui.QLabel("Bottom: ")
        self.roiBottomText=QtGui.QLabel("35")

        self.positionLabel =  QtGui.QLabel("<font color=red>Sample Position: </font>")
        self.positionCenterLabel=QtGui.QLabel("Center")
        self.positionCenterText=QtGui.QLabel("1.67 mm")
        self.positionErrorLabel=QtGui.QLabel("Offset")
        self.positionErrorText=QtGui.QLabel("+/- 0.02 mm")

        self.mainGrid.addWidget(self.samplePeakCanvas, 0,0,1,4)
        self.mainGrid.addWidget(self.sampleAreaCanvas, 0,4,1,4)

        self.mainGrid.addItem(QtGui.QSpacerItem(-1, -1, QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Expanding), 1, 0)

        self.mainGrid.addWidget(self.roiLabel, 2,0,1,2)
        ncol=-1
        ncol+=1
        self.mainGrid.addWidget(self.roiLeftLabel,   3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiLeftText,    3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiRightLabel,  3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiRightText,   3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiBottomLabel, 3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiBottomText,  3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiTopLabel,    3,ncol,1,1)
        ncol+=1
        self.mainGrid.addWidget(self.roiTopText,     3,ncol,1,1)

        self.mainGrid.addWidget(self.positionLabel, 4,0,1,2)
        self.mainGrid.addWidget(self.positionCenterLabel,   5,0,1,1)
        self.mainGrid.addWidget(self.positionCenterText,    5,1,1,1)
        self.mainGrid.addWidget(self.positionErrorLabel,    5,2,1,1)
        self.mainGrid.addWidget(self.positionErrorText,     5,3,1,1)

        self.verticalLayout.addWidget(self.sampleLabel)
        self.verticalLayout.addWidget(self.sampleTableView)
        self.verticalLayout.addWidget(self.sampleCanvas)
        self.verticalLayout.addWidget(self.mainWidget)
