from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined
from slit import *
from chopper import *
from sample import *
from detector import *
from analysis import *
from reduction import *

from model.chopperModel import *
from model.slitModel import *

class CSNSMainTab(QtGui.QTabWidget):
    def __init__(self, parent=None):
        super(CSNSMainTab, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self,QTabWidget):

        #self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.chopperPage = CSNSChopperPage(self)
        self.slitPage = CSNSSlitPage()
        self.samplePage = CSNSSamplePage()
        self.detectorPage = CSNSDetectorPage()
        self.analysisPage = CSNSAnalysisPage()
        #self.reductionPage = CSNSReductionPage(self)

	'''
        self.tfvalue = TimeFrameCalculation(0.5, 6.0)
        pulseList, chopperList, timeList, xList, yList=self.tfvalue.getTimeFrame()
        self.chopperPage.updateTimeFrame(pulseList, chopperList, timeList, xList, yList)
	'''

        self.slitValue = SlitCalculation()
        slitList, heightList = self.slitValue.getSlitHeight()
        self.slitPage.updateSlitAnimation(slitList, heightList)
	
        self.addTab(self.chopperPage, "Chopper")
        self.addTab(self.slitPage, "Slit")
        self.addTab(self.samplePage, "Sample")
        self.addTab(self.detectorPage, "Detector")
        self.addTab(self.analysisPage, "Analysis")
        #self.addTab(self.reductionPage, "Reduction")

