'''
Created on 2015.5.5
@author: yll

Detector
'''

#configure
from conf.constants import *
import logging

#user defined
from model.readData import *
from model.chopperModel import *
from canvas import *

import random

class CSNSDetectorPage(QtGui.QWidget):

    def __init__(self):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QWidget):
        self.horizontalLayout = QtGui.QHBoxLayout(self)

        #for right  grid
        self.leftWidget = QtGui.QWidget(self)
        self.leftGrid   = QtGui.QGridLayout(self.leftWidget)
        self.leftGrid.setSpacing(10)

        self.applyButton  = QtGui.QPushButton("Apply",self.leftWidget)
        self.cancelButton = QtGui.QPushButton("Cancel",self.leftWidget)
        self.undoButton   = QtGui.QPushButton("Undo",self.leftWidget)
        
        self.leftGrid.addItem(QtGui.QSpacerItem(-1, -1, QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Expanding), 0, 0)
        self.leftGrid.addWidget(self.applyButton,  1, 0, 1, 1 )
        self.leftGrid.addWidget(self.cancelButton, 2, 0, 1, 1 )
        self.leftGrid.addWidget(self.undoButton,   3, 0, 1, 1 )
        self.leftGrid.addItem(QtGui.QSpacerItem(-1, -1, QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Expanding), 4, 0)

         # canvas for detector
	self.detectorCanvas = CSNSCanvas(
	    self ,
	    8,
    	    4,
	    150,
	    xlabel='Time of Flight (ms)',
            ylabel='Distance (m)',
	    )
	self.detectorCanvas.fig.subplots_adjust(left=0.05,bottom=0.05,right=0.95,top=0.95)
	self.dataX, self.dataY, self.dataZ = CSNSRead3DData("./dat/detector.dat")
	cset = self.detectorCanvas.ax.contourf(self.dataY, self.dataX, self.dataZ, zdir='z', offset=0, cmap=cm.hot)
        self.rect = Rectangle((0,0), 0, 0, facecolor='white', edgecolor='None', alpha=0.8)
        self.detectorCanvas.ax.add_patch(self.rect)

        self.detectorCanvas.draw()
        self.detectorEvents()

        '''
	self.detectorCanvas= CSNSCanvas(self)
        self.detectorCanvas.fig.subplots_adjust(left=0.05,bottom=0.05,right=0.95,top=0.95)

        self.dataX, self.dataY, self.dataZ = CSNSRead3DData("./dat/detector.dat")
        cset = self.detectorCanvas.ax.contourf(self.dataY, self.dataX, self.dataZ, zdir='z', offset=0, cmap=cm.hot)
        self.rect = Rectangle((0,0), 0, 0, facecolor='white', edgecolor='None', alpha=0.8)
        self.detectorCanvas.ax.add_patch(self.rect)

        self.detectorCanvas.draw()
        self.detectorEvents()
	'''

        #for right  grid
        self.rightWidget = QtGui.QWidget(self)
        self.rightGrid   = QtGui.QGridLayout(self.rightWidget)

        self.loadButton = QtGui.QPushButton("Load",self.rightWidget)
        self.saveButton = QtGui.QPushButton("Save",self.rightWidget)

        self.maskListWidget = QtGui.QListWidget(self)        
        self.maskListWidget.setMinimumWidth(70)
        self.maskListWidget.setMaximumWidth(150)
        for i in range(100):
            _item = QtGui.QListWidgetItem(str(i), self.maskListWidget)
            _item.setFlags(QtCore.Qt.ItemIsUserCheckable)
            _r=random.random()
            if _r <0.22:
                _item.setCheckState(QtCore.Qt.Unchecked)
            else:
                 _item.setCheckState(QtCore.Qt.Checked)
            self.maskListWidget.addItem(_item)

        self.rightGrid.addWidget(self.loadButton,     0, 0, 1, 1 )
        self.rightGrid.addWidget(self.saveButton,     0, 1, 1, 1 )
        self.rightGrid.addWidget(self.maskListWidget, 1, 0, 1, 2 )

        self.horizontalLayout.addWidget(self.leftWidget )
        self.horizontalLayout.addWidget(self.detectorCanvas ) 
        self.horizontalLayout.addWidget(self.rightWidget )

    def detectorEvents(self):
        self.detectorCanvas.mpl_connect('button_press_event', self.selectRegionPress)
        self.detectorCanvas.mpl_connect('button_release_event', self.selectRegionRelease)

    def selectRegionPress(self,event):
        self.x0 = event.xdata
        self.y0 = event.ydata

    def selectRegionRelease(self, event):
        self.x1 = event.xdata
        self.y1 = event.ydata
        self.rect.set_width(float(self.x1 - self.x0))
        self.rect.set_height(float(self.y1 - self.y0))
        self.rect.set_xy((self.x0, self.y0))
        self.detectorCanvas.draw()
