#!/usr/bin/python
# -*- coding: utf-8 -*-

__all__ = ['viewer']

import os
from glob import glob

_modules = list(map(os.path.basename,
                glob(os.path.join(os.path.dirname(__file__), '*.py'))))
_modules.remove('__init__.py')
_modules = [mod[:-3] for mod in _modules]

viewer = {}

for mod in _modules:
    _module = __import__('viewer.' + mod, fromlist=[mod])
    if 'suite' in _module.__dict__:
        viewer[mod] = _module.suite
