'''
Created on 2015.6.4
@author: yll
'''
from conf.constants import *
from canvas import *
from model.readData import *
from model.readImage import *
from mpl_toolkits.mplot3d import Axes3D
#import ipyvolume.pylab
#import matplotlib.tri as mtri

class CSNSGisansPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSGisansPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
    	#self.setTabPosition(QTabWidget.West)
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        self.label = QtGui.QLabel("Neutron Image (qx, qy, qz)")
        self.gisansFigure = Figure((6,6), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=True)

        self.gisansFigure.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.gisansCanvas = FigureCanvas(self.gisansFigure)
        self.gisansCanvas.setParent(self)

        '''
        _xsize = 6
        _ysize = 3
        self.gisansCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            'Y/mm',
            )
        '''
        self.gisansnAxes = self.gisansFigure.add_subplot(111,projection='3d')
        X, Y, Z, C = CSNSReadImageSurface("./img/XY ++.png")
        
        #print X.shape,Y.shape,Z.shape,C.shape
        self.gisansnAxes.plot_surface(X, Y, Z, rstride=1, cstride=1, facecolors=cm.jet(C), linewidth=0, antialiased=False, shade=False)
        self.gisansnAxes.tick_params(axis='both', which='major', labelsize=5)
       
        #self.mainGrid.addWidget(self.channelComboBox, 0,0,1,1)
        _nline = 0
        self.mainGrid.addWidget(self.label,_nline,0,1,1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.gisansCanvas,_nline,0,1,1, QtCore.Qt.AlignCenter)

        self.verticalLayout.addWidget(self.scrollArea)

    def updateCanvas(self, value, started, _command):
        self.gisansnAxes.clear()
        C=[]
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                _x=[]
                _y=[]
                _z=[]
                _c=[]
                for i in range(len(value[0])): 
                    for j in range(len(value[1])): 
                        for k in range(len(value[2])):
                            _x.append(value[0][i]) 
                            _y.append(value[1][j]) 
                            _z.append(value[2][k])
                            _c.append(value[3][i][j][k])
 
                #(_x,_y,_z)=np.meshgrid(value[0],value[1],value[2])
                    #for i in range(len(value[3])):
                    #    C.append(value[3][i])
                    #(_x, _c)=np.meshgrid(value[0],C)
                    #(_y, _c)=np.meshgrid(value[1],C)
                    #(_z, _c)=np.meshgrid(value[2],C)
                #print _x.shape,_y.shape,_z.shape,np.array(value[3]).shape
                #self.gisansnAxes.plot_trisurf(value[0], value[1], value[2], triangles=value[3])#, marker='o')
                #self.gisansnAxes.scatter(value[0], value[1], value[2], value[3])#, marker='o')
                #self.gisansnAxes.scatter(_x, _y, _z, _c)#, marker='o')
                    #self.gisansnAxes.plot_surface(_x, _y, _z, rstride=1, cstride=1, facecolors=cm.jet(np.array(value[3])),linewidth=0, antialiased=False)
                    #self.canvas2Axes.axis('off')
                self.gisansCanvas.draw()
                #try:
                #except:
                #    pass 
