#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined
from canvas import *
from conf.constants import *
import time
import redis
from model import jsonArray

class CSNSReflectionPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSReflectionPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        
        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea3 = QtGui.QScrollArea()
        self.scrollArea3.setWidgetResizable(True)
        self.scrollArea3.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        #self.splitter.addWidget(self.scrollArea3)
        self.splitter.setSizes([300, 150])#, 150])

        #main Grid
        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)

        self.button = QtGui.QPushButton('Submit')
        self.button.setMaximumHeight(30)
        self.button.setMaximumWidth(70)
        self.button.clicked.connect(self.buttonClicked)

        _xsize = 16#6
        _ysize = 8#3
        self.canvas1 = figureCanvas(
            self,
            5,#_xsize,
            5,#_ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'x/mm',
            'y/mm',
            )
        #self.canvas1.x1 = self.canvas1.ax.axhline(0.5,color='white')
        #self.canvas1.y1 = self.canvas1.ax.axvline(0.5,color='white')
        self.rect = Rectangle((0,0), 0, 0, facecolor='None', edgecolor='red', alpha=0.8,zorder=5)
        self.canvas1.ax.add_patch(self.rect) 
        #self.rect.set_visible(True)

        self.roi=None

        self.canvas1.draw()

        self.zoomEvents()

        '''
        self.canvas2 = figure3DCanvas(
            self,
            2,#_xsize,
            2,#_ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X',
            'Y',
            )
        '''
        '''
        self.canvas2Fig = Figure((5,5), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=True)
        self.canvas2Fig.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.canvas2 = FigureCanvas(self.canvas2Fig)
        self.canvas2.setParent(self)
        self.canvas2Axes = self.canvas2Fig.add_subplot(111,projection='3d')
        self.canvas2Axes.tick_params(axis='both', which='major', labelsize=0.1)
        self.canvas2Axes.axis('off')
        self.canvas2Axes.set_xlabel('qx')
        self.canvas2Axes.set_ylabel('qy')
        '''
    
        self.canvas3 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Neutron Counts',
            )
        #self.rect = Rectangle((0,0), 0, 0, facecolor='red', edgecolor='black', alpha=0.8,zorder=2)
        #self.canvas3.ax.add_patch(self.rect) 
        #self.zoomEvents()


        self.canvas4 = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Scattering Intensity',
            )
        self.comboBoxUnit1 = QtGui.QComboBox()
        self.comboBoxUnit1.addItem('TOF')
        self.comboBoxUnit1.addItem('theta')
        self.comboBoxUnit1.addItem('Q')
        self.comboBoxUnit1.setMaximumWidth(150)
        self.comboBoxUnit1.activated.connect(self.parent.tabChange)
        self.comboBoxLog1 = QtGui.QComboBox()
        self.comboBoxLog1.addItem('linear')
        self.comboBoxLog1.addItem('logarithmic')
        self.comboBoxLog1.setMaximumWidth(150)
        self.comboBoxLog1.activated.connect(self.parent.tabChange)
       
        self.normLabel = QtGui.QLabel('Normalization by') 
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        self.comboBoxNorm.activated.connect(self.parent.tabChange)
        self.comboBoxUnit2 = QtGui.QComboBox()
        self.comboBoxUnit2.addItem('TOF')
        self.comboBoxUnit2.addItem('Q')
        self.comboBoxUnit2.setMaximumWidth(150)
        self.comboBoxUnit2.activated.connect(self.parent.tabChange)
        self.comboBoxLog2 = QtGui.QComboBox()
        self.comboBoxLog2.addItem('linear')
        self.comboBoxLog2.addItem('logarithmic')
        self.comboBoxLog2.setMaximumWidth(150)
        self.comboBoxLog2.activated.connect(self.parent.tabChange)

        _nline = 0
        self.firstGrid.addWidget(self.canvas1, _nline,1,7,1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.button, _nline,10,7,1, QtCore.Qt.AlignCenter)
        #self.firstGrid.addWidget(self.canvas2, _nline,2,7,1, QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.comboBoxUnit1, _nline,0,1,1)
        self.secondGrid.addWidget(self.comboBoxLog1, _nline,1,1,1)
        self.secondGrid.addWidget(self.normLabel, _nline,7,1,1)
        self.secondGrid.addWidget(self.comboBoxNorm, _nline,8,1,1)
        self.secondGrid.addWidget(self.comboBoxUnit2, _nline,9,1,1)
        self.secondGrid.addWidget(self.comboBoxLog2, _nline,10,1,1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas3, _nline,0, 1, 7)
        self.secondGrid.addWidget(self.canvas4, _nline,7, 1, 7)
        
        self.verticalLayout.addWidget(self.splitter)       
        
        self.zoomClick = False
        self.zoomSelected = False
        self.roiSelected = False
        self.value = None
        self.neonServer = None

        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0

    def buttonClicked(self):
        path = '/MR/workspace/MantidData/roi'
        if self.zoomSelected == True:
            self.roiSelected = True
        try:
            neonStatus, self.neonServer = self.parent.parent.parent.getNeon()
            if self.neonServer != None: 
                self.neonServer.set(path, [self.x1, self.y1, self.x2, self.y2])
        except:
            pass
        self.parent.tabChange()        

    def getRoiVar(self):
        return self.roiSelected

    def log1Selected(self):
        index = self.comboBoxLog1.currentIndex()
        #self.parent.tabChange()
        return index 

    def unit1Selected(self):
        index = self.comboBoxUnit1.currentIndex()
        #self.parent.tabChange()
        return index 

    def log2Selected(self):
        index = self.comboBoxLog2.currentIndex()
        #self.parent.tabChange()
        return index 

    def unit2Selected(self):
        index = self.comboBoxUnit2.currentIndex()
        #self.parent.tabChange()
        return index 
    
    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        #self.parent.tabChange()
        return index 

    def zoomEvents(self):
        self.canvas1.mpl_connect('button_press_event',   self.zoomFigurePress)
        self.canvas1.mpl_connect('button_release_event', self.zoomFigureRelease)
        self.canvas1.mpl_connect('motion_notify_event',  self.zoomFigureMove)

    def zoomFigurePress(self,event):
        if event.button==1:
            self.zoomClick=True
            self.zoomSelected = True
            self.x1 = event.xdata
            self.y1 = event.ydata
        elif event.button==3:
            self.canvas1.ax.autoscale(enable=True)
            self.canvas1.draw()
            self.zoomSelected = False
            self.roiSelected = False
            self.parent.tabChange()
        else:
            return

    def zoomFigureMove(self, event):
        if event.button==1 and self.zoomClick==True and self.x1 and self.y1 and event.xdata and event.ydata:

            self.rect.set_x(self.x1)
            self.rect.set_y(self.y1)
            self.rect.set_width(event.xdata - self.x1)
            self.rect.set_height(event.ydata - self.y1)
            #self.rect.set_xy((self.x0, self.y0))
            self.canvas1.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick=False

        if event.button==1 and self.x1 and self.y1 and event.xdata and event.ydata:
            self.x2 = event.xdata
            self.y2 = event.ydata

            #self.rect.set_width(0)
            #self.rect.set_height(0)

            self.minX=min(self.x1,self.x2)
            self.maxX=max(self.x1,self.x2)
            if self.minX != self.maxX:
                self.canvas1.ax.set_xlim(self.minX, self.maxX)
            self.minY=min(self.y1,self.y2)
            self.maxY=max(self.y1,self.y2)
            if self.minY != self.maxY:
                self.canvas1.ax.set_ylim(self.minY, self.maxY)
            self.canvas1.draw()
        else:
            return

    def getNeon(self):
        neonStatus, self.neonServer = self.parent.parent.parent.getNeon()

    def updateCanvas(self, value, started, _command):
        #self.canvas2Axes.clear()
        self.canvas3.ax.clear()
        self.canvas4.ax.clear()
        self.value = value
        if _command in ('configure', 'stop', 'abort'):
            self.canvas1.ax.clear()
            self.roi = None
        else:
            if not started:
                pass
            else:
                try:
                    if self.roi == None:
                        self.roi=self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap='hot', zorder=1)
                    else:
                        self.roi.set_array(z.ravel())
                    #self.canvas1.ax.axis('equal', adjustable='box')
                    if self.roiSelected and (self.minX != self.maxX) and (self.minY != self.maxY):
                        self.canvas1.ax.set_xlim(self.minX, self.maxX)
                        self.canvas1.ax.set_ylim(self.minY, self.maxY)
                        
                except:
                    pass
                try:
                    index = self.comboBoxLog1.currentIndex()
                    self.canvas3.ax.plot(value[3], value[4], color='b')
                    if index == 0:
                        self.canvas3.ax.set_yscale('linear')
                    else:
                        self.canvas3.ax.set_yscale('log')
                except:
                    pass
                try:
                    index = self.comboBoxLog2.currentIndex()
                    self.canvas4.ax.plot(value[5], value[6], color='g')
                    if index == 0:
                        self.canvas4.ax.set_yscale('linear')
                    else:
                        self.canvas4.ax.set_yscale('log')
                except:
                    pass
                #self.canvas1.ax.relim()
                #self.canvas1.ax.autoscale_view(True, True, True)
            self.canvas1.draw()
            self.canvas3.draw()
            self.canvas4.draw()

    def rectSelected(self, neonServer, x1, y1, x2, y2):
        print 333
        pidPath="/MR/workspace/MantidData/mapping/pid"
        xyPath="/MR/workspace/MantidData/mapping/xy"
        thetaPath="/MR/workspace/MantidData/mapping/twoTheta"
        _wPid=neonServer.get(pidPath)
        _xyPid=neonServer.get(xyPath)
        _twoTheta=neonServer.get(thetaPath)
        wPid=jsonArray.jsonDecoder(_wPid)
        xyPid=jsonArray.jsonDecoder(_xyPid)
        twoTheta=jsonArray.jsonDecoder(_twoTheta)
        mapPid = []
        index = []
        self.tofRaw = []
        self.tofCountsRaw = []
        self.tofRed = []
        self.tofCountsRed = []
        for i in range(len(wPid)):
            if xyPid[i][0]>=x1 and xyPid[i][0]<=x2 and xyPid[i][1]>=y2 and xyPid[i][1] <=y1:
                mapPid.append((xyPid[i][0],xyPid[i][1]))
                index.append(i)
            else:
                continue
        pidNum=len(index)
        _index1 = self.comboBoxUnit1.currentIndex()
        _index2 = self.comboBoxUnit2.currentIndex()
        if _index1 == 0:
            self.tofRaw, self.tofCountsRaw=self.setItofData(neonServer, "/MR/workspace/MantidData/tmp/raw/Itof", index)
            time.sleep(3)
        elif _index1 == 1:
            self.thetaRaw, self.thetaCountsRaw=self.setIthetaData(neonServer,"/MR/workspace/MantidData/tmp/raw/Itof/value", index, twoTheta)
        elif _index1 == 2:
            self.qRaw, self.qValueRaw=setIQData(neonRedis, "/MR/workspace/MantidData/tmp/Iwave/raw", index, twoTheta)
        if _index2 == 0:
            self.tofRed, self.tofCountsRed=self.setItofData(neonServer, "/MR/workspace/MantidData/tmp/reduction/monitor/Itof", index)
        elif _index2 == 1:
            self.qRed, self.qValueRed=self.setIQData(neonServer, "/MR/workspace/MantidData/tmp/reduction/monitor/Iwave", index, twoTheta)

    def setIthetaData(self, neonServer,path,index, twoTheta):
        print 999
        _j22=neonServer.get(path)
        res=jsonArray.jsonDecoder(_j22)
        
        counts=[]
        scaAngle=[]
        for i in range(50):
            scaAngle.append(8+0.1*i)
            counts.append(0)
        for num in index:
            n2=sum(res[num])
            for i in range(len(scaAngle)-1):
                if twoTheta[num]>=scaAngle[i] and twoTheta[num]<scaAngle[i+1]:
                    counts[i]=counts[i]+n2
                else:
                    continue
        print 10
        return scaAngle, counts

    def setIQData(self, neonServer, path, index, twoTheta):
        print 777
        p1=path+"/wave"
        p2=path+"/value"
        _j11=neonServer.get(p1)
        _j22=neonServer.get(p2)
        wave=jsonArray.jsonDecoder(_j11)
        res=jsonArray.jsonDecoder(_j22)
        pidNum=len(index)
        value=[[] for i in range(pidNum)]
        num=0
        for i in index:
            value[num]=res[i]
            num=num+1
        qvalue=[[] for i in range(pidNum)]
        num=0
        for i in index:
            for j in range(len(wave)):
                tmpQ=4*math.pi/wave[j]*math.sin(math.pi/180*(twoTheta[i]/2))
                qvalue[num].append(tmpQ)
            num=num+1
        qNew=[]
        for num in range(100):
            qNew.append(0.10+num*0.05)
        vNew=np.zeros(len(wave))
        for i in range(pidNum):
            for j in range(len(wave)):
                for k in range(99):
                    if qvalue[i][j]>=qNew[k] and qvalue[i][j]<qNew[k+1]:
                        vNew[k]=vNew[k]+value[i][j]
        print 888
        return qNew, vNew

    def setItofData(self, neonServer, path, index):
        print 555
        pp1=path+"/tof"
        pp2=path+"/value"
        _j11=neonServer.get(pp1)
        _j22=neonServer.get(pp2)
        tof=jsonArray.jsonDecoder(_j11)
        res=jsonArray.jsonDecoder(_j22)
        
        tofNum=len(tof)
        pidNum=len(index)
        #extract the roi
        value=[[] for i in range(pidNum)]
        num=0
        for i in index:
            value[num]=res[i]
            num=num+1
        # I-tof raw
        counts=[]
        for i in range(tofNum):
            tmp=0
            for j in range(pidNum):    
                tmp=tmp+value[j][i]
            counts.append(tmp)
        print 666
        return tof,counts    

