'''
Created on 2015.6.4

DotQ
'''

from conf.constants import *
from canvas import *
from model.readData import *
from model.readImage import *

class CSNSReflectivityPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSReflectivityPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QTabWidget):
    	self.setTabPosition(QTabWidget.West)

	self.horizontalLayout = QtGui.QHBoxLayout(self)

	self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaLeft = QtGui.QScrollArea()
        self.scrollAreaLeft.setWidgetResizable(True)
        self.scrollAreaLeft.setWidget(self.first)

        self.horizontalLayout.addWidget(self.scrollAreaLeft)

        #main  grid
        self.mainGridWidget = QtGui.QWidget(self.first)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        #++/--/+-/-+
        self.channelComboBox = QtGui.QComboBox()
        self.channelComboBox.addItem("++")
        self.channelComboBox.addItem("+-")
        self.channelComboBox.addItem("-+")
        self.channelComboBox.addItem("--")
        self.filexy=["img/XY ++.png", "img/XY +-.png", "img/XY -+.png", "img/XY --.png"]
        self.filext=["img/XT ++.png", "img/XT +-.png", "img/XT -+.png", "img/XT --.png"]
        self.fileyt=["img/XT ++.png", "img/XT +-.png", "img/XT -+.png", "img/XT --.png"]
        _index=self.channelComboBox.currentIndex()
	
	self.channelComboBox.currentIndexChanged.connect(self.selectCombo)

        self.gisansFigure = Figure((6,3), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=False)

        self.gisansFigure.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.gisansCanvas = FigureCanvas(self.gisansFigure)
        self.gisansCanvas.setParent(self)

        self.slitImageAxes = self.gisansFigure.add_subplot(121,projection='3d')
        dataX, dataY, dataZ = CSNSRead3DData("./dat/3d1.dat")
        self.slitImageAxes.plot_surface(dataX, dataY, dataZ,rstride=8, cstride=8, alpha=0.3, cmap=cm.PiYG)
        cset = self.slitImageAxes.contourf(dataX, dataY, dataZ, zdir='z', offset=0, cmap=cm.coolwarm)
        cset = self.slitImageAxes.contourf(dataX, dataY, dataZ, zdir='x', offset=50, cmap=cm.Blues)
        cset = self.slitImageAxes.contourf(dataX, dataY, dataZ, zdir='y',offset=100, cmap=cm.Greens)
        self.slitImageAxes.tick_params(axis='both', which='major', labelsize=5)
        
        self.gisansnAxes = self.gisansFigure.add_subplot(122,projection='3d')
        X, Y, Z, C = CSNSReadImageSurface("./img/XY ++.png")
        self.gisansnAxes.plot_surface(X, Y, Z, rstride=1, cstride=1, facecolors=cm.jet(C), linewidth=0, antialiased=False, shade=False)
        self.gisansnAxes.tick_params(axis='both', which='major', labelsize=5)
        
        self.mainGrid.addWidget(self.channelComboBox, 0,0,1,1)
        self.mainGrid.addWidget(self.gisansCanvas,    1,0,1,2)

    def selectCombo(self, event):
        _index=self.channelComboBox.currentIndex()
        self.dataxyX, self.dataxyY, self.dataxyZ = CSNSReadImage2Matrix(self.filexy[_index], 1, 1)

        self.dataxtX, self.dataxtY, self.dataxtZ = CSNSReadImage2Matrix(self.filext[_index], 1, 0.4)

        self.dataytX=self.dataxtY
        self.dataytY=self.dataxtX
        self.dataytZ=self.dataxtZ
        #self.dataytX, self.dataytY, self.dataytZ = CSNSReadImage(self.fileyt[_index])

        self.XYImage.set_array(self.dataxyZ.ravel())
        self.XTImage.set_array(self.dataxtZ.ravel())
        self.YTImage.set_array(self.dataytZ.ravel())

        self.XYImageCanvas.draw()
        self.XTImageCanvas.draw()
        self.YTImageCanvas.draw()

