'''
Created on 2017.01.19

X-Y Image
'''

from conf.constants import *
from canvas import *
from model.readData import *
from model.readImage import *

class CSNSImagePage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSImagePage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QTabWidget):
        self.setTabPosition(QTabWidget.West)
	
	self.horizontalLayout = QtGui.QHBoxLayout(self)

	self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaLeft = QtGui.QScrollArea()
        self.scrollAreaLeft.setWidgetResizable(True)
        self.scrollAreaLeft.setWidget(self.first)

	self.horizontalLayout.addWidget(self.scrollAreaLeft)

        #main  grid
        self.mainGridWidget = QtGui.QWidget(self.first)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        #++/--/+-/-+
        self.channelComboBox = QtGui.QComboBox()
        self.channelComboBox.addItem("++")
        self.channelComboBox.addItem("+-")
        self.channelComboBox.addItem("-+")
        self.channelComboBox.addItem("--")
        self.filexy=["img/XY ++.png", "img/XY +-.png", "img/XY -+.png", "img/XY --.png"]
        self.filext=["img/XT ++.png", "img/XT +-.png", "img/XT -+.png", "img/XT --.png"]
        self.fileyt=["img/XT ++.png", "img/XT +-.png", "img/XT -+.png", "img/XT --.png"]
        _index=self.channelComboBox.currentIndex()

        self.chargeLabel = QtGui.QLabel("Proton Charge: ")
        self.chargeText = QtGui.QLabel("1.3E6 ")

        self.countsLabel = QtGui.QLabel("Neutron Counts: ")
        self.countsText = QtGui.QLabel("5.2E10 ")

        _xsize=3
        _ysize=1.7
        #X-Y
        self.XYLabel = QtGui.QLabel("X-Y")

        self.XYImageCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataxyX, self.dataxyY, self.dataxyZ = CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.XYImage = self.XYImageCanvas.ax.pcolormesh(self.dataxyY, self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle((0,0), 0, 0, facecolor='None', edgecolor='black', alpha=0.8,zorder=2)
        self.XYImageCanvas.ax.add_patch(self.rect)
        self.XYImageCanvas.draw()

       # monitor
        self.monitorLabel = QtGui.QLabel("Monitor")

        self.monitorCanvas = CSNSCanvas(self, _xsize, _ysize)

        nx, dataX = CSNSRead2DData("./dat/monitor.dat")
        self.monitorCanvas.ax.plot(dataX[0],dataX[1],color='red')
        self.monitorCanvas.ax.tick_params(axis='both', which='major', labelsize=5)
        self.monitorCanvas.draw()
        '''
        # X-T
        '''
        # X-T 2d
        self.XTLabel = QtGui.QLabel("X-T")

        self.XTImageCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataxtX, self.dataxtY, self.dataxtZ = CSNSReadImage2Matrix(self.filext[_index], 1, 0.4)
        self.XTImage = self.XTImageCanvas.ax.pcolormesh(self.dataxtY, self.dataxtX, self.dataxtZ, cmap=cm.hot)
        self.XTImageCanvas.draw()

        # X-T 1d
        self.reflectivityXTLabel = QtGui.QLabel("Reflectivity ")

        self.reflectivityXTCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataXTx=[]
        for i in range(1,self.dataxtY.shape[0]):
            self.dataXTx.append(self.dataxtY[0][i])
        self.dataXTy=[]
        for i in range(1,self.dataxtX.shape[0]):
            self.dataXTy.append(self.dataxtX[i][0])

        self.reflectivityXTFigure=self.reflectivityXTCanvas.ax.plot(self.dataXTx,self.dataxtZ[40][:],color='red')
        self.reflectivityXTCanvas.draw()

        self.parameterWidget= QtGui.QWidget(self)
        self.parameterGrid = QtGui.QGridLayout(self.parameterWidget)
        self.parameterGrid.addWidget(self.channelComboBox,0,0,1,1)
        self.parameterGrid.addWidget(self.chargeLabel,    0,1,1,1)
        self.parameterGrid.addWidget(self.chargeText,     0,2,1,1)
        self.parameterGrid.addWidget(self.countsLabel,    0,3,1,1)
        self.parameterGrid.addWidget(self.countsText,     0,4,1,1)

        self.mainGrid.addWidget(self.parameterWidget, 0,0,1,2)
        self.mainGrid.addWidget(self.XYLabel,         1,0,1,1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.XYImageCanvas,   2,0,1,1)
        self.mainGrid.addWidget(self.XTLabel,         1,1,1,1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.XTImageCanvas,   2,1,1,1)
        self.mainGrid.addWidget(self.monitorLabel,    3,0,1,1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.monitorCanvas,   4,0,1,1)
        self.mainGrid.addWidget(self.reflectivityXTLabel,  3,1,1,1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.reflectivityXTCanvas, 4,1,1,1)

        self.analysisSignal()

    def analysisSignal(self):
        self.channelComboBox.currentIndexChanged.connect(self.selectCombo)
        self.XTImageCanvas.mpl_connect('button_press_event',  self.changeReflectivityXT)
        self.XYImageCanvas.mpl_connect('button_press_event',   self.zoomFigurePress)
        self.XYImageCanvas.mpl_connect('button_release_event', self.zoomFigureRelease)
        self.XYImageCanvas.mpl_connect('motion_notify_event',  self.zoomFigureMove)

    def changeReflectivityXT(self,event):
        if event.button==1:
            _y0 = event.ydata

            _iy=min(self.dataXTy, key=lambda x:abs(x-_y0))
            _iy=self.dataXTy.index(_iy)+2
            if _iy <0 or _iy>len(self.dataXTy):
                pass
            else:
                self.reflectivityXTFigure[0].set_ydata(self.dataxtZ[_iy][:])
                self.reflectivityXTCanvas.ax.set_ylim( (min(self.dataxtZ[_iy][:]), max(self.dataxtZ[_iy][:])) )

                self.reflectivityXTCanvas.draw()
        else:
            return

    def selectCombo(self, event):
        _index=self.channelComboBox.currentIndex()
        self.dataxyX, self.dataxyY, self.dataxyZ = CSNSReadImage2Matrix(self.filexy[_index], 1, 1)

        self.dataxtX, self.dataxtY, self.dataxtZ = CSNSReadImage2Matrix(self.filext[_index], 1, 0.4)

        self.dataytX=self.dataxtY
        self.dataytY=self.dataxtX
        self.dataytZ=self.dataxtZ
        #self.dataytX, self.dataytY, self.dataytZ = CSNSReadImage(self.fileyt[_index])

        self.XYImage.set_array(self.dataxyZ.ravel())
        self.XTImage.set_array(self.dataxtZ.ravel())
        self.YTImage.set_array(self.dataytZ.ravel())

        self.XYImageCanvas.draw()
        self.XTImageCanvas.draw()
        self.YTImageCanvas.draw()

    def zoomFigurePress(self,event):
        if event.button==1:
            self.zoomClick=True
            self.x0 = event.xdata
            self.y0 = event.ydata
        elif event.button==3:
            self.XYImageCanvas.ax.autoscale(enable=True)
            self.XYImageCanvas.draw()
        else:
            return

    def zoomFigureMove(self, event):
        if event.button==1 and self.zoomClick==True and self.x0 and self.y0 and event.xdata and event.ydata:

            self.rect.set_width(event.xdata - self.x0)
            self.rect.set_height(event.ydata - self.y0)
            self.rect.set_xy((self.x0, self.y0))
            self.XYImageCanvas.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick=False

        if event.button==1 and self.x0 and self.y0 and event.xdata and event.ydata:
            self.x1 = event.xdata
            self.y1 = event.ydata

            self.rect.set_width(0)
            self.rect.set_height(0)

            _min=min(self.x0,self.x1)
            _max=max(self.x0,self.x1)
            self.XYImageCanvas.ax.set_xlim(_min, _max)
            _min=min(self.y0,self.y1)
            _max=max(self.y0,self.y1)
            self.XYImageCanvas.ax.set_ylim(_min, _max)
            self.XYImageCanvas.draw()
        else:
            return
