'''
Created on 2015.6.4
@author: yll

DotQ

'''
from conf.constants import *
from canvas import *

class CSNSScanPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSScanPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
    	#self.setTabPosition(QTabWidget.West)
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        self.label1 = QtGui.QLabel("Scan")
        self.label1.setMaximumHeight(30)
        self.label1.setMaximumWidth(150)
 
        self.label2 = QtGui.QLabel("x = ")
        self.label2.setMaximumHeight(30)
        self.label2.setMaximumWidth(70)
        self.button = QtGui.QPushButton('Submit')
        self.button.setMaximumHeight(30)
        self.button.setMaximumWidth(70)

        _xsize = 6
        _ysize = 3
        self.canvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            'Y/mm',
            )
       
        #self.mainGrid.addWidget(self.channelComboBox, 0,0,1,1)
        _nline = 0
        self.mainGrid.addWidget(self.label1,_nline, 2, 1, 1)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.canvas,_nline,0,4,5)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.label2,_nline,6,1,1)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.button,_nline,6,1,1)#, QtCore.Qt.AlignCenter)

        self.verticalLayout.addWidget(self.scrollArea)

    def updateCanvas(self, value, started, _command):
        self.canvas.ax.clear()
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                try:
                    self.canvas.ax.plot(value[0],value[1],'+')
                    #self.canvas1.ax.plot(value[0], value[1], '+', value[0], value[1], 'k')
                    #self.canvas1.ax.plot(value[0], value[1], 'bo', value[0], value[1], 'k')
                except:
                    pass
        self.canvas.draw()

