#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Monitor

'''
import numpy as np
from PyQt4 import QtCore, QtGui
import monitorDock

class CSNSMonitorPage(QtGui.QMainWindow):  # QTabWidget):

    def __init__(self, parent):
        super(CSNSMonitorPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        self.monitorDock = []
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK01/PATTERN',
            '/BL01/BANK01/IMAGE',
            9,
            0.8,
            'y',
            'Accent',
            'Incident Monitor 1',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK03/PATTERN',
            '/BL01/BANK03/IMAGE',
            9,
            0.8,
            'c',
            'Spectral',
            'Incident Monitor 2',
            ))
        '''
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK05/PATTERN',
            '/BL01/BANK05/IMAGE',
            9,
            0.8,
            'm',
            'cool',
            'Transmit Monitor',
            ))
        '''
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[0])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[1])
        #self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
        #                   self.monitorDock[2])
        
    def setStatus(self):
        return self.parent.setStatus()

    def updateCanvas(self, value, started, _command):
        i = 0
        j = 0
        for i in range(len(self.monitorDock)):
            can3D = self.monitorDock[i].imageCanvas
            can2D = self.monitorDock[i].patternCanvas
            can3D.ax.clear()
            can2D.ax.clear()
            if _command in ('configure', 'stop', 'abort'):
                pass
            else:
                if not started:
                    pass
                else:
                    _pause = self.monitorDock[i].pauseButton.text()
                    if _pause == 'Pause':
                        try:
                            can3D.ax.pcolormesh(value[0][i], value[1][i], value[2][i], cmap=can3D.plotColor)
                        except:
                            pass
                        try:
                            can2D.ax.plot(value[3][i], value[4][i], color=can2D.plotColor)
                            can2D.ax.relim()
                            can2D.ax.autoscale_view()
                        except:
                            pass
            can3D.draw()
            can2D.draw()    
