'''
Created on 2015.6.4
@author: yll
'''
from conf.constants import *
from canvas import *
from scipy import exp
from scipy.optimize import leastsq
#from scipy.optimize import curve_fit
from model import jsonArray

class CSNSScanPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSScanPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self,Widget):
    	#self.setTabPosition(QTabWidget.West)
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        self.label1 = QtGui.QLabel("Scan")
        self.label1.setMaximumHeight(30)
        self.label1.setMaximumWidth(150)
 
        self.label2 = QtGui.QLabel("x = ")
        self.label2.setMaximumHeight(30)
        self.label2.setMaximumWidth(70)
        self.button = QtGui.QPushButton('Submit')
        self.button.setMaximumHeight(30)
        self.button.setMaximumWidth(70)
        self.button.clicked.connect(self.buttonClicked)

        _xsize = 12
        _ysize = 6
        self.canvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            'Y/mm',
            )
       
        #self.mainGrid.addWidget(self.channelComboBox, 0,0,1,1)
        _nline = 0
        self.mainGrid.addWidget(self.label1,_nline, 2, 1, 1)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.canvas,_nline,0,4,5)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.label2,_nline,6,1,1)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.button,_nline,6,1,1)#, QtCore.Qt.AlignCenter)

        self.verticalLayout.addWidget(self.scrollArea)

        self.neonServer = None
        self.scanCmd = None
        self.bestPosition = 0 

    def buttonClicked(self):
        path = '/MR/workspace/BestPosition'
        try:
            if self.neonServer == None:
                neonStatus, self.neonServer = self.parent.parent.parent.getNeon()
            else:
                _coord_json = jsonArray.jsonEncoder(self.bestPosition)
                self.neonServer.set(path, _coord_json)
                #self.neonServer.publish(path, _coord_json)
        except:
            pass

    def updateCanvas(self, value, started, _command):
        self.canvas.ax.clear()
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                scanVar = [1,1,1,1,0]#value[0]
                x = value[1]
                y = value[2]
                try:
                    self.canvas.ax.plot(x,y,'+')
                    #self.canvas1.ax.plot(value[0], value[1], 'bo', value[0], value[1], 'k')
                except:
                    pass
                try:
                    if (0 not in scanVar):
                        xlist = x
                        ylist = y
                        #xlist = [1,2,3,4,5]#value[0]
                        #ylist = [1,2,3,4,5]#value[1]
                        p=[0, 0, 0]
                        p[0]=xlist[ylist.index(max(ylist))]
                        p[1]=(max(xlist)-min(xlist))*0.5
                        p[2] = max(ylist)

                        _xarray=np.array(xlist)
                        _yarray=np.array(ylist)
                        p1, conv, info, mesg,  success = leastsq(self.gaussianErr, p, args=(_xarray, _yarray), full_output=True)

                        if success:
                            self.bestPosition=p1[0]
                            self.label2.setText('x = ' + str(self.bestPosition))
                            BestCount=p[2]
                            _xnew = np.linspace(min(xlist), max(xlist), 30)           
                            _ynew = self.gaussianFit(p1,_xnew)

                            _x=[self.bestPosition, self.bestPosition]
                            _y=[min(_ynew), max(_ynew)]
                            #_y=[0,BestCount]
                            
                            self.canvas.ax.plot(_x,_y,'r')
                            plt.pause(0.01)

                            #self.canvas.ax.plot(value[0],value[1],'+',_xnew, self.gaussianFit(p1,_xnew),'k')
                            self.canvas.ax.plot(_xnew, _ynew,'g')
                            plt.pause(0.01)
                        else:
                            _x = [x[y.index(max(y))], x[y.index(max(y))]]
                            _y = [0, max(y)]
                            self.canvas.ax.plot(_x,_y,'g')
                    else:
                        pass
                except:
                    pass
        self.canvas.draw()

    def gaussianFit(self, p, x):
        return p[2]*exp(-(x-p[0])**2.0/(2*p[1]**2))
    
    def gaussianErr(self, p, x, y):
        return y- (p[2]*exp(-(x-p[0])**2.0/(2*p[1]**2)))
