#!/usr/bin/python
# -*- coding: utf-8 -*-

# for pyqt4

from conf.constants import *
from tvtk.pyface.api import Scene

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

import matplotlib
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure


class figureCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        plotColor='',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'

        # self.ax.hold(True)

        # self.ax.patch.set_alpha(0)

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()

        self.scale_factor = 1.0

        self.zoomEvents()

    def zoomEvents(self):
        self.mpl_connect('button_press_event', self.zoomFigurePress)
        self.mpl_connect('scroll_event', self.onZoom)

    def zoomFigurePress(self, event):
        if event.button == 1 and event.xdata and event.ydata:
            self.scale_factor = 1.0
            self.x1 = event.xdata
            self.y1 = event.ydata

            self.draw()
        elif event.button == 3:
            self.scale_factor = 1.0
            self.draw()
        else:
            return

    def onZoom(self,event):
        try:
            cur_xlim = self.ax.get_xlim()
            cur_ylim = self.ax.get_ylim()

            self.xdata = event.xdata # get event x location
            self.ydata = event.ydata # get event y location

            if event.button == 'down':
                self.zoomSelected = False
                # deal with zoom in
                self.scale_factor = 1.2
                #scale_factor = 1 / base_scale
            elif event.button == 'up':
                self.zoomSelected = False
                # deal with zoom out
                self.scale_factor = 0.8
                #scale_factor = base_scale
            elif event.button == 3:
                self.scale_factor = 1.0
                self.ax.autoscale(enable=True)
                self.zoomSelected = False
                self.rect.set_width(0)
                self.rect.set_height(0)
            else:
                # deal with something that should never happen
                self.zoomSelected = False
                self.scale_factor = 1.0
                #print event.button

            self.new_width = (cur_xlim[1] - cur_xlim[0]) * self.scale_factor
            self.new_height = (cur_ylim[1] - cur_ylim[0]) * self.scale_factor

            self.relx = (cur_xlim[1] - self.xdata)/(cur_xlim[1] - cur_xlim[0])
            self.rely = (cur_ylim[1] - self.ydata)/(cur_ylim[1] - cur_ylim[0])

            self.ax.set_xlim([self.xdata - self.new_width * (1-self.relx), self.xdata + self.new_width * (self.relx)])
            self.ax.set_ylim([self.ydata - self.new_height * (1-self.rely), self.ydata + self.new_height * (self.rely)])
            self.draw()
        except:
            pass

class zoomCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        plotColor='',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=5,
            )
        self.ax.add_patch(self.rect)

        self.draw()

        self.zoomClick = False
        self.zoomSelected = False
        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0
        self.xdata = 0
        self.ydata = 0
        self.scale_factor = 1
        self.new_width = 0
        self.new_height = 0
        self.relx = 0
        self.rely = 0

        self.zoomEvents()

    def zoomEvents(self):
        self.mpl_connect('button_press_event', self.zoomFigurePress)
        self.mpl_connect('button_release_event', self.zoomFigureRelease)
        self.mpl_connect('motion_notify_event', self.zoomFigureMove)
        self.mpl_connect('scroll_event', self.onZoom)

    def zoomFigurePress(self, event):
        if event.button == 1:
            self.scale_factor = 1.0
            self.zoomClick = True
            self.zoomSelected = True
            self.x1 = event.xdata
            self.y1 = event.ydata
        elif event.button == 3:
            self.scale_factor = 1.0
            self.ax.autoscale(enable=True)
            self.draw()
            self.zoomSelected = False
            #self.roiSelected = False
            self.rect.set_width(0)
            self.rect.set_height(0)
        else:
            return

    def zoomFigureMove(self, event):
        if event.button == 1 and self.zoomClick == True and self.x1 \
            and self.y1 and event.xdata and event.ydata:

            self.rect.set_x(self.x1)
            self.rect.set_y(self.y1)
            self.rect.set_width(event.xdata - self.x1)
            self.rect.set_height(event.ydata - self.y1)

            # self.rect.set_xy((self.x0, self.y0))

            self.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick = False

        if event.button == 1 and self.x1 and self.y1 and event.xdata \
            and event.ydata:
            self.x2 = event.xdata
            self.y2 = event.ydata

            # self.rect.set_width(0)
            # self.rect.set_height(0)

            self.minX = min(self.x1, self.x2)
            self.maxX = max(self.x1, self.x2)
            if self.minX != self.maxX:
                self.ax.set_xlim(self.minX, self.maxX)
            self.minY = min(self.y1, self.y2)
            self.maxY = max(self.y1, self.y2)
            if self.minY != self.maxY:
                self.ax.set_ylim(self.minY, self.maxY)
            self.draw()
        else:
            return

    def onZoom(self,event):
        try:
            cur_xlim = self.ax.get_xlim()
            cur_ylim = self.ax.get_ylim()

            self.xdata = event.xdata # get event x location
            self.ydata = event.ydata # get event y location

            if event.button == 'down':
                self.zoomSelected = False
                # deal with zoom in
                self.scale_factor = 1.2
                #scale_factor = 1 / base_scale
            elif event.button == 'up':
                self.zoomSelected = False
                # deal with zoom out
                self.scale_factor = 0.8
                #scale_factor = base_scale
            elif event.button == 3:
                self.scale_factor = 1.0
                self.ax.autoscale(enable=True)
                self.zoomSelected = False
                self.rect.set_width(0)
                self.rect.set_height(0)
            else:
                # deal with something that should never happen
                self.zoomSelected = False
                self.scale_factor = 1.0
                #print event.button

            self.new_width = (cur_xlim[1] - cur_xlim[0]) * self.scale_factor
            self.new_height = (cur_ylim[1] - cur_ylim[0]) * self.scale_factor

            self.relx = (cur_xlim[1] - self.xdata)/(cur_xlim[1] - cur_xlim[0])
            self.rely = (cur_ylim[1] - self.ydata)/(cur_ylim[1] - cur_ylim[0])

            self.ax.set_xlim([self.xdata - self.new_width * (1-self.relx), self.xdata + self.new_width * (self.relx)])
            self.ax.set_ylim([self.ydata - self.new_height * (1-self.rely), self.ydata + self.new_height * (self.rely)])
            self.draw()
        except:
            pass

class refCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        plotColor='',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.parent=parent

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=5,
            )
        self.ax.add_patch(self.rect)

        self.draw()

        self.zoomClick = False
        self.zoomSelected = False
        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0
        self.xdata = 0
        self.ydata = 0
        self.scale_factor = 1
        self.new_width = 0
        self.new_height = 0
        self.relx = 0
        self.rely = 0

        self.zoomEvents()

    def zoomEvents(self):
        self.mpl_connect('button_press_event', self.zoomFigurePress)
        self.mpl_connect('button_release_event', self.zoomFigureRelease)
        self.mpl_connect('motion_notify_event', self.zoomFigureMove)
        self.mpl_connect('scroll_event', self.onZoom)

    def zoomFigurePress(self, event):
        if event.button == 1:
            self.scale_factor = 1.0
            self.zoomClick = True
            self.zoomSelected = True
            self.x1 = event.xdata
            self.y1 = event.ydata
        elif event.button == 3:
            self.scale_factor = 1.0
            self.ax.autoscale(enable=True)
            self.draw()
            self.zoomSelected = False
            self.roiSelected = False
        else:
            return

    def zoomFigureMove(self, event):
        if event.button == 1 and self.zoomClick == True and self.x1 \
            and self.y1 and event.xdata and event.ydata:

            self.rect.set_x(self.x1)
            self.rect.set_y(self.y1)
            self.rect.set_width(event.xdata - self.x1)
            self.rect.set_height(event.ydata - self.y1)
            # self.rect.set_xy((self.x0, self.y0))
            self.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick = False

        if event.button == 1 and self.x1 and self.y1 and event.xdata \
            and event.ydata:
            self.x2 = event.xdata
            self.y2 = event.ydata

            # self.rect.set_width(0)
            # self.rect.set_height(0)

            self.minX = min(self.x1, self.x2)
            self.maxX = max(self.x1, self.x2)
            #if self.minX != self.maxX:
            #    self.ax.set_xlim(self.minX, self.maxX)
            self.minY = min(self.y1, self.y2)
            self.maxY = max(self.y1, self.y2)
            #if self.minY != self.maxY:
            #    self.ax.set_ylim(self.minY, self.maxY)
            #self.draw()
            self.setPos(self.x1, self.y1, self.x2, self.y2)
        else:
            return

    def onZoom(self,event):
        try:
            cur_xlim = self.ax.get_xlim()
            cur_ylim = self.ax.get_ylim()

            self.xdata = event.xdata # get event x location
            self.ydata = event.ydata # get event y location

            if event.button == 'down':
                self.zoomSelected = False
                # deal with zoom in
                self.scale_factor = 1.2
                #scale_factor = 1 / base_scale
            elif event.button == 'up':
                self.zoomSelected = False
                # deal with zoom out
                self.scale_factor = 0.8
                #scale_factor = base_scale
            elif event.button == 3:
                self.scale_factor = 1.0
                self.ax.autoscale(enable=True)
                self.zoomSelected = False
                self.rect.set_width(0)
                self.rect.set_height(0)
            else:
                # deal with something that should never happen
                self.zoomSelected = False
                self.scale_factor = 1.0
                #print event.button

            self.new_width = (cur_xlim[1] - cur_xlim[0]) * self.scale_factor
            self.new_height = (cur_ylim[1] - cur_ylim[0]) * self.scale_factor

            self.relx = (cur_xlim[1] - self.xdata)/(cur_xlim[1] - cur_xlim[0])
            self.rely = (cur_ylim[1] - self.ydata)/(cur_ylim[1] - cur_ylim[0])

            self.ax.set_xlim([self.xdata - self.new_width * (1-self.relx), self.xdata + self.new_width * (self.relx)])
            self.ax.set_ylim([self.ydata - self.new_height * (1-self.rely), self.ydata + self.new_height * (self.rely)])
            self.draw()
        except:
            pass

    def setPos(self, x1, y1, x2, y2):
        self.parent.setPos(x1, y1, x2, y2)

    def setRect(self, pos):
        self.x1 = pos[0]
        self.y1 = pos[1]
        self.x2 = pos[2]
        self.y2 = pos[3]
        self.rect.set_x(self.x1)
        self.rect.set_y(self.y1)
        self.rect.set_width(self.x2 - self.x1)
        self.rect.set_height(self.y2 - self.y1)
        self.draw()

class blankCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor=None,
            edgecolor=None,
            linewidth=0.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.0)
        self.ax = self.fig.add_subplot(111, alpha=0.0, aspect=1.5)
        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)
        self.ax.set_axis_off()
        self.ax.set_frame_on(False)
        self.fig.subplots_adjust(left=0, bottom=0, right=1, top=1)

        self.ax.patch.set_alpha(0.0)
        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()


class xkcdFigure(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=1,
        height=1,
        dpi=150,
        ):

        self.fig = Figure(
            (width, height),
            dpi=150,
            facecolor='white',
            edgecolor=None,
            frameon=False,
            tight_layout=False,
            )

        self.ax = self.fig.add_subplot(111)

        # self.ax.set_axis_off()

        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)

        # self.line, =self.ax.plot([], [], color="g")

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self,
                QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)


class Visualization(HasTraits):

    # meridional = Range(1, 30,  6)
    # transverse = Range(0, 30, 11)

    scene = Instance(MlabSceneModel, ())

    def __init__(
        self,
        x,
        y,
        z,
        c,
        ):
        x = x
        y = y
        z = z
        c = c

        # Do not forget to call the parent's __init__

        HasTraits.__init__(self)

        # x, y, z, value = curve(self.meridional, self.transverse)
        self.plot = None

    @on_trait_change('x,y,z,c')
    def update_plot(
        self,
        x,
        y,
        z,
        c,
        ):
        if not self.plot:
            self.plot = self.scene.mlab.plot3d(x, y, z, c,
                    colormap='rainbow')#'Spectral')
        else:
            self.plot.mlab_source.set(x=x, y=y, z=z, scalars=c)

    # the layout of the dialog created
    # view = View(Item('scene', editor=SceneEditor(scene_class=MayaviScene),
    #                height=250, width=300, show_label=False),

    view = View(Item(  # MayaviScene),
        'scene',
        editor=SceneEditor(scene_class=Scene),
        resizable=True,
        height=750,
        width=1200,
        show_label=False,
        ), resizable=True)  # HGroup(
                            #        '_', 'x','y','z','c',#'meridional', 'transverse',
                            #    ),


class mayaviCanvas(QtGui.QMainWindow):

    def __init__(
        self,
        parent=None,
        x=[],
        y=[],
        z=[],
        value=[],
        ):
        QtGui.QWidget.__init__(self, parent)
        self.parent = parent
        self.visualization = Visualization(x, y, z, value)
        self.ui = self.visualization.edit_traits().control
        self.setCentralWidget(self.ui)


