#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

from conf.constants import *

# for user defined

from reflection import *
from roi import *
from detector import *
from monitor import *

# from scan import *

from polarization import *
from gisans import *
from experiment import *


# from model.chopperModel import *

class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.detectorPage = CSNSDetectorPage(self)
        self.reflectionPage = CSNSReflectionPage(self)
        #self.roiPage = CSNSRoiPage(self)
        self.monitorPage = CSNSMonitorPage(self)

        # self.scanPage = CSNSScanPage(self)

        self.polarizationPage = CSNSPolarizationPage(self)
        self.gisansPage = CSNSGisansPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.reflectionPage, 'Reflection')
        self.addTab(self.detectorPage, 'Detector')
        #self.addTab(self.roiPage, 'ROI')
        self.addTab(self.monitorPage, 'Monitor')

        # self.addTab(self.scanPage, 'Scan')

        self.addTab(self.polarizationPage, 'Polarization')
        self.addTab(self.gisansPage, 'Gisans')
        self.addTab(self.experimentPage, 'Progress')
        self.setTabEnabled(3,False)
        self.setTabEnabled(4,False)
        #self.setTabEnabled(5,False)

        self.currentChanged.connect(self.tabChange)

    def setIndex(self, index):
        self.setCurrentIndex(index)

    def clearCanvas(self):
        self.reflectionPage.clearCanvas()
        #self.roiPage.clearCanvas()
        self.detectorPage.clearCanvas()
        self.monitorPage.clearCanvas()
        self.experimentPage.clearCanvas()

    # get canvas data from getNeonData
    def getReflectionData(self):
        self.parent.getReflectionData()
    def getMonitorData(self):
        self.parent.getMonitorData()

    # get tube neutron choose in reflection
    def getTube1Check(self):
        return self.reflectionPage.getTube1Check()
    def getTube2Check(self):
        return self.reflectionPage.getTube2Check()
    def getTube3Check(self):
        return self.reflectionPage.getTube3Check()
    def getTube4Check(self):
        return self.reflectionPage.getTube4Check()

    def getReflectionPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []

        #index = self.reflectionPage.getComboBoxTube()
        path1 = '/MR/workspace/MantidData/detector/xy_image/x'
        path2 = '/MR/workspace/MantidData/detector/xy_image/y'
        path3 = '/MR/workspace/MantidData/detector/xy_image/value'
        #path1 = '/MR/workspace/MantidData/detector/xy_image/x'
        #path2 = '/MR/workspace/MantidData/detector/xy_image/y'
        #path3 = '/MR/workspace/MantidData/detector/xy_image/value'

        _roiSelected = self.reflectionPage.getRoiVar()
        _index1 = self.reflectionPage.unit1Selected()
        if _index1 == 0:
            if _roiSelected:
                path4 = '/MR/workspace/MantidData/ROI/raw/Itof/tof'
                path5 = '/MR/workspace/MantidData/ROI/raw/Itof/counts'
            else:
                path4 = '/MR/workspace/MantidData/raw/Itof/tof'
                path5 = '/MR/workspace/MantidData/raw/Itof/counts'
        elif _index1 == 1:
            if _roiSelected:
                path4 = '/MR/workspace/MantidData/ROI/raw/Itheta/theta'
                path5 = '/MR/workspace/MantidData/ROI/raw/Itheta/counts'
            else:
                path4 = '/MR/workspace/MantidData/raw/Itheta/theta'
                path5 = '/MR/workspace/MantidData/raw/Itheta/counts'
        else:
            if _roiSelected:
                path4 = '/MR/workspace/MantidData/ROI/raw/Iwave/wavelength'
                path5 = '/MR/workspace/MantidData/ROI/raw/Iwave/counts'
            else:
                path4 = '/MR/workspace/MantidData/raw/Iwave/wavelength'
                path5 = '/MR/workspace/MantidData/raw/Iwave/counts'
        _index = self.reflectionPage.normSelected()
        if _index == 0:
            if _roiSelected:
                path6 = \
                    '/MR/workspace/MantidData/ROI/reduction/monitor/IQ/q'
                path7 = \
                    '/MR/workspace/MantidData/ROI/reduction/monitor/IQ/counts'
            else:
                path6 = \
                    '/MR/workspace/MantidData/reduction/monitor/IQ/q'
                path7 = \
                    '/MR/workspace/MantidData/reduction/monitor/IQ/counts'
        else:
            if _roiSelected:
                path6 = \
                    '/MR/workspace/MantidData/ROI/reduction/PC/IQ/q'
                path7 = \
                    '/MR/workspace/MantidData/ROI/reduction/PC/IQ/counts'
            else:
                path6 = '/MR/workspace/MantidData/reduction/PC/IQ/q'
                path7 = \
                    '/MR/workspace/MantidData/reduction/PC/IQ/counts'

        return (
            path1,
            path2,
            path3,
            path4,
            path5,
            path6,
            path7,
            )

    def getRoiPath(self):
        path1 = []
        path2 = []
        for i in range(4):
            path1.append('/MR/workspace/MantidData/detector/xy_image/pos')
            path2.append('/MR/workspace/MantidData/detector/xy_image/counts')
        return (path1, path2)

    def getDetectorPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1 = '/MR/workspace/MantidData/IQxy/x'
        path2 = '/MR/workspace/MantidData/IQxy/y'
        path3 = '/MR/workspace/MantidData/IQxy/counts'
        return (path1, path2, path3)

    def getDetectorPath1(self):
        path1 = []
        path2 = []
        path3 = []
        for i in range(1):
            path1.append([])
            path2.append([])
            path3.append([])
        for i in range(1):
            path1[i] = '/MR/workspace/MantidData/IQxy/x'
            path2[i] = '/MR/workspace/MantidData/IQxy/y'
            path3[i] = '/MR/workspace/MantidData/IQxy/counts'
        return (path1, path2, path3)

    def getMonitorPath(self):
        monitorStatus = []
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _index = self.monitorPage.getComboIndex()
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            path1.append('/MR/workspace/MantidData/monitor' + str(i
                         + 1) + '/xy_image/x')
            path2.append('/MR/workspace/MantidData/monitor' + str(i
                         + 1) + '/xy_image/y')
            path3.append('/MR/workspace/MantidData/monitor' + str(i
                         + 1) + '/xy_image/value')
            if _index == 0:
                path4.append('/MR/workspace/MantidData/monitor' + str(i
                             + 1) + '/tof')
                path5.append('/MR/workspace/MantidData/monitor' + str(i
                             + 1) + '/counts')
            else:
                path4.append('/MR/workspace/MantidData/monitor' + str(i
                             + 1) + '/wave')
                path5.append('/MR/workspace/MantidData/monitor' + str(i
                             + 1) + '/wcounts')
        return (
            monitorStatus,
            path1,
            path2,
            path3,
            path4,
            path5,
            )

    # def getScanPath(self):
    #    path1 = []
    #    path1 = '/MR/workspace/MantidData/scan'
    #    return path1

    def getPolarizationPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _index = self.polarizationPage.comboSelected()
        if _index == 0:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        elif _index == 1:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        elif _index == 2:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        else:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        return (path1, path2, path3, path4, path5)

    def getGisansPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path1 = '/MR/workspace/MantidData/IQxyz/x'
        path2 = '/MR/workspace/MantidData/IQxyz/y'
        path3 = '/MR/workspace/MantidData/IQxyz/z'
        path4 = '/MR/workspace/MantidData/IQxyz/counts'
        return (path1, path2, path3, path4)

    def getExperimentPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1 = '/MR/drone/proton_charge'
        path2 = '/MR/drone/detector_counts'
        path3 = '/MR/drone/pulse_counts'
        return (path1, path2, path3)

    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []
        groupStatus = []
        monitorStatus = []
        kwargs = {}
        tabIndex = self.currentIndex()

        if tabIndex == 1:
            (path1, path2, path3) = self.getDetectorPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                }
        elif tabIndex == 0:
            (
                path1,
                path2,
                path3,
                path4,
                path5,
                path6,
                path7,
                ) = self.getReflectionPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                'path6': path6,
                'path7': path7,
                }
        #elif tabIndex == 1:
        #    (path1, path2) = self.getRoiPath()
        #    kwargs = {'tabIndex': tabIndex, 'path1': path1,
        #              'path2': path2}
        elif tabIndex == 2:
            (
                monitorStatus,
                path1,
                path2,
                path3,
                path4,
                path5,
                ) = self.getMonitorPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                'status': monitorStatus,
                }
        elif tabIndex == 3:

        # elif tabIndex == 4:
        #    path1 = self.getScanPath()
        #    kwargs = {"tabIndex": tabIndex, "path1": path1}

            (path1, path2, path3, path4, path5) = \
                self.getPolarizationPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                'path5': path5,
                }
        elif tabIndex == 4:
            (path1, path2, path3, path4) = self.getGisansPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                'path4': path4,
                }
        elif tabIndex == 5:
            (path1, path2, path3) = self.getExperimentPath()
            kwargs = {
                'tabIndex': tabIndex,
                'path1': path1,
                'path2': path2,
                'path3': path3,
                }

        self.parent.setDataPath(kwargs)


