#!/usr/bin/python
# -*- coding: utf-8 -*-

#from PyQt4 import QtCore, QtGui
#from PyQt4 import Qt
from conf.constants import *
# for user defined

from reflection import *
from detector import *
from monitor import *
from scan import *
from polarization import *
from gisans import *
from experiment import *
#from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.reflectionPage = CSNSReflectionPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.scanPage = CSNSScanPage(self)
        self.polarizationPage = CSNSPolarizationPage(self)
        self.gisansPage = CSNSGisansPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.reflectionPage, 'Reflection')
        self.addTab(self.detectorPage, 'Detector')
        self.addTab(self.monitorPage, 'Monitor')
        self.addTab(self.scanPage, 'Scan')
        self.addTab(self.polarizationPage, 'Polarization')
        self.addTab(self.gisansPage, 'Gisans')
        self.addTab(self.experimentPage, 'Progress')
    
        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getReflectionPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        path6 = []
        path7 = []
        path1 = '/MR/workspace/MantidData/detector/xy_image/x'
        path2 = '/MR/workspace/MantidData/detector/xy_image/y'
        path3 = '/MR/workspace/MantidData/detector/xy_image/value'

        _roiSelected = self.reflectionPage.getRoiVar()
        _index1 = self.reflectionPage.unit1Selected()
        if _index1 == 0:
            if _roiSelected:
                path4 = '/MR/workspace/MantidData/ROI/raw/Itof/tof'
                path5 = '/MR/workspace/MantidData/ROI/raw/Itof/counts'
            else:
                path4 = '/MR/workspace/MantidData/raw/Itof/tof'
                path5 = '/MR/workspace/MantidData/raw/Itof/counts'
        elif _index1 == 1:
            if _roiSelected:
                path4 = '/MR/workspace/MantidData/ROI/raw/Itheta/theta'
                path5 = '/MR/workspace/MantidData/ROI/raw/Itheta/counts'
            else:
                path4 = '/MR/workspace/MantidData/raw/Itheta/theta'
                path5 = '/MR/workspace/MantidData/raw/Itheta/counts'
        else:
            if _roiSelected:
                path4 = '/MR/workspace/MantidData/ROI/raw/IQ/q'
                path5 = '/MR/workspace/MantidData/ROI/raw/IQ/counts'
            else:
                path4 = '/MR/workspace/MantidData/raw/IQ/q'
                path5 = '/MR/workspace/MantidData/raw/IQ/counts'
        _index = self.reflectionPage.normSelected()
        _index2 = self.reflectionPage.unit2Selected()
        if _index == 0:
            if _index2 == 0:
                if _roiSelected:
                    path6 = '/MR/workspace/MantidData/ROI/reduction/monitor/Itof/tof'
                    path7 = '/MR/workspace/MantidData/ROI/reduction/monitor/Itof/counts'
                else:
                    path6 = '/MR/workspace/MantidData/reduction/monitor/Itof/tof'
                    path7 = '/MR/workspace/MantidData/reduction/monitor/Itof/counts'
            else:
                if _roiSelected:
                    path6 = '/MR/workspace/MantidData/ROI/reduction/monitor/IQ/q'
                    path7 = '/MR/workspace/MantidData/ROI/reduction/monitor/IQ/counts'
                else:
                    path6 = '/MR/workspace/MantidData/reduction/monitor/IQ/q'
                    path7 = '/MR/workspace/MantidData/reduction/monitor/IQ/counts'
        else:
            if _index2 == 0:
                if _roiSelected:
                    path6 = '/MR/workspace/MantidData/ROI/reduction/PC/Itof/tof'
                    path7 = '/MR/workspace/MantidData/ROI/reduction/PC/Itof/counts'
                else:
                    path6 = '/MR/workspace/MantidData/reduction/PC/Itof/tof'
                    path7 = '/MR/workspace/MantidData/reduction/PC/Itof/counts'
            else:
                if _roiSelected:
                    path6 = '/MR/workspace/MantidData/ROI/reduction/PC/IQ/q'
                    path7 = '/MR/workspace/MantidData/ROI/reduction/PC/IQ/counts'
                else:
                    path6 = '/MR/workspace/MantidData/reduction/PC/IQ/q'
                    path7 = '/MR/workspace/MantidData/reduction/PC/IQ/counts'
                    
        return path1, path2, path3, path4, path5, path6, path7

    def getDetectorPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path1 = "/MR/workspace/MantidData/IQxyz/x"
        path2 = "/MR/workspace/MantidData/IQxyz/y"
        #path3 = "/MR/workspace/MantidData/IQxyz/z"
        path3 = "/MR/workspace/MantidData/IQxyz/counts"
        return path1, path2, path3#, path4

    def getMonitorPath(self):
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            monitorAxisXPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_x')
            monitorAxisYPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_y')
            monitorValuePath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/value')
            monitorTOFPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/tof')
            monitorCountsPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/counts')
        return monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath
    
    def getScanPath(self):
        path1 = []
        path1 = '/MR/workspace/MantidData/scan'
        return path1

    def getPolarizationPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _index = self.polarizationPage.comboSelected()
        if _index == 0:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        elif _index == 1:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        elif _index == 2:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        else:
            path1 = ''
            path2 = ''
            path3 = ''
            path4 = ''
            path5 = ''
        return path1, path2, path3, path4, path5
        
    def getGisansPath(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path1 = '/MR/workspace/MantidData/IQxyz/x'
        path2 = '/MR/workspace/MantidData/IQxyz/y'
        path3 = '/MR/workspace/MantidData/IQxyz/z'
        path4 = '/MR/workspace/MantidData/IQxyz/counts'
        return path1, path2, path3, path4

    def getExperimentPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1.append('/MR/workspace/MantidData/proton_charge/time')
        path1.append('/MR/workspace/MantidData/proton_charge/value')
        path2.append('/MR/workspace/MantidData/neutron_counts/time')
        path2.append('/MR/workspace/MantidData/neutron_counts/value')
        path3.append('/MR/workspace/MantidData/pulse_charge/time')
        path3.append('/MR/workspace/MantidData/pulse_charge/value')
        return path1, path2, path3
    
    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        groupStatus = []
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        kwargs = {}
        tabIndex = self.currentIndex()

        if tabIndex == 0:
            path1, path2, path3, path4, path5, path6, path7 = self.getReflectionPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3,
                    "path4": path4, "path5": path5, "path6": path6, "path7": path7}
        elif tabIndex == 1:
            path1, path2, path3 =  self.getDetectorPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3}
                    #"path4": path4}
        elif tabIndex == 2:
            monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath = self.getMonitorPath()
            kwargs = {"tabIndex": tabIndex, "path1": monitorValuePath, "path2": monitorAxisXPath, "path3": monitorAxisYPath, "path4": monitorTOFPath,"path5": monitorCountsPath, "status": monitorStatus}
        elif tabIndex == 3:
            path1 = self.getScanPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1}            
        elif tabIndex == 4:
            path1, path2, path3, path4, path5 = self.getPolarizationPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3,
                    "path4": path4, "path5": path5}
        elif tabIndex == 5:
            path1, path2, path3, path4 = self.getGisansPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3,
                    "path4": path4}
        elif tabIndex == 6:
            path1, path2, path3 = self.getExperimentPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3}
       
        self.parent.setDataPath(kwargs)
