'''
Created on 2015.6.2
@author: yll
'''
# configure
from conf.constants import *

# user defined
#from model.readData import *
#from model.slitModel import *
#from presenter.slitSignal import *
from viewer.canvas import *

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)
        
        _width=3.5
        self.mainCanvas = figureCanvas(
            self,
            _width,
            _width,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )

        self.mainCanvas.x1 = self.mainCanvas.ax.axhline(0,color='gray')
        self.mainCanvas.y1 = self.mainCanvas.ax.axvline(0,color='gray')
        self.mainCanvas.draw()
        self.mouseClickedEvents()

        # canvas for y
        self.upCanvas = figureCanvas(
            self,
            _width,
            1,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'Y / mm',
            'Neutron Counts',
            )
        self.upCanvas.setMinimumHeight(50)

        # canvas for x
        self.leftCanvas = figureCanvas(
            self,
            1,
            _width,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Neutron Counts',
            )
        self.leftCanvas.setMinimumWidth(50)

        self.sliderY=QtGui.QSlider(QtCore.Qt.Horizontal)
        self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)
        
        # parameter grid
        self.directBeamLabel =  QtGui.QLabel("<font color=red>Direct Beam:</font>")
        self.directBeamText=QtGui.QLabel("(25,50) ")

        self.reflectedBeamLabel =  QtGui.QLabel("<font color=red>Reflected Beam:</font>")
        self.reflectedBeamText=QtGui.QLabel("(64,50)")

        self.parameterWidget= QtGui.QWidget(self.first)
        self.parameterGrid = QtGui.QGridLayout(self.parameterWidget)
        
        _nline = 0
        self.mainGrid.addWidget(self.upCanvas,_nline,1,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.leftCanvas,_nline,0,1,1,QtCore.Qt.AlignRight)
        self.mainGrid.addWidget(self.mainCanvas,_nline,1,1,1)
        self.mainGrid.addWidget(self.sliderX,_nline,2,1,1, QtCore.Qt.AlignLeft)
        _nline += 1
        self.mainGrid.addWidget(self.sliderY,_nline,1,1,1, QtCore.Qt.AlignTop)
        _nline += 1
        self.mainGrid.addWidget(self.parameterWidget,_nline,0,1,1, QtCore.Qt.AlignTop)

        self.mainGrid.columnStretch(1)
        
        _nline += 1
        self.parameterGrid.addWidget(self.directBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.directBeamText,_nline,1,1,1)
        _nline += 1
        self.parameterGrid.addWidget(self.reflectedBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.reflectedBeamText,_nline,1,1,1)
        
        self.horizontalLayout.addWidget(self.scrollArea)

        self.value = None
        self.xdata=0
        self.ydata=0
        self.mouseClicked = False

    def mouseClickedEvents(self):
        self.mainCanvas.mpl_connect('button_press_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('motion_notify_event', self.changeRegion)
        #self.slitImageCanvas.mpl_connect('button_release_event', self.changeXYFigure)
        self.mainCanvas.mpl_connect('button_press_event', self.changeXYFigure)

    def changeRegion(self,event):
        self.mainCanvas.ax.clear()
        self.xdata=event.xdata
        self.ydata=event.ydata
        _canvas = self.mainCanvas
        self.mainCanvas.ax.contourf(self.value[0], self.value[1], self.value[2], cmap='hot', zorder=1)
        _xdata, _ydata,_xindex, _yindex = self.getXYData(event.xdata, event.ydata, self.value)
        if event.button == 1:
            #self.mainCanvas.y1.set_ydata([event.ydata,event.ydata])
            _canvas.x1 = _canvas.ax.axhline(event.ydata,color='gray',zorder=2)
            _canvas.y1 = _canvas.ax.axvline(event.xdata,color='gray',zorder=2)
        elif event.button == 3:
            #self.mainCanvas.x1.set_xdata([event.xdata,event.xdata])
            _canvas.x1 = _canvas.ax.axhline(event.ydata,color='gray',zorder=2)
            _canvas.y1 = _canvas.ax.axvline(event.xdata,color='gray',zorder=2)
        else:
            pass
        #_canvas.ax.relim()
        #_canvas.ax.autoscale_view(True, True, True)
        _canvas.draw()

    def changeXYFigure(self,event):
        self.leftCanvas.ax.clear()
        self.upCanvas.ax.clear()
        color2D = 'r'
        _datax, _datay = self.getCountsData(self.value)
        if event.button == 1:
            self.mouseClicked = True
            try:
                self.leftCanvas.ax.plot(_datax, self.value[1], color=color2D)
                #self.leftCanvas.fig.set_xdata(_datax, color=color2D)
                self.leftCanvas.draw()
            except:
                pass
            try:
                self.upCanvas.ax.plot(self.value[0], _datay, color=color2D)
                self.upCanvas.draw()
            except:
                pass
        elif event.button == 3:
            self.mouseClicked = True
            try:
                self.upCanvas.ax.plot(self.value[0], _datay, color=color2D)
                #self.upCanvas.fig.set_ydata(_datay, color=color2D)
                self.upCanvas.draw()
            except:
                pass
            try:
                self.leftCanvas.ax.plot(_datax, self.value[1], color=color2D)
                self.leftCanvas.draw()
            except:
                pass

    def getXYData(self, xdata, ydata, value):
        _xdata = 0
        _ydata = 0
        xlist = []
        ylist = []
        _minx=0
        _miny=0
        xindex=0
        yindex=0

        for i in range(len(value[0])):
            xlist.append(abs(value[0][i]-xdata))
        _minx = min(xlist)
        xindex=xlist.index(_minx)
        _xdata= value[0][xindex]

        for i in range(len(value[1])):
            ylist.append(abs(value[1][i]-ydata))
        _miny=min(ylist)
        yindex=ylist.index(_miny)
        _ydata = value[1][yindex]

        #self.xEventData = _xdata  
        #self.yEventData = _ydata  
        return _xdata, _ydata, xindex, yindex

    def getCountsData(self, value):
        xcounts=[]
        ycounts=[]
        _xdata, _ydata, xindex, yindex = self.getXYData(self.xdata, self.ydata, self.value)
        ytmp=value[2][yindex]
        for j in ytmp:
            ycounts.append(j)

        for i in range(len(value[1])):
            xcounts.append(value[2][i][xindex])
        return xcounts, ycounts

    def updateCanvas(self, value, started, _command):
        self.mainCanvas.ax.clear()
        #self.upCanvas.ax.clear()
        #self.leftCanvas.ax.clear()
        self.value = value
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                color2D = 'r'
                color3D = 'hot'
                try:
                    #self.mainCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D, zorder=1)
                    self.mainCanvas.ax.contourf(value[0], value[1], value[2], cmap=color3D, zorder=1)
                except:
                    pass
                try:
                    self.mainCanvas.x1 = self.mainCanvas.ax.axhline(self.ydata,color='gray',zorder=2)
                    self.mainCanvas.y1 = self.mainCanvas.ax.axvline(self.xdata,color='gray',zorder=2)
                    #self.mainCanvas.ax.relim()
                    #self.mainCanvas.ax.autoscale_view(True, True, True)
                except:
                    pass
            self.mainCanvas.draw()
        try:
            if not self.mouseClicked:
                _datax, _datay = self.getCountsData(self.value)
                try:
                    self.leftCanvas.ax.plot(_datax, self.value[1], color=color2D)
                    #self.leftCanvas.fig.set_xdata(_datax, color=color2D)
                    self.leftCanvas.draw()
                except:
                    pass
                try:
                    self.upCanvas.ax.plot(self.value[0], _datay, color=color2D)
                    self.upCanvas.draw()
                except:
                    pass
        except:
            pass

