#!/usr/bin/python
# -*- coding: utf-8 -*-

# for pyqt4
from conf.constants import *
from tvtk.pyface.api import Scene
#from PyQt4 import QtCore, QtGui
#from PyQt4 import Qt

import matplotlib
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure

class figureCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        plotColor = '',
        title='',
        xlabel='',
        ylabel='',
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'
        #self.ax.hold(True)

        # self.ax.patch.set_alpha(0)

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()

class blankCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor=None,
            edgecolor=None,
            linewidth=0.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.0)
        self.ax = self.fig.add_subplot(111, alpha=0.0, aspect=1.5)
        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)
        self.ax.set_axis_off()
        self.ax.set_frame_on(False)
        self.fig.subplots_adjust(left=0, bottom=0, right=1,top=1)

        self.ax.patch.set_alpha(0.0)
        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()

class xkcdFigure(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=1,
        height=1,
        dpi=150,
        ):

        self.fig = Figure(
            (width, height),
            dpi=150,
            facecolor='white',
            edgecolor=None,
            frameon=False,
            tight_layout=False,
            )

        self.ax = self.fig.add_subplot(111)
        #self.ax.set_axis_off()
        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)
        #self.line, =self.ax.plot([], [], color="g")

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)

class Visualization(HasTraits):
    #meridional = Range(1, 30,  6)
    #transverse = Range(0, 30, 11)
    scene      = Instance(MlabSceneModel, ())

    def __init__(self, x, y, z, c):
        x = x
        y = y
        z = z
        c = c 
        # Do not forget to call the parent's __init__
        HasTraits.__init__(self)
        #x, y, z, value = curve(self.meridional, self.transverse)
        self.plot=None

    @on_trait_change('x,y,z,c')
    def update_plot(self, x, y, z, c):
        if not self.plot:
            self.plot = self.scene.mlab.plot3d(x, y, z, c, colormap='Spectral')
        else:
            self.plot.mlab_source.set(x=x, y=y, z=z, scalars=c)

    # the layout of the dialog created
    #view = View(Item('scene', editor=SceneEditor(scene_class=MayaviScene),
    #                height=250, width=300, show_label=False),
    view = View(Item('scene', editor=SceneEditor(scene_class=Scene),#MayaviScene),
                    resizable=True, height=450, width=800,
                    show_label=False),
                #HGroup(
                #        '_', 'x','y','z','c',#'meridional', 'transverse',
                #    ),
                resizable=True
                )

class mayaviCanvas(QtGui.QMainWindow):
    def __init__(self, parent=None,x=[],y=[],z=[],value=[]):
        QtGui.QWidget.__init__(self, parent)
        self.visualization = Visualization(x,y,z,value)
        self.ui = self.visualization.edit_traits().control
        self.setCentralWidget(self.ui)
