#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import time
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure
from redis.sentinel import Sentinel

from conf.constants import *
from model import neonReceiver
from viewer import canvas

class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

        self.parent = parent
        self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)

        self.timeF = QtGui.QFrame(self)
        self.timeF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaTime = QtGui.QScrollArea()
        self.scrollAreaTime.setWidgetResizable(True)
        self.scrollAreaTime.setWidget(self.timeF)

        self.envirF = QtGui.QFrame(self)
        self.envirF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaEnvir = QtGui.QScrollArea()
        self.scrollAreaEnvir.setWidgetResizable(True)
        self.scrollAreaEnvir.setWidget(self.envirF)

        self.delayF = QtGui.QFrame(self)
        self.delayF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaDelay = QtGui.QScrollArea()
        self.scrollAreaDelay.setWidgetResizable(True)
        self.scrollAreaDelay.setWidget(self.delayF)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreathird = QtGui.QScrollArea()
        self.scrollAreathird.setWidgetResizable(True)
        self.scrollAreathird.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollAreafirst)
        self.splitter.addWidget(self.scrollAreasecond)
        self.splitter.addWidget(self.scrollAreaTime)
        self.splitter.addWidget(self.scrollAreaEnvir)
        self.splitter.addWidget(self.scrollAreaDelay)
        self.splitter.addWidget(self.scrollAreathird)
        self.splitter.setSizes([120, 80, 120, 320, 20, 280])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.timeGrid = QtGui.QGridLayout(self.timeF)
        self.envirGrid = QtGui.QGridLayout(self.envirF)
        self.delayGrid = QtGui.QGridLayout(self.delayF)
        self.thirdGrid = QtGui.QGridLayout(self.third)

        # main verticalLayout

        self.MRLabel = QtGui.QLabel('<font size=20 color=red>MR </font><font size=1 color=black>20190422</font>')
        self.MRLabel.setFont(QtGui.QFont('Roman times', 15, QtGui.QFont.Bold))
        self.spectLabel = \
            QtGui.QLabel('<font color=black>Instrument Scientist: Tao Zhu</font>'
                         )
        self.developLabel = \
            QtGui.QLabel('<font size=2 color=black>Software Engineer: Lili Yan(347)</font>'
                         )

        self.verticalLayout.addWidget(self.MRLabel)
        self.verticalLayout.addWidget(self.spectLabel)
        self.verticalLayout.addWidget(self.developLabel)
        self.verticalLayout.addWidget(self.splitter)

        # first Grid

        self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('------', self.first)

        self.runNoLabel = QtGui.QLabel('RunNo: ', self.first)
        self.runNoText = QtGui.QLabel('------', self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('------', self.first)

        _nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)
        
        _nline += 1
        self.firstGrid.addWidget(self.runNoLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.runNoText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        # second Grid

        #self.neonLabel = QtGui.QLabel('NEON', self.second)
        #self.neonConnectLabel = QtGui.QLabel('', self.second)
        #self.neonConnectLabel.setFixedSize(QtCore.QSize(80, 30))

        #self.commandLabel = QtGui.QLabel('Command: ', self.second)

        self.commandTimeLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel.setStyleSheet('color:green')

        #self.statusLabel = QtGui.QLabel('State: ', self.second)
        self.statusTimeLabel = QtGui.QLabel('', self.second)
        if len(sys.argv) == 1:
            self.statusValueLabel = QtGui.QLabel('None', self.second)
        else:
            self.statusValueLabel = QtGui.QLabel('Read only', self.second)        
        self.statusValueLabel.setStyleSheet('color:blue')

        _nline = 0
        #self.secondGrid.addWidget(self.neonLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        #self.secondGrid.addWidget(self.neonConnectLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        #_nline += 1
        #self.secondGrid.addWidget(self.commandLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.commandValueLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        #_nline += 1
        self.secondGrid.addWidget(self.commandTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        _nline += 1
        #self.secondGrid.addWidget(self.statusLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.statusValueLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        #_nline += 1
        self.secondGrid.addWidget(self.statusTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft | QtCore.Qt.AlignTop)

        # time Grid

        self.currentTimeLabel = \
            QtGui.QLabel('<font color=red>Current Time:</font>')
        self.currentTimeText = QtGui.QLabel('-----')
        self.currentTimeText.setStyleSheet('color:red')
        self.currentTimer = QtCore.QTimer(self)
        self.labelConstant = True
        self.currentTimer.timeout.connect(self.changeTime)
        self.currentTimer.start(1000)

        self.startTimeLabel = \
            QtGui.QLabel('<font color=red>Start Time:</font>')
        self.startTimeText = \
            QtGui.QLabel('------')
        self.startTimeText.setStyleSheet('color:red')
        self.endTimeLabel = \
            QtGui.QLabel('<font color=red>End Time:</font>')
        self.endTimeText = QtGui.QLabel('------')
        self.endTimeText.setStyleSheet('color:red')

        _nline = 0
        self.timeGrid.addWidget(self.currentTimeLabel,_nline,0,1,1)
        self.timeGrid.addWidget(self.currentTimeText,_nline,1,1,1)

        _nline += 1
        self.timeGrid.addWidget(self.startTimeLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.timeGrid.addWidget(self.startTimeText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.timeGrid.addWidget(self.endTimeLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.timeGrid.addWidget(self.endTimeText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        # delay Grid
        self.detectorDelayLabel = QtGui.QLabel('<font color=red>Detector Delay Time:</font>')
        self.detectorDelayText = QtGui.QLabel('------')
        self.detectorDelayText.setStyleSheet('color:red')

        _nline = 0
        self.delayGrid.addWidget(self.detectorDelayLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.delayGrid.addWidget(self.detectorDelayText,_nline,1,1,1,QtCore.Qt.AlignLeft,)

        # environment Grid
        self.rzLabel = QtGui.QLabel('RZ:')
        self.rzText = QtGui.QLabel('------')

        self.daLabel = QtGui.QLabel('DA:')
        self.daText = QtGui.QLabel('------')

        self.xLabel = QtGui.QLabel('X:')
        self.xText = QtGui.QLabel('------')

        self.sl2wLabel = QtGui.QLabel('SL2W:')
        self.sl2wText = QtGui.QLabel('------')

        self.sl3wLabel = QtGui.QLabel('SL3W:')
        self.sl3wText = QtGui.QLabel('------')

        self.tempLabel = QtGui.QLabel('Temp:')
        self.tempText = QtGui.QLabel('------')

        self.f1Label = QtGui.QLabel('F1:')
        self.f1Text = QtGui.QLabel('------')

        self.f2Label = QtGui.QLabel('F2:')
        self.f2Text = QtGui.QLabel('------')

        self.magLabel = QtGui.QLabel('Mag:')
        self.magText = QtGui.QLabel('------')

        _nline = 0
        self.envirGrid.addWidget(self.rzLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.rzText, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.daLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.daText, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.xLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.xText, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.sl2wLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.sl2wText, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.sl3wLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.sl3wText, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.tempLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.tempText, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.f1Label,_nline,0,1,1)
        self.envirGrid.addWidget(self.f1Text, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.f2Label,_nline,0,1,1)
        self.envirGrid.addWidget(self.f2Text, _nline,1,1,1)
        _nline += 1
        self.envirGrid.addWidget(self.magLabel,_nline,0,1,1)
        self.envirGrid.addWidget(self.magText, _nline,1,1,1)

        # third Grid
        self.protonLabel = QtGui.QLabel('Proton Charge: ')
        self.protonText = QtGui.QLabel('------')

        self.detectorLabel = QtGui.QLabel('Detector Counts: ')
        self.detectorText = QtGui.QLabel('------')
        self.detectorRateLabel = QtGui.QLabel('    Counting Rates: ')
        self.detectorRateText = QtGui.QLabel('------')
        
        self.roiLabel = QtGui.QLabel('ROI Counts: ')
        self.roiText = QtGui.QLabel('------')
        self.roiRateLabel = QtGui.QLabel('    Counting Rates: ')
        self.roiRateText = QtGui.QLabel('------')

        self.monitorLabel = QtGui.QLabel('Monitor Counts: ')
        self.monitorText = QtGui.QLabel('------')
        self.monitorRateLabel = QtGui.QLabel('     Counting Rates: ')
        self.monitorRateText = QtGui.QLabel('------')

        #with plt.xkcd():
        #    self.runCanvas = canvas.xkcdFigure(self)

        _nline += 1
        self.thirdGrid.addWidget(
            self.protonLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.protonText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.detectorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.detectorText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.detectorRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.detectorRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.roiLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.roiText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.roiRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.roiRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.monitorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.monitorText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.monitorRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.monitorRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        #_nline += 1
        #self.thirdGrid.addWidget(self.runCanvas, _nline, 0, 1, 2, QtCore.Qt.AlignCenter)

        # self.thirdGrid.addItem(QtGui.QSpacerItem(-1, -1,
        #                       QtGui.QSizePolicy.Ignored,
        #                       QtGui.QSizePolicy.Expanding), 2, 0)

        self.dataThread = False
        self.pix = None
       
        self.neonServer = None 
        self.startTime = None

    def changeTime(self):
        timenow = time.strftime('%Y-%m-%d %H:%M:%S')
        self.currentTimeText.setText(timenow)

    def setNeonStatus(self, value):
        if value:
            self.neonConnectLabel.setText('connected')
        else:
            self.neonConnectLabel.setText('disconnected')

    def getIP_PORT(self):
        #_ip_port = [('10.1.53.240', 9001), ('10.1.53.240', 9011)]
        _ip_port = [('10.1.31.116', 9001), ('10.1.31.116', 9011)]
        return _ip_port

    def getNeon(self):
        status = False
        server = None

        _timeout = 10
        _ip_port = self.getIP_PORT()
        _passwd = 'sanlie;123'
        _r = neonReceiver.connectNeon(_ip_port, _passwd, _timeout)
        status = _r.getStatus()
        server = _r.getServer()
        return (status, server)

    def setUserInfo(self, value):
        #value = json.loads(str(value))
        
        try:
            self.userIDText.setText(str(value['userID']))
            self.runNoText.setText(str(value['runNo']))
            self.proposalText.setText(str(value['proposalID']))
        except:
            pass           
         
        try:
            self.detectorDelayText.setText(str(value['detectorDelay']))
        except:
            pass

    # get from neon

    def setCommandLabel(self, value):
        _timen = str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        self.setCommandTimeLabel(_timen)
        self.setCommandValueLabel(value)

    def setCommandTimeLabel(self, time):
        self.commandTimeLabel.setText(time)

    def setCommandValueLabel(self, value):
        self.commandValueLabel.setText(value)

    # get from neon

    def setStatusLabel(self, value):
        myStatus = self.statusValueLabel.text()
        _timen = str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        if myStatus != value:
            self.setStatusTimeLabel(_timen)
            self.setStatusValueLabel(value)
            logging.info(str('status is ' + value + ' now'))

    def setStatusTimeLabel(self, time):
        self.statusTimeLabel.setText(time)

    def setStatusValueLabel(self, value):
        if len(sys.argv) == 1:
            self.statusValueLabel.setText(value)
        else:
            pass

    def roiSelected(self):
        return self.parent.roiSelected()   
 
    def setROI(self, _roi, _roiRate):
        _roiSelected = self.roiSelected()
        if _roiSelected:
            try:
                self.roiText.setText(str(_roi))
            except:
                self.roiText.setText('------')
            try:
                self.roiRateText.setText(str(_roiRate))
            except:
                self.roiRateText.setText('------')
        else:
            self.roiText.setText('------')
            self.roiRateText.setText('------')

    def getTubeCounts(self):
        if self.neonServer == None:
            (neonStatus, self.neonServer) = \
                self.parent.getNeon()
        _detectorList = []
        _detectorRateList = []
        self.startTime = self.parent.startTime
        _time = time.time() - self.startTime
        _tmp = int(json.loads(self.neonServer.get('/MR/workspace/MantidData/neutroncounts1')))
        _rates = format(float(_tmp) / float(_time),'.2f')
        _detectorList.append(_tmp)
        _detectorRateList.append(_rates)
        _tmp = int(json.loads(self.neonServer.get('/MR/workspace/MantidData/neutroncounts2')))
        _rates = format(float(_tmp) / float(_time),'.2f')
        _detectorList.append(_tmp)
        _detectorRateList.append(_rates)
        _tmp = int(json.loads(self.neonServer.get('/MR/workspace/MantidData/neutroncounts3')))
        _rates = format(float(_tmp) / float(_time),'.2f')
        _detectorList.append(_tmp)
        _detectorRateList.append(_rates)
        _tmp = int(json.loads(self.neonServer.get('/MR/workspace/MantidData/neutroncounts4')))
        _rates = format(float(_tmp) / float(_time),'.2f')
        _detectorList.append(_tmp)
        _detectorRateList.append(_rates)
       
        return _detectorList, _detectorRateList
    
    def setProtonNeutron(self, _proton, _detector, _detectorRate, _monitor, _monitorRate):
        try:
            self.protonText.setText(str(_proton))
        except:
            self.protonText.setText('------')
        try:
            self.monitorText.setText(str(_monitor))
        except:
            self.monitorText.setText('------')
        try:
            self.monitorRateText.setText(str(_monitorRate))
        except:
            self.monitorRateText.setText('------')

        try:
            if self.parent.userInfo['mode'] == 'He3':
                _detector, _detectorRate = self.getTubeCounts()
                _neutron = 0
                _neutronRate = 0
                if self.getTube1Check():
                    _neutron = _detector[0]
                    _neutronRate = float(_detectorRate[0])
                if self.getTube2Check():
                    _neutron += _detector[1]
                    _neutronRate += float(_detectorRate[1])
                if self.getTube3Check():
                    _neutron += _detector[2]
                    _neutronRate += float(_detectorRate[2])
                if self.getTube4Check():
                    _neutron += _detector[3]
                    _neutronRate += float(_detectorRate[3])
            else:
                _neutron = _detector
                _neutronRate = _detectorRate
 
            self.detectorText.setText(str(_neutron))
            self.detectorRateText.setText(str(_neutronRate))
        except:
            self.detectorText.setText('------')
            self.detectorRateText.setText('------')

    # get tube neutron choose in reflection
    def getTube1Check(self):
        return self.parent.getTube1Check()
    def getTube2Check(self):
        return self.parent.getTube2Check()
    def getTube3Check(self):
        return self.parent.getTube3Check()
    def getTube4Check(self):
        return self.parent.getTube4Check()

    def setStartEndTime(self, _start, _end):
        try:
            self.startTimeText.setText(str(_start))
            self.endTimeText.setText(str(_end))
        except:
            self.startTimeText.setText('------')
            self.endTimeText.setText('------')

    def setUserValue(self, _value):
        try:
            self.rzText.setText(str(_value['RZ']))
        except:
            self.rzText.setText('-----')
        try:
            self.daText.setText(str(_value['DA']))
        except:
            self.daText.setText('-----')
        try:
            self.xText.setText(str(_value['X']))
        except:
            self.xText.setText('-----')
        try:
            self.sl2wText.setText(str(_value['SL2W']))
        except:
            self.sl2wText.setText('-----')
        try:
            self.sl3wText.setText(str(_value['SL3W']))
        except:
            self.sl3wText.setText('-----')
        try:
            self.tempText.setText(str(_value['Temp']))
        except:
            self.tempText.setText('-----')
        try:
            self.f1Text.setText(str(_value['F1']))
        except:
            self.f1Text.setText('-----')
        try:
            self.f2Text.setText(str(_value['F2']))
        except:
            self.f2Text.setText('-----')
        try:
            self.magText.setText(str(_value['Mag']))
        except:
            self.magText.setText('-----')

    '''
    def clearCanvas(self):
        self.runCanvas.ax.clear()
        self.runCanvas.draw()

    def updateMonitorCanvas(
        self,
        xdata,
        ydata,
        started,
        _command,
        ):
        try:
            if _command in ('configure', 'abort'):
                self.pix = None
            #elif not started:
            #    pass
            #else:
            if str(xdata) == 'clear' or str(ydata) == 'clear':
                self.runCanvas.ax.clear()
                self.runCanvas.draw()
            elif len(xdata) != len(ydata) or len(ydata) == 0:
                pass
            else:
                #if not self.pix:
                self.runCanvas.ax.clear()
                (self.pix, ) = self.runCanvas.ax.plot(xdata, ydata,
                        color='b')
                #else:
                #    self.pix.set_ydata(ydata)
                self.runCanvas.ax.relim()
                self.runCanvas.ax.autoscale_view()
                self.runCanvas.draw()
                self.runCanvas.flush_events()
        except:
            pass
    '''
