'''
Created on 2015.6.2
@author: yll
'''
# configure
from conf.constants import *
# user defined
#from model.readData import *
#from model.slitModel import *
#from presenter.slitSignal import *
from canvas import *

class CSNSRoiPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSRoiPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)
        

        self.canvas=[]
        _width=3.5
        for i in range(4):
            self.canvas.append(zoomCanvas(self,_width,_width,150,'r',' ','X / mm',''))
            #self.canvas[i].ax.tick_params(axis='y', left='off',labelleft='off')
        
        _nline = 0
        for i in range(len(self.canvas)):
            self.mainGrid.addWidget(self.canvas[3-i],_nline,0,1,1)
            _nline += 1

        self.mainGrid.columnStretch(1)
        
        self.horizontalLayout.addWidget(self.scrollArea)

        self.value = None
        self.xdata=0
        self.ydata=0
        self.mouseClicked = False

        self.pix1=[]
        self.pix2=[]
        for i in range(len(self.canvas)):
            self.pix1.append('')
            self.pix2.append('')

    def curveFit(self, x0, y0):
        from scipy.optimize import curve_fit

        def func(x, *params):
            y = np.zeros_like(x)
            for i in range(0, len(params), 3):
                ctr = params[i]
                amp = params[i+1]
                wid = params[i+2]
                y = y + amp * np.exp( -((x - ctr)/wid)**2/2.0)
            return y

        _max=max(y0)
        guess = [150, _max, 20]
        #for i in range(1):
        #    guess += [(i-0.5)*20, _max, 20]

        popt, pcov = curve_fit(func, x0, y0, p0=guess)
        print "Peak position:",popt[0]
        print "FWHM:",popt[2]*2.3548
        fit = func(x0, *popt)
        return fit

    def updateCanvas(self, value, started, _command):
        if _command in ('configure', 'abort'):
            self.pix1=[]
            self.pix2=[]
            for i in range(len(self.canvas)):
                self.canvas[i].draw()
                self.pix1.append('')
                self.pix2.append('')
        else:
            if not started:
                pass
            else:
                color2D = ['r','g','b','r']
                for i in range(len(self.canvas)):
                    if len(value[0][i]) != len(value[1][i]) or len(value[1][i]) == 0:
                        pass
                    else:
                        try:
                            if not self.pix1[i]:
                                self.canvas[i].ax.clear()
                                self.pix1[i],=self.canvas[i].ax.plot(value[0][i],value[1][i], '.')#color=color2D[i])
                                self.canvas[i].ax.add_patch(self.canvas[i].rect)
                                self.canvas[i].ax.xaxis.set_major_locator(matplotlib.ticker.MultipleLocator(10))
                                self.canvas[0].ax.set_xlabel('X / mm',fontsize=5)
                            else:
                                self.pix1[i].set_ydata(value[1][i])
                        except:
                            self.pix1[i] = None
                            self.pix2[i] = None
                        try:
                            _y = self.curveFit(value[0][i],value[1][i])
                        except:
                            self.canvas[i].ax.relim()
                            self.canvas[i].ax.autoscale_view()
                            self.canvas[i].ax.set_xlim(0,300)
                            self.canvas[i].draw()
                            continue
                        try:
                            if not self.pix2[i]:
                                self.pix2[i],=self.canvas[i].ax.plot(value[0][i],_y, 'r')#color=color2D[i])
                            else:
                                self.pix2[i].set_ydata(_y)
                        except:
                            pass
                            
                        if self.canvas[i].zoomSelected and (self.canvas[i].minX != self.canvas[i].maxX) and (self.canvas[i].minY != self.canvas[i].maxY):
                            self.canvas[i].ax.set_xlim(self.canvas[i].minX, self.canvas[i].maxX)   
                            self.canvas[i].ax.set_ylim(self.canvas[i].minY, self.canvas[i].maxY)
                        self.canvas[i].ax.relim()
                        self.canvas[i].ax.autoscale_view()
                        self.canvas[i].ax.set_xlim(0,300)
                        self.canvas[i].draw()
                print '----------------'
