#!/usr/bin/python
# -*- coding: utf-8 -*-

# user defined
from canvas import *
from conf.constants import *
import time
import redis
from model import jsonArray

class CSNSReflectionPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSReflectionPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        
        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea3 = QtGui.QScrollArea()
        self.scrollArea3.setWidgetResizable(True)
        self.scrollArea3.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        #self.splitter.addWidget(self.scrollArea3)
        self.splitter.setSizes([300, 150])#, 150])

        #main Grid
        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)

        self.button = QtGui.QPushButton('Submit')
        self.button.setMaximumHeight(30)
        self.button.setMaximumWidth(70)
        self.button.clicked.connect(self.buttonClicked)

        _xsize = 16#6
        _ysize = 8#3
        self.canvas1 = zoomCanvas(
            self,
            10,#_xsize,
            10,#_ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'X / mm',
            'Y / mm',
            )

        self.pix=None

        self.canvas1.draw()

        self.canvas2 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Neutron Counts',
            )

        self.canvas3 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'q (A-1)',
            'Scattering Intensity',
            )
        self.comboBoxUnit1 = QtGui.QComboBox()
        self.comboBoxUnit1.addItem('TOF')
        self.comboBoxUnit1.addItem('theta')
        self.comboBoxUnit1.addItem('Q')
        self.comboBoxUnit1.setMaximumWidth(150)
        self.comboBoxUnit1.activated.connect(self.parent.tabChange)
        self.comboBoxLog1 = QtGui.QComboBox()
        self.comboBoxLog1.addItem('linear')
        self.comboBoxLog1.addItem('logarithmic')
        self.comboBoxLog1.setMaximumWidth(150)
        self.comboBoxLog1.activated.connect(self.parent.tabChange)
       
        self.normLabel = QtGui.QLabel('Normalization by') 
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        self.comboBoxNorm.activated.connect(self.parent.tabChange)
        self.comboBoxUnit2 = QtGui.QComboBox()
        self.comboBoxUnit2.addItem('TOF')
        self.comboBoxUnit2.addItem('Q')
        self.comboBoxUnit2.setMaximumWidth(150)
        self.comboBoxUnit2.activated.connect(self.parent.tabChange)
        self.comboBoxLog2 = QtGui.QComboBox()
        self.comboBoxLog2.addItem('linear')
        self.comboBoxLog2.addItem('logarithmic')
        self.comboBoxLog2.setMaximumWidth(150)
        self.comboBoxLog2.activated.connect(self.parent.tabChange)

        _nline = 0
        self.firstGrid.addWidget(self.canvas1, _nline,1,7,1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.firstGrid.addWidget(self.button, _nline,10,7,1, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.comboBoxUnit1, _nline,0,1,1)
        self.secondGrid.addWidget(self.comboBoxLog1, _nline,1,1,1)
        self.secondGrid.addWidget(self.normLabel, _nline,7,1,1)
        self.secondGrid.addWidget(self.comboBoxNorm, _nline,8,1,1)
        self.secondGrid.addWidget(self.comboBoxUnit2, _nline,9,1,1)
        self.secondGrid.addWidget(self.comboBoxLog2, _nline,10,1,1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas2, _nline,0, 1, 7)
        self.secondGrid.addWidget(self.canvas3, _nline,7, 1, 7)
        
        self.verticalLayout.addWidget(self.splitter)       
        
        self.zoomClick = False
        self.zoomSelected = False
        self.roiSelected = False
        self.value = None
        self.neonServer = None

        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0
    
        self.pix1 = None
        self.pix2 = None
        self.pix3 = None
        
    def buttonClicked(self):
        path = '/MR/workspace/MantidData/roi'
        if self.zoomSelected == True:
            self.roiSelected = True
        try:
            if self.neonServer == None:
                neonStatus, self.neonServer = self.parent.parent.parent.getNeon()
            else:
                coord = [self.x1, self.y1, self.x2, self.y2]
                _coord_json = jsonArray.jsonEncoder(coord)
                self.neonServer.set(path, _coord_json)
                #self.neonServer.publish(path, _coord_json)
        except:
            pass
        self.parent.tabChange()        

    def getRoiVar(self):
        return self.roiSelected

    def log1Selected(self):
        index = self.comboBoxLog1.currentIndex()
        #self.parent.tabChange()
        return index 

    def unit1Selected(self):
        index = self.comboBoxUnit1.currentIndex()
        #self.parent.tabChange()
        return index 

    def log2Selected(self):
        index = self.comboBoxLog2.currentIndex()
        #self.parent.tabChange()
        return index 

    def unit2Selected(self):
        index = self.comboBoxUnit2.currentIndex()
        #self.parent.tabChange()
        return index 
    
    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        #self.parent.tabChange()
        return index 
    
    def getNeon(self):
        neonStatus, self.neonServer = self.parent.parent.parent.getNeon()

    def updateCanvas(self, value, started, _command):
        self.value = value
        if _command in ('configure', 'abort'):
            #self.canvas1.ax.clear()
            #self.canvas2.ax.clear()
            #self.canvas3.ax.clear()
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        else:
            if not started:
                pass
            else:
                try:
                    if len(value[2]) == 0 or len(self.value[2])!=len(value[2]):
                        self.pix1 = None
                    else:
                        if self.pix1 == None:
                            self.canvas1.ax.clear()
                            self.pix1=self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap='rainbow', zorder=1)
                            self.canvas1.ax.add_patch(self.canvas1.rect)
                            self.canvas1.ax.set_xlabel('X / mm')#q (A-1)')
                            self.canvas1.ax.set_ylabel('Y / mm')
                        else:
                            self.pix1.set_array(np.array(value[2])[:-1,:-1].ravel())
                        #self.canvas1.ax.axis('equal', adjustable='box')
                        if self.canvas1.zoomSelected and (self.canvas1.minX != self.canvas1.maxX) and (self.canvas1.minY != self.canvas1.maxY):
                            self.canvas1.ax.set_xlim(self.canvas1.minX, self.canvas1.maxX)
                            self.canvas1.ax.set_ylim(self.canvas1.minY, self.canvas1.maxY)
                        self.canvas1.draw()
                except:
                    self.pix1 = None
                try:
                    index = self.comboBoxLog1.currentIndex()
                    if self.roiSelected:
                        self.pix2 = None
                    if len(value[3]) != len(value[4]) or len(value[4]) == 0:
                        pass
                    else:
                        if self.pix2 == None:
                            self.canvas2.ax.clear()
                            self.pix2, = self.canvas2.ax.plot(value[3], value[4], color='b')
                            self.canvas2.ax.add_patch(self.canvas2.rect)
                            self.roiSelected = False
                            self.canvas2.ax.set_xlabel('Wavelength')#q (A-1)')
                            self.canvas2.ax.set_ylabel('Neutron Counts')
                        else:
                            #self.pix2.set_xdata(value[3])
                            self.pix2.set_ydata(value[4])
                        if self.canvas2.zoomSelected and (self.canvas2.minX != self.canvas2.maxX) and (self.canvas2.minY != self.canvas2.maxY):
                            self.canvas2.ax.set_xlim(self.canvas2.minX, self.canvas2.maxX)   
                            self.canvas2.ax.set_ylim(self.canvas2.minY, self.canvas2.maxY)
                        if index == 0:
                            self.canvas2.ax.set_yscale('linear')
                        else:
                            self.canvas2.ax.set_yscale('log')
                        self.canvas2.ax.relim()
                        self.canvas2.ax.autoscale_view()
                        self.canvas2.draw()
                except:
                    self.pix2 = None
                try:
                    index = self.comboBoxLog2.currentIndex()
                    if len(value[5]) != len(value[6]) or len(value[6]) == 0:
                        pass
                    else:
                        if not self.pix3:
                            self.canvas3.ax.clear()
                            self.pix3, = self.canvas3.ax.plot(value[5], value[6], color='g')
                            self.canvas3.ax.add_patch(self.canvas3.rect)
                            self.canvas3.ax.set_xlabel('Wavelength')
                            self.canvas3.ax.set_ylabel('Neutron Counts')
                        else:
                            #self.pix3.set_xdata(value[5])
                            self.pix3.set_ydata(value[6])
                        if self.canvas3.zoomSelected  and (self.canvas3.minX != self.canvas3.maxX) and (self.canvas3.minY != self.canvas3.maxY):
                            self.canvas3.ax.set_xlim(self.canvas3.minX, self.canvas3.maxX)   
                            self.canvas3.ax.set_ylim(self.canvas3.minY, self.canvas3.maxY)
                        if index == 0:
                            self.canvas3.ax.set_yscale('linear')
                        else:
                            self.canvas3.ax.set_yscale('log')
                        self.canvas3.ax.relim()
                        self.canvas3.ax.autoscale_view()
                        self.canvas3.draw()
                except:
                    self.pix3 = None

