'''
Created on 2015.6.4
@author: yll

Analysis

'''
from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
#from reflectivity import *

class CSNSPolarizationPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSPolarizationPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QTabWidget):
    	#self.setTabPosition(QTabWidget.West)
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.mainFrame = QtGui.QFrame(self)
        self.mainFrame.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.mainFrame)

        #main  grid
        self.mainGrid = QtGui.QGridLayout(self.mainFrame)

        #++/--/+-/-+
        self.channelComboBox = QtGui.QComboBox()
        self.channelComboBox.addItem("++")
        self.channelComboBox.addItem("+-")
        self.channelComboBox.addItem("-+")
        self.channelComboBox.addItem("--")
        self.filexy=["img/XY ++.png", "img/XY +-.png", "img/XY -+.png", "img/XY --.png"]
        self.filext=["img/XT ++.png", "img/XT +-.png", "img/XT -+.png", "img/XT --.png"]
        self.fileyt=["img/XT ++.png", "img/XT +-.png", "img/XT -+.png", "img/XT --.png"]
        #self.channelComboBox.activated.connect(self.parent.tabChange)

        _xsize=3
        _ysize=1.7
        # X-T
        # X-T 2d
        self.XTLabel = QtGui.QLabel("X - TOF Polarization Image")

        #self.XTImageCanvas = CSNSCanvas(self, _xsize, _ysize)
        self.canvas1 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent',
            'Monitor 1',
            'X /mm',
            'Y /mm',
            )
        
        _index=self.channelComboBox.currentIndex()
        self.dataxtX, self.dataxtY, self.dataxtZ = CSNSReadImage2Matrix(self.filext[_index], 1, 0.4)
        self.XTImage = self.canvas1.ax.pcolormesh(self.dataxtY, self.dataxtX, self.dataxtZ, cmap='hot')
        self.canvas1.draw()

        # X-T 1d
        self.reflectivityXTLabel = QtGui.QLabel("Reflectivity ")

        #self.reflectivityXTCanvas = CSNSCanvas(self, _xsize, _ysize)
        self.canvas2 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent',
            'Monitor 1',
            'X /mm',
            'Y /mm',
            )

        self.dataXTx=[]
        for i in range(1,self.dataxtY.shape[0]):
            self.dataXTx.append(self.dataxtY[0][i])
        self.dataXTy=[]
        for i in range(1,self.dataxtX.shape[0]):
            self.dataXTy.append(self.dataxtX[i][0])

        self.canvas2.ax.plot(self.dataXTx,self.dataxtZ[40][:],color='red')
        self.canvas2.draw()

        _nline = 0
        self.mainGrid.addWidget(self.channelComboBox, _nline,0,1,1)
        _nline += 1
        self.mainGrid.addWidget(self.XTLabel,         _nline,2,1,1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.canvas1,   _nline,0,1,5, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.reflectivityXTLabel,_nline,2,1,1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(self.canvas2, _nline,0,1,5)

        self.verticalLayout.addWidget(self.scrollArea)

        self.analysisSignal()
        
        self.pix1 = None
        self.pix2 = None

    def analysisSignal(self):
        self.channelComboBox.currentIndexChanged.connect(self.selectCombo)
        self.canvas1.mpl_connect('button_press_event',  self.changeReflectivityXT)
        #self.XYImageCanvas.mpl_connect('button_press_event',   self.zoomFigurePress)
        #self.XYImageCanvas.mpl_connect('button_release_event', self.zoomFigureRelease)
        #self.XYImageCanvas.mpl_connect('motion_notify_event',  self.zoomFigureMove)

    def changeReflectivityXT(self,event):
        if event.button==1:
            _y0 = event.ydata
            
            _iy=min(self.dataXTy, key=lambda x:abs(x-_y0))
            _iy=self.dataXTy.index(_iy)+2
            if _iy <0 or _iy>len(self.dataXTy):
                pass
            else:
                #self.canvas2.ax.set_ydata(self.dataxtZ[_iy][:])
                self.canvas2.ax.set_ylim( (min(self.dataxtZ[_iy][:]), max(self.dataxtZ[_iy][:])) )

                self.canvas2.draw()
        else:
            return
    
    def selectCombo(self, event):
        self.canvas1.ax.clear()
        self.canvas2.ax.clear()

        _index=self.channelComboBox.currentIndex()
        #self.dataxyX, self.dataxyY, self.dataxyZ = CSNSReadImage2Matrix(self.filexy[_index], 1, 1)

        self.dataxtX, self.dataxtY, self.dataxtZ = CSNSReadImage2Matrix(self.filext[_index], 1, 0.4)

        self.XTImage.set_array(self.dataxtZ.ravel())
        self.XTImage = self.canvas1.ax.pcolormesh(self.dataxtY, self.dataxtX, self.dataxtZ, cmap='hot')
        self.canvas1.draw()
        
        self.dataXTx=[]
        for i in range(1,self.dataxtY.shape[0]):
            self.dataXTx.append(self.dataxtY[0][i])
        self.dataXTy=[]
        for i in range(1,self.dataxtX.shape[0]):
            self.dataXTy.append(self.dataxtX[i][0])

        self.reflectivityXTFigure=self.canvas2.ax.plot(self.dataXTx,self.dataxtZ[40][:],color='red')

        self.canvas2.draw()

    def comboSelected(self):
        _index = self.channelComboBox.currentIndex()
        return _index

    def zoomFigurePress(self,event):
        if event.button==1:
            self.zoomClick=True
            self.x0 = event.xdata
            self.y0 = event.ydata
        elif event.button==3:
            self.canvas1.ax.autoscale(enable=True)
            self.canvas1.draw()
        else:
            return

    def zoomFigureMove(self, event):
        if event.button==1 and self.zoomClick==True and self.x0 and self.y0 and event.xdata and event.ydata:

            self.rect.set_width(event.xdata - self.x0)
            self.rect.set_height(event.ydata - self.y0)
            self.rect.set_xy((self.x0, self.y0))
            self.canvas1.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick=False

        if event.button==1 and self.x0 and self.y0 and event.xdata and event.ydata:
            self.x1 = event.xdata
            self.y1 = event.ydata

            self.rect.set_width(0)
            self.rect.set_height(0)

            _min=min(self.x0,self.x1)
            _max=max(self.x0,self.x1)
            self.canvas1.ax.set_xlim(_min, _max)
            _min=min(self.y0,self.y1)
            _max=max(self.y0,self.y1)
            self.canvas1.ax.set_ylim(_min, _max)
            self.canvas1.draw()
        else:
            return 

    def updateCanvas(self, value, started, _command):
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
        else:
            if not started:
                pass
            else:
                try:
                    if len(value[2]) == 0:
                        pass
                    else:
                        if not self.pix1:
                            self.canvas1.ax.clear()
                            self.pix1 = self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap='hot')
                            self.canvas1.ax.add_patch(self.canvas1.rect)
                        else:
                            self.pix1.set_array(np.array(value[2])[:-1,:-1].ravel())
                        if self.canvas1.zoomSelected and (self.canvas1.minX != self.canvas1.maxX) and (self.canvas1.minY != self.canvas1.maxY):
                            self.canvas1.ax.set_xlim(self.canvas1.minX, self.canvas1.maxX)   
                            self.canvas1.ax.set_ylim(self.canvas1.minY, self.canvas1.maxY)
                        self.canvas1.draw()
                except:
                    self.pix1 = None
                try:
                    if len(value[3]) != len(value[4]) or  len(value[4]) == 0:
                        pass
                    else:
                        if not self.pix2:
                            self.canvas2.ax.clear()
                            self.pix2, = self.canvas2.ax.plot(value[3], value[4], color='g')
                            self.canvas2.ax.add_patch(self.canvas2.rect)
                        else:
                            self.pix2.set_ydata(value[4])
                        if self.canvas2.zoomSelected and (self.canvas2.minX != self.canvas2.maxX) and (self.canvas2.minY != self.canvas2.maxY):
                            self.canvas2.ax.set_xlim(self.canvas2.minX, self.canvas2.maxX)   
                            self.canvas2.ax.set_ylim(self.canvas2.minY, self.canvas2.maxY)
                        self.canvas2.draw()
                except:
                    self.pix2 = None
