#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2017.05.11

Experiment

'''

from conf.constants import *

import time
import Queue
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from model import neutronCounts
from presenter.updateStreaming import *
from presenter.progressBarThread import *


class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSExperimentPage, self).__init__(parent)
        self.inQueue = Queue.Queue()
        self.outQueue = Queue.Queue()
        self.setupUi(self)
        self.minRange = 1
        self.maxRange = 60

        self.protonConstant = True
        self.neutronConstant = False
        self.pulseConstant = False

        self.middleProtonRange = 0
        self.middleNeutronRange = 0
        self.middlePluseRange = 0

    def __del__(self):

        # self.getThread.stop_event.set()
        # self.putThread.stop_event.set()

        pass

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 3
        _ysize = 0.5

        # Proton Charge
        self.protonRadio = QtGui.QRadioButton()
        self.protonRadio.setChecked(True)
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.protonCanvas = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'm',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Neutron Counts
        self.neutronRadio = QtGui.QRadioButton()
        self.neutronLabel = QtGui.QLabel('Neutron Counts:')

        self.neutronCanvas = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'r',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # pulse Counts
        self.pulseRadio = QtGui.QRadioButton()
        self.pulseLabel = QtGui.QLabel('Pulse Counts:')

        self.pulseCanvas = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'c',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.protonRadio)
        self.RadioGroup.addButton(self.neutronRadio)
        self.RadioGroup.addButton(self.pulseRadio)
        self.RadioGroup.buttonClicked.connect(self.RadioButtonChoose)

        _nline = 0
        self.mainGrid.addWidget(self.protonRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.protonCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.neutronRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.neutronLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.neutronCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.pulseRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.pulseLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.pulseCanvas, _nline, 2, 1, 1)

        self.verticalLayout.addWidget(self.scrollArea)

        # self.inQueue.join()
        self.beginTime = time.time()

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def RadioButtonChoose(self):
        pass

    def updateCanvas(self, value, started, _command):
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        else:
            if not started:
                pass
            else:
                try:
                    if len(value[0][0]) != len(value[0][1]) or len(value[0][1]) == 0:
                        pass
                    else:
                        if not self.pix1:
                            self.protonCanvas.ax.clear()
                            self.pix1, = self.protonCanvas.ax.plot(value[0][0], value[0][1], color=self.protonCanvas.plotColor)
                            self.protonCanvas.ax.add_patch(self.protonCanvas.rect)
                            self.protonCanvas.ax.set_xlabel('Time / ms')
                            self.protonCanvas.ax.set_ylabel('Intensity')
                        else:
                            self.pix1.set_xdata(value[0][0])
                            self.pix1.set_ydata(value[0][1])
                        if self.protonCanvas.zoomSelected  and (self.protonCanvas.minX != self.protonCanvas.maxX) and (self.protonCanvas.minY != self.protonCanvas.maxY):
                            self.protonCanvas.ax.set_xlim(self.protonCanvas.minX, self.protonCanvas.maxX)
                            self.protonCanvas.ax.set_ylim(self.protonCanvas.minY, self.protonCanvas.maxY)
                        self.protonCanvas.draw()
                except:
                    self.pix1 = None
                try:
                    if len(value[1][0]) != len(value[1][1]) or len(value[1][1]) == 0:
                        pass
                    else:
                        if not self.pix2:
                            self.neutronCanvas.ax.clear()
                            self.pix2, = self.neutronCanvas.ax.plot(value[1][0], value[1][1], color=self.neutronCanvas.plotColor)
                            self.neutronCanvas.ax.add_patch(self.neutronCanvas.rect)
                            self.neutronCanvas.ax.set_xlabel('Time / ms')
                            self.neutronCanvas.ax.set_ylabel('Intensity')
                        else:
                            self.pix2.set_xdata(value[1][0])
                            self.pix2.set_ydata(value[1][1])
                        if self.neutronCanvas.zoomSelected  and (self.neutronCanvas.minX != self.neutronCanvas.maxX) and (self.neutronCanvas.minY != self.neutronCanvas.maxY):
                            self.neutronCanvas.ax.set_xlim(self.neutronCanvas.minX, self.neutronCanvas.maxX)
                            self.neutronCanvas.ax.set_ylim(self.neutronCanvas.minY, self.neutronCanvas.maxY)
                        self.neutronCanvas.draw()
                except:
                    self.pix2 = None

                try:
                    if len(value[2][0]) != len(value[2][1]) or len(value[2][1]) == 0:
                        pass
                    else:
                        if not self.pix3:
                            self.pulseCanvas.ax.clear()
                            self.pix3, = self.pulseCanvas.ax.plot(value[2][0], value[2][1], color=self.pulseCanvas.plotColor)
                            self.pulseCanvas.ax.add_patch(self.pulseCanvas.rect)
                            self.pulseCanvas.ax.set_xlabel('Time / ms')
                            self.pulseCanvas.ax.set_ylabel('Intensity')
                        else:
                            self.pix3.set_xdata(value[2][0])
                            self.pix3.set_ydata(value[2][1])
                        if self.pulseCanvas.zoomSelected  and (self.pulseCanvas.minX != self.pulseCanvas.maxX) and (self.pulseCanvas.minY != self.pulseCanvas.maxY):
                            self.pulseCanvas.ax.set_xlim(self.pulseCanvas.minX, self.pulseCanvas.maxX)
                            self.pulseCanvas.ax.set_ylim(self.pulseCanvas.minY, self.pulseCanvas.maxY)
                        self.pulseCanvas.draw()
                except:
                    self.pix3 = None
