'''
Created on 2015.6.2
@author: yll
'''
# configure
from conf.constants import *
# user defined
#from model.readData import *
#from model.slitModel import *
#from presenter.slitSignal import *
from canvas import *

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,Widget):
        self.horizontalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        #for main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)
        
        ''' 
        self.mainCanvasFig = Figure((5,5), dpi=150, facecolor="white", edgecolor=None, linewidth=1.0, frameon=False, tight_layout=True)
        self.mainCanvasFig.subplots_adjust(left=0.0, bottom=0.05, right=0.95, top=0.95)
        self.mainCanvas = FigureCanvas(self.mainCanvasFig)
        #self.mainCanvas.setParent(self)
        self.mainCanvasAxes = []
        #for i in range(4):
        self.mainCanvasAxes1 = self.mainCanvasFig.add_subplot(4,1,4)
        self.mainCanvasAxes2 = self.mainCanvasFig.add_subplot(4,1,3)
        self.mainCanvasAxes3 = self.mainCanvasFig.add_subplot(4,1,2)
        self.mainCanvasAxes4 = self.mainCanvasFig.add_subplot(4,1,1)
        self.mainCanvasAxes.append(self.mainCanvasAxes1)
        self.mainCanvasAxes.append(self.mainCanvasAxes2)
        self.mainCanvasAxes.append(self.mainCanvasAxes3)
        self.mainCanvasAxes.append(self.mainCanvasAxes4)
        for i in range(4):
            self.mainCanvasAxes[i].tick_params(axis='y', left='off',labelleft='off')
            self.mainCanvasAxes[i].tick_params(axis='x', which='major',labelsize=5)
            #self.mainCanvasAxes[i].YAxis('off')
        self.mainCanvas.draw()
        '''

        self.canvas=[]
        _width=3.5
        for i in range(4):
            self.canvas.append(zoomCanvas(self,_width,_width,150,'Accent',' ','X / mm',''))
            self.canvas[i].ax.tick_params(axis='y', left='off',labelleft='off')
        '''
        self.sliderY=QtGui.QSlider(QtCore.Qt.Horizontal)
        self.sliderX=QtGui.QSlider(QtCore.Qt.Vertical)
         
        # parameter grid
        self.directBeamLabel =  QtGui.QLabel("<font color=red>Direct Beam:</font>")
        self.directBeamText=QtGui.QLabel("(25,50) ")

        self.reflectedBeamLabel =  QtGui.QLabel("<font color=red>Reflected Beam:</font>")
        self.reflectedBeamText=QtGui.QLabel("(64,50)")

        self.parameterWidget= QtGui.QWidget(self.first)
        self.parameterGrid = QtGui.QGridLayout(self.parameterWidget)
        '''
        _nline = 0
        for i in range(len(self.canvas)):
            self.mainGrid.addWidget(self.canvas[3-i],_nline,0,1,1)
            _nline += 1
        #self.mainGrid.addWidget(self.sliderX,_nline,1,1,1, QtCore.Qt.AlignLeft)
        #_nline += 1
        #self.mainGrid.addWidget(self.sliderY,_nline,0,1,1, QtCore.Qt.AlignTop)
        #_nline += 1
        #self.mainGrid.addWidget(self.parameterWidget,_nline,0,1,1, QtCore.Qt.AlignLeft)

        self.mainGrid.columnStretch(1)
        '''
        _nline += 1
        self.parameterGrid.addWidget(self.directBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.directBeamText,_nline,1,1,1)
        _nline += 1
        self.parameterGrid.addWidget(self.reflectedBeamLabel,_nline,0,1,1)
        self.parameterGrid.addWidget(self.reflectedBeamText,_nline,1,1,1)
        '''
        self.horizontalLayout.addWidget(self.scrollArea)

        self.value = None
        self.xdata=0
        self.ydata=0
        self.mouseClicked = False

        self.colorbar = []
        self.pix=[]
        for i in range(len(self.canvas)):
            self.colorbar.append('')
            self.pix.append('')

    def updateCanvas(self, value, started, _command):
        if _command in ('configure', 'abort'):
            self.pix=[]
            for i in range(len(self.canvas)):
                self.pix.append('')
        else:
            if not started:
                pass
            else:
                #color2D = 'r'
                color3D = ['rainbow','rainbow','rainbow','rainbow']
                try:
                    for i in range(len(self.canvas)):
                        if len(value[2][i]) == 0:
                            pass
                        else:
                            if not self.pix[i]:
                                try:
                                    self.canvas[i].ax.clear()
                                    self.pix[i]=self.canvas[i].ax.pcolormesh(value[0][i],value[1][i],value[2][i], cmap=color3D[i])
                                    self.canvas[i].ax.add_patch(self.canvas[i].rect)
                                    self.canvas[i].ax.xaxis.set_major_locator(matplotlib.ticker.MultipleLocator(10))
                                except:
                                    self.pix[i] = None
                            else:
                                self.pix[i].set_array(np.array(value[2][i])[:-1,:-1].ravel())
                            if self.canvas[i].zoomSelected and (self.canvas[i].minX != self.canvas[i].maxX) and (self.canvas[i].minY != self.canvas[i].maxY):
                                self.canvas[i].ax.set_xlim(self.canvas[i].minX, self.canvas[i].maxX)   
                                self.canvas[i].ax.set_ylim(self.canvas[i].minY, self.canvas[i].maxY)    
                            self.canvas[0].ax.set_xlabel('X / mm',fontsize=5)
                            self.canvas[i].draw()
                            if not self.colorbar[i]:
                                self.colorbar[i]=self.canvas[i].fig.colorbar(self.pix[i],ax=self.canvas[i].ax,extend='max')
                                self.colorbar[i].ax.tick_params(labelsize=5)
                            else:
                                self.colorbar[i].on_mappable_changed(self.pix[i])
                except:
                    pass
