#from PyQt4 import QtGui, QtCore
from pyface.qt import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy

class getCommand(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    signalLog = QtCore.pyqtSignal(str)
 
    def __init__(self, parent, neonServer, commandPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.commandPath = commandPath
        self.refreshTime = refreshTime
        self.command=True
        self.commandLog = 0
    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                _command = self.neonServer.get(self.commandPath)
                if _command is None:
                    if self.commandLog == 0:
                        self.signalLog.emit("Empty command Data from NEON!")
                        self.commandLog += 1
                else:
                    try:
                        _command = str(json.loads(_command))
                        self.signalStatus.emit(_command)
                        self.commandLog = 0
                    except:
                        pass
            except:
                pass
            try: 
                time.sleep(self.refreshTime) 
            except:
                pass
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(str)
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object,object)
    signalTime = QtCore.pyqtSignal(object,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, progressPath, protonPath, neutronPath, pulsePath, startPath, endPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        self.neutronPath = neutronPath
        self.pulsePath = pulsePath
        self.startPath = startPath
        self.endPath = endPath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/MR/workspace/MantidData/monitor1/tof'
        self.monitorCountsPath = '/MR/workspace/MantidData/monitor1/counts'
        self.monitorTOF=[]

        self.pidXaxis=[]
        self.xyXaxis=[]
        self.xyYaxis=[]
        for i in range(6):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])
        self.gisansX = []
        self.gisansY = []
        self.gisansZ = []
        
        self.progressLog = 0
        self.monitorTOFLog = 0
        self.monitorCountsLog = 0 
        self.reflectionLog = 0 
        self.detectorLog = 0
        self.monitorLog = 0
        self.gisansLog = 0 
        self.expeLog = 0

    def __del__(self):
        self.wait()

    def pause(self):
        self.started=False

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):
        # progress setting in mainSet
        try:
            #get json date after json.dumps from neon
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                if self.progressLog == 0:
                    self.signalLog.emit("Empty progressBar Setting Data!")
                    self.progressLog += 1
            else:
                try:
                    self.signalProgress.emit(progress)
                    self.progressLog = 0
                except:
                    pass
        except:
            pass 

        # Monitor TOF in User Panel 
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
            if _data is None:
                if self.monitorTOFLog == 0:
                    self.signalLog.emit("Empty Monitor TOF Data!")
                    self.monitorTOFLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.monitorTOF=_data
                    self.monitorTOFLog = 0
                except:
                    if self.monitorTOFLog < 2:
                        self.signalLog.emit("Incompleted Monitor TOF Data")
                        self.monitorTOFLog += 1
        except:
            pass

        while True:
            _data = None
            _started = self.get()
            if not _started:
                try:
                    time.sleep(3)
                except:
                    pass
                continue 
            # Monitor Counts in User Panel 
            try:
                _data = self.neonServer.get(self.monitorCountsPath)
            except:
                pass
            if _data is None :
                if self.monitorCountsLog == 0:
                    self.signalLog.emit("Empty Monitor Counts Data!")
                    self.monitorCountsLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.signalMonitor.emit(_data)
                    self.monitorCountsLog = 0
                except:
                    if self.monitorCountsLog < 2:
                        self.signalLog.emit("Incompleted Monitor Counts Data")
                        self.monitorCountsLog += 1
            
            # get Proton Charge and Neutron Counts in User
            _proton = None
            _neutron = None
            try:
                _proton = self.neonServer.get(self.protonPath)
                _neutron = self.neonServer.get(self.neutronPath)
            except:
                pass
            if _proton is None:
                _proton = '---'
            else:
                try:
                    _proton = jsonArray.jsonDecoder(_proton)
                    self.protonLog = 0
                except:
                    _proton = '---'
            if _neutron is None:
                _neutron = '---'
            else:
                try:
                    _neutron = jsonArray.jsonDecoder(_neutron)
                    self.neurtonLog = 0
                except:
                    _neutron = '---'
            try:
                self.signalExperiment.emit(_proton[1][-1],  _neutron[1][-1])
            except:
                pass
            #get start and end time for user
            try:
                _start = self.neonServer.get(self.startPath)
                _end = self.neonServer.get(self.endPath)
            except:
                pass
            if _start is None :
                _start = '-----'
            else:
                _start = jsonArray.jsonDecoder(_start)
            if _end is None :
                _end = '-----'
            else:
                _end = jsonArray.jsonDecoder(_end)
            try:
                self.signalTime.emit(_start, _end)
            except:
                pass
            # get Tab index
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            # Reflection page
            if self.tabIndex == 0:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                try:
                    for i in range(len(self.kwargs)-1):
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                        if _data is None:
                            if self.reflectionLog == 0:
                                self.signalLog.emit("Empty Reflection Canvas Data!")
                                self.reflectionLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                            except:
                                if self.reflectionLog < 2:
                                    self.signalLog.emit("Incompleted Reflection Canvas data")
                                    self.reflectionLog += 1
                        value[i] = _data
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # roi page
            elif self.tabIndex == 1:
                value = []
                for _ini in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    _array = []
                    for _tube in range(len(self.kwargs['path1'])):
                        _array.append([])
                    for j in range(len(self.kwargs['path1'])):
                        try:
                            _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                        except:
                            pass
                        if _data is None:
                            if self.detectorLog == 0:
                                self.signalLog.emit("Empty Detector Canvas Data!")
                                self.detectorLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                self.detectorLog = 0
                            except:
                                if self.detectorLog < 2:
                                    self.signalLog.emit("Incompleted Detector Canvas data")
                                    self.detectorLog += 1
                            _array[j] = _data
                    value[i] = _array
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Detector page
            elif self.tabIndex == 2:
                value = []
                for _ini in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    _array = []
                    for _tube in range(len(self.kwargs['path1'])):
                        _array.append([])
                    for j in range(len(self.kwargs['path1'])):
                        try:
                            _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                        except:
                            pass
                        if _data is None:
                            if self.detectorLog == 0:
                                self.signalLog.emit("Empty Detector Canvas Data!")
                                self.detectorLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                self.detectorLog = 0
                            except:
                                if self.detectorLog < 2:
                                    self.signalLog.emit("Incompleted Detector Canvas data")
                                    self.detectorLog += 1
                            _array[j] = _data
                    value[i] = _array
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Monitor page
            elif self.tabIndex == 3:
                value = []
                _pause = []
                try:
                    _pause = self.kwargs['status']
                except:
                    pass
                for _ini in range(len(self.kwargs)-2):
                    value.append([])
                for i in range(len(self.kwargs)-2):
                    _array = []
                    for key in range(len(self.kwargs['path1'])):
                        _array.append([])
                    try:
                        for j in range(len(self.kwargs['path1'])):
                            if _pause[j]=='Pause':
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                                if _data is None:
                                    if self.monitorLog == 0:
                                        self.signalLog.emit("Empty Canvas Data!")
                                        self.monitorLog += 1
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        _array[j] = _data
                                    except:
                                        if self.monitorLog < 2:
                                            self.signalLog.emit("Incompleted Canvas data")
                                            self.monitorLog += 1
                            else:
                                pass
                        value[i]=_array
                    except:
                        pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Polarization page
            elif self.tabIndex == 4:
                pass
            # Gisans page
            elif self.tabIndex == 5:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                for i in range(len(self.kwargs)-1):
                    try:
                        if len(self.gisansX)==0:
                            _json=self.neonServer.get(self.kwargs['path1'])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.gisansX=_array
                        if len(self.gisansY)==0:
                            _json=self.neonServer.get(self.kwargs['path2'])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.gisansY=_array
                        if len(self.gisansZ)==0:
                            _json=self.neonServer.get(self.kwargs['path3'])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.gisansZ=_array
                    except:
                        pass
                    if i == 0:
                        value[i] = self.gisansX
                    elif i == 1:
                        value[i] = self.gisansY
                    elif i == 2:
                        value[i] = self.gisansZ
                    else:
                        try:
                            _data = self.neonServer.get(self.kwargs['path4'])
                            if _data is None:
                                if self.gisansLog == 0:
                                    self.signalLog.emit("Empty Gisans Canvas Data!")
                                    self.gisansLog += 1
                            else:
                                try:
                                    _data = jsonArray.jsonDecoder(_data)
                                    value[i] = _data
                                    self.gisansLog = 0
                                except:
                                    if self.gisansLog < 2:
                                        self.signalLog.emit("Incompleted Gisans Canvas data")
                                        self.gisansLog += 1
                        except:
                            pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Experiment page
            elif self.tabIndex == 6:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                try:
                    for i in range(len(self.kwargs)-1):
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                        if _data is None:
                            if self.expeLog == 0:
                                self.signalLog.emit("Empty Experiment Canvas Data!")
                                self.expeLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                            except:
                                if self.expeLog < 2:
                                    self.signalLog.emit("Incompleted Experiment Canvas data")
                                    self.expeLog += 1
                        value[i] = _data
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()

