#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2017.05.11

Experiment

'''

from conf.constants import *

import time
import Queue
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from model import neutronCounts
from presenter.updateStreaming import *
from presenter.progressBarThread import *


class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSExperimentPage, self).__init__(parent)
        self.inQueue = Queue.Queue()
        self.outQueue = Queue.Queue()
        self.setupUi(self)
        self.minRange = 1
        self.maxRange = 60

        self.protonConstant = True
        self.neutronConstant = False
        self.pulseConstant = False

        self.middleProtonRange = 0
        self.middleNeutronRange = 0
        self.middlePluseRange = 0

    def __del__(self):

        # self.getThread.stop_event.set()
        # self.putThread.stop_event.set()

        pass

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 3
        _ysize = 0.5

        # Proton Charge

        self.protonRadio = QtGui.QRadioButton()
        self.protonRadio.setChecked(True)
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.canvas1 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'm',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Neutron Counts

        self.neutronRadio = QtGui.QRadioButton()
        self.neutronLabel = QtGui.QLabel('Neutron Counts:')

        self.canvas2 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'r',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # pulse Counts

        self.pulseRadio = QtGui.QRadioButton()
        self.pulseLabel = QtGui.QLabel('Pulse Counts:')

        self.canvas3 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'c',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.protonRadio)
        self.RadioGroup.addButton(self.neutronRadio)
        self.RadioGroup.addButton(self.pulseRadio)
        self.RadioGroup.buttonClicked.connect(self.RadioButtonChoose)

        _nline = 0
        self.mainGrid.addWidget(self.protonRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.canvas1, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.neutronRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.neutronLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.canvas2, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.pulseRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.pulseLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.canvas3, _nline, 2, 1, 1)

        self.verticalLayout.addWidget(self.scrollArea)

        # self.inQueue.join()

        self.beginTime = time.time()

        self.pix1 = None
        self.pix2 = None
        self.pix3 = None

    def RadioButtonChoose(self):
        pass

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()
        self.canvas3.ax.clear()
        self.canvas3.draw()

    def updateCanvas(
        self,
        value,
        started,
        _command,
        ):
        if _command in ('configure', 'abort'):
            self.pix1 = None
            self.pix2 = None
            self.pix3 = None
        #elif not started:
        #    pass
        #else:
        try:
            if str(value[0][0]) == 'clear' or str(value[0][1]) == 'clear':
                self.canvas1.ax.clear()
                self.canvas1.draw()
            elif len(value[0][0]) != len(value[0][1]) \
                or len(value[0][1]) == 0:
                pass
            else:
                #if not self.pix1:
                self.canvas1.ax.clear()
                #(self.pix1, ) = \
                self.canvas1.ax.plot(value[0][0],
                        value[0][1],
                        color=self.canvas1.plotColor)
                self.canvas1.ax.add_patch(self.canvas1.rect)
                self.canvas1.ax.set_xlabel('Time / ms')
                self.canvas1.ax.set_ylabel('Intensity')
                #else:
                #    self.pix1.set_xdata(value[0][0])
                #    self.pix1.set_ydata(value[0][1])
                if self.canvas1.zoomSelected \
                    and self.canvas1.minX \
                    != self.canvas1.maxX \
                    and self.canvas1.minY \
                    != self.canvas1.maxY:
                    self.canvas1.ax.set_xlim(self.canvas1.minX,
                            self.canvas1.maxX)
                    self.canvas1.ax.set_ylim(self.canvas1.minY,
                            self.canvas1.maxY)
                elif self.canvas1.scale_factor != 1.0:
                    self.canvas1.ax.set_xlim([self.canvas1.xdata - self.canvas1.new_width * (1-self.canvas1.relx), self.canvas1.xdata + self.canvas1.new_width * (self.canvas1.relx)])
                    self.canvas1.ax.set_ylim([self.canvas1.ydata - self.canvas1.new_height * (1-self.canvas1.rely), self.canvas1.ydata + self.canvas1.new_height * (self.canvas1.rely)])

                self.canvas1.ax.relim()
                self.canvas1.ax.autoscale_view()
                self.canvas1.draw()
        except:
            pass
            #self.pix1 = None
        try:
            if str(value[1][0]) == 'clear' or str(value[1][1]) == 'clear':
                self.canvas2.ax.clear()
                self.canvas2.draw()
            elif len(value[1][0]) != len(value[1][1]) \
                or len(value[1][1]) == 0:
                pass
            else:
                #y = []
                #for i in range(len(value[1][3])):
                #    y.append('')
                #for i in range(len(value[1][3])):
                #    y[i] = value[1][1][i]+value[1][2][i]+value[1][3][i]+value[1][4][i]
                #if not self.pix2:
                self.canvas2.ax.clear()
                #(self.pix2, ) = \
                self.canvas2.ax.plot(value[1][0], value[1][1],
                        color=self.canvas2.plotColor)
                self.canvas2.ax.add_patch(self.canvas2.rect)
                self.canvas2.ax.set_xlabel('Time / ms'
                        )
                self.canvas2.ax.set_ylabel('Intensity'
                        )
                #else:
                #    self.pix2.set_xdata(value[1][0])
                #    self.pix2.set_ydata(value[1][1])
                if self.canvas2.zoomSelected \
                    and self.canvas2.minX \
                    != self.canvas2.maxX \
                    and self.canvas2.minY \
                    != self.canvas2.maxY:
                    self.canvas2.ax.set_xlim(self.canvas2.minX,
                            self.canvas2.maxX)
                    self.canvas2.ax.set_ylim(self.canvas2.minY,
                            self.canvas2.maxY)
                elif self.canvas2.scale_factor != 1.0:
                    self.canvas2.ax.set_xlim([self.canvas2.xdata - self.canvas2.new_width * (1-self.canvas2.relx), self.canvas2.xdata + self.canvas2.new_width * (self.canvas2.relx)])
                    self.canvas2.ax.set_ylim([self.canvas2.ydata - self.canvas2.new_height * (1-self.canvas2.rely), self.canvas2.ydata + self.canvas2.new_height * (self.canvas2.rely)])

                self.canvas2.ax.relim()
                self.canvas2.ax.autoscale_view()
                self.canvas2.draw()
        except:
            pass
            #self.pix2 = None

        try:
            if str(value[2][0]) == 'clear' or str(value[2][1]) == 'clear':
                self.canvas3.ax.clear()
                self.canvas3.draw()
            elif len(value[2][0]) != len(value[2][1]) \
                or len(value[2][1]) == 0:
                pass
            else:
                #if not self.pix3:
                self.canvas3.ax.clear()
                (self.pix3, ) = \
                    self.canvas3.ax.plot(value[2][0],
                        value[2][1],
                        color=self.canvas3.plotColor)
                self.canvas3.ax.add_patch(self.canvas3.rect)
                self.canvas3.ax.set_xlabel('Time / ms')
                self.canvas3.ax.set_ylabel('Intensity')
                #else:
                #    self.pix3.set_xdata(value[2][0])
                #    self.pix3.set_ydata(value[2][1])
                if self.canvas3.zoomSelected \
                    and self.canvas3.minX \
                    != self.canvas3.maxX \
                    and self.canvas3.minY \
                    != self.canvas3.maxY:
                    self.canvas3.ax.set_xlim(self.canvas3.minX,
                            self.canvas3.maxX)
                    self.canvas3.ax.set_ylim(self.canvas3.minY,
                            self.canvas3.maxY)
                elif self.canvas3.scale_factor != 1.0:
                    self.canvas3.ax.set_xlim([self.canvas3.xdata - self.canvas3.new_width * (1-self.canvas3.relx), self.canvas3.xdata + self.canvas3.new_width * (self.canvas3.relx)])
                    self.canvas3.ax.set_ylim([self.canvas3.ydata - self.canvas3.new_height * (1-self.canvas3.rely), self.canvas3.ydata + self.canvas3.new_height * (self.canvas3.rely)])

                self.canvas3.ax.relim()
                self.canvas3.ax.autoscale_view()
                self.canvas3.draw()
        except:
            pass
            #self.pix3 = None
