import os
import time
import glob
#import fnmatch
import sqlite3
import re
import xml.etree.ElementTree as ET
import sys
#from lxml import etree
import json
import ssl
import urllib
import urllib2
import subprocess

ssl._create_default_https_context = ssl._create_unverified_context

CTRLpath="/opt/CSNSDATA/TS1/BL02/Control/"
DAQpath="/opt/CSNSDATA/TS1/BL02/DAQ/"
MONHpath="/opt/CSNSDATA/TS1/BL02/Monitor/Histogram/"
MONEpath="/opt/CSNSDATA/TS1/BL02/Monitor/Event/"
Nexuspath="/home/transfer/nexus/CSNSDATA/TS1/BL02/"
softwarePath="/home/transfer/xml/CSNSDATA/TS1/BL02/"

rodsbackup="/csnsZone/home/rods"
rodsworkspace="/csnsZone/home/public"

global icatTime
global sessionId, facilityId, investigationId

global BLname, BLfullname
BLname="tzhu"
BLfullname="Tao Zhu"

dmurl="https://dm.csns.ihep.ac.cn:8181"
#=========================================================================================
def getSessionId():
    url=dmurl+"/icat/session"
    header={'content-type': 'application/x-www-form-urlencoded'}
    body = {'json': '{"plugin":"db", "credentials":[{"username":"dataingestor"}, {"password":"sanlie_123"}]}'}
    data = urllib.urlencode(body)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()
    sessionId=json.loads(_tmp)["sessionId"]
    return sessionId

def getFacilityId(sessionId):
    body="SELECT f.id FROM Facility f WHERE f.name='CSNS'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()
    _tmp=json.loads(_tmp)
    return _tmp[0]

def getInstrumentId(sessionId, name="BL02"):
    if name=="BL01":
        nickname="SANS"
    elif name=="BL02":
        nickname="RM"
    elif name=="BL02":
        nickname="GPPD"
    else:
        pass

    body="SELECT f FROM Instrument f WHERE f.facility.name='CSNS'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()
    
    _tmp=json.loads(_tmp)

    _ins=[]
    for f in _tmp:
        _ins.append(f['Instrument'])

    for f in _ins:
        if f['name']==name or f['name']==nickname:
            _id=f['id']
            break
    return _id

def setUser(sessionId, name, fullname):
    name="ldap/"+name

    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    body={}
    body['sessionId']=sessionId
    _user='[{"User":{"name":"'+name+'","fullName":"'+fullname+'"'+'}}]'
    body['entities']=_user
    
    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    # entry id list
    return  _tmp

def getUserId(sessionId, name):
    body ="SELECT f FROM User f where f.name="+"'"+name+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['User']['id']

def getInvestigationTypeId(sessionId, name="commissioning"):
    body = "SELECT f FROM InvestigationType f WHERE f.facility.name='CSNS' and f.name="+"'"+name+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['InvestigationType']['id']

def getInvestigationId(sessionId, investigationName, visitName):
    body="SELECT f FROM Investigation f WHERE f.facility.name='CSNS' and f.name="+"'"+investigationName+"' and f.visitId="+"'"+visitName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['Investigation']['id']

def setSample(sessionId, investigationId, sampleTypeId, sampleName="unknown"):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Sample":{"type":{"id":sampleTypeId},"investigation":{"id":investigationId},"name":"sampleName"}}]'

    entities =re.sub('sampleTypeId', str(sampleTypeId), entities)
    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('sampleName', sampleName, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]


def setSampleType(sessionId, facilityId, sampleTypeName="unknown", molecularFormula="unknown"):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"SampleType":{"facility":{"id":facilityId},"molecularFormula":"molecularFormulaName","name":"sampleTypeName"}}]'
    
    entities =re.sub('facilityId', str(facilityId), entities)
    entities =re.sub('molecularFormulaName', molecularFormula, entities)
    entities =re.sub('sampleTypeName', sampleTypeName, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def getSampleTypeId(sessionId, sampleTypeName):
    body = "SELECT f FROM SampleType f WHERE f.facility.name='CSNS' and f.name="+"'"+sampleTypeName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['SampleType']['id']

def getSampleId(sessionId, investigationId, sampleName):
    body = "SELECT f FROM Sample f WHERE f.investigation.id="+investigationId+" and f.name="+"'"+sampleName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data

    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['Sample']['id']

def setParameterType(sessionId, facilityId, paraname, paraunit):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"ParameterType":{"facility":{"id":facilityId},"applicableToDataCollection":true,"applicableToDatafile":true,"applicableToDataset":true,"applicableToInvestigation":true, "applicableToSample":true,"name":"paraname","units":"paraunit","valueType":"NUMERIC"}}]'
    entities =re.sub('facilityId', str(facilityId), entities)
    entities =re.sub('paraname', paraname, entities)
    entities =re.sub('paraunit', paraunit, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def getParameterTypeId(sessionId, name, units):
    body = "SELECT f FROM ParameterType f WHERE f.facility.name='CSNS' and f.name="+"'"+name+"' and f.units="+"'"+units+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['ParameterType']['id']

def getDatasetTypeId(sessionId, name):
    body = "SELECT f FROM DatasetType f WHERE f.facility.name='CSNS' and f.name="+"'"+name+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['DatasetType']['id']

def getDatasetId(sessionId, investigationId, datasetName):
    datasetName='__csns__'+datasetName
    body = "SELECT f FROM Dataset f WHERE f.investigation.id="+investigationId+" and f.name="+"'"+datasetName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['Dataset']['id']

def setInvestigation(sessionId, facilityId, investigationTypeId,investigationName, titleName, visitName):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Investigation":{"facility":{"id":facilityId},"type":{"id":investigationTypeId},"name":"investigationName", "title":"titleName","visitId":"visitName"}}]'
    entities =re.sub('facilityId', str(facilityId), entities)
    entities =re.sub('investigationTypeId', str(investigationTypeId), entities)
    entities =re.sub('investigationName', str(investigationName), entities)
    entities =re.sub('titleName', titleName, entities)
    entities =re.sub('visitName', visitName, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setInvestigationUser(sessionId, investigationId, userId):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"InvestigationUser":{"investigation":{"id":investigationId},"user":{"id":userId},"role":"primary"}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('userId', str(userId), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setInvestigationSample(sessionId, investigationId, sampleTypeId, sampleName):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Sample":{"type":{"id":sampleTypeId},"investigation":{"id":investigationId},"name":"sampleName"}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('sampleTypeId', str(sampleTypeId), entities)
    entities =re.sub('sampleName', str(sampleName), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]


def setInvestigationInstrument(sessionId, investigationId, instrumentId):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"InvestigationInstrument":{"investigation":{"id":investigationId},"instrument":{"id":instrumentId}}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('instrumentId', str(instrumentId), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setDataset(sessionId, investigationId, datasetTypeId, sampleId, datasetName, dataLocation, startDatetime, endDatetime, dataDescription):
    datasetName="__csns__"+datasetName
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    if startDatetime=="unknown" or endDatetime=="unknown":
        entities='[{"Dataset":{"investigation":{"id":investigationId},"sample":{"id":sampleId},"type":{"id":datasetTypeId},"complete":true,"location":"dataLocation", "name":"datasetName","description":"dataDescription"}}]'
    else:
        entities='[{"Dataset":{"investigation":{"id":investigationId},"sample":{"id":sampleId},"type":{"id":datasetTypeId},"complete":true,"location":"dataLocation", "name":"datasetName","startDate":"startDatetime","endDate":"endDatetime","description":"dataDescription"}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('datasetTypeId', str(datasetTypeId), entities)
    entities =re.sub('sampleId', str(sampleId), entities)
    entities =re.sub('datasetName', str(datasetName), entities)
    entities =re.sub('dataLocation', str(dataLocation), entities)
    entities =re.sub('startDatetime', str(startDatetime), entities)
    entities =re.sub('endDatetime', str(endDatetime), entities)
    entities =re.sub('dataDescription', str(dataDescription), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)

    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def getDatafileFormatId(sessionId, datafileFormatName, datafileFormatVersion):
    body="SELECT f FROM DatafileFormat f WHERE f.facility.name='CSNS' and f.name="+"'"+datafileFormatName+"' and f.version="+"'"+datafileFormatVersion+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['DatafileFormat']['id']

def setDatasetParameter(sessionId, datasetId, parameterTypeId, paraValue):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"DatasetParameter":{"dataset":{"id":datasetId},"type":{"id":parameterTypeId},"stringValue":"paraValue"}}]'
    
    entities =re.sub('datasetId', str(datasetId), entities)
    entities =re.sub('parameterTypeId', str(parameterTypeId), entities)
    entities =re.sub('paraValue', paraValue, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setDatafile(sessionId, datasetId, datafileFormatId, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Datafile":{"dataset":{"id":datasetId},"datafileFormat":{"id":datafileFormatId},"datafileCreateTime":"dataCreateTime","description":"dataDescription","fileSize":dataSize,"location":"dataLocation","name":"datafileName"}}]'

    entities =re.sub('datasetId', str(datasetId), entities)
    entities =re.sub('datafileFormatId', str(datafileFormatId), entities)
    entities =re.sub('datafileName', str(datafileName), entities)
    entities =re.sub('dataCreateTime', str(dataCreateTime), entities)
    entities =re.sub('dataDescription', str(dataDescription), entities)
    entities =re.sub('dataSize', str(dataSize), entities)
    entities =re.sub('dataLocation', str(dataLocation), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

#=========================================================================================

def getCreationDate(_file):
    stat = os.stat(_file)
    try:
        _tmp=stat.st_birthtime
    except AttributeError:
        _tmp=stat.st_ctime
        #_tmp=stat.st_mtime

    #return time.strftime('%Y-%m-%dT%H:%M:%S%z', time.localtime(int(_tmp)))
    return time.strftime('%Y-%m-%dT%H:%M:%S.000+08:00', time.localtime(int(_tmp)))

def getFileSize(_file):
    #unit: byte
    #return os.path.getsize(_file)
    return int(os.stat(_file).st_size)

def getFileName(_file):
    return os.path.basename(_file)
#=========================================================================================

def getRunNoList(dir='.'):
    pattern="^RUN[0-9]{7}"
    runNo=[]

    for dirpath, dirnames, files in os.walk(dir):
        for dirname in dirnames:
            if re.match(pattern, dirname):
                runNo.append(int(dirname[3:]))
    
    runNo.sort()           
    
    return runNo

def getControlPath(runNo):
    return CTRLpath+"RUN"+str(runNo).zfill(7)+"/"

def getDetectorPath(runNo):
    _tmp1=DAQpath+"RUN"+str(runNo).zfill(7)+"/"
    _tmp2=DAQpath+"RUN"+str(runNo)+"/"
    if os.path.exists(_tmp1):
        _file=_tmp1
    else:
        if os.path.exists(_tmp2):
            _file=_tmp2
        else:
            _file= None

    return _file

def getDetectorFiles(runNo):
    _path=getDetectorPath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.xml")
        _file2=glob.glob(_path+"*.dat")
        _files=_file1 + _file2
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Detector/"+_filename
        _dataDescription="detector-raw"
        _datafileFormatName="raw_detector"    
        #for test
        #_datafileFormatName="dat"    
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def getDAQFileList(runNo):
    #ns={'d': 'http://csns.ihep.ac.cn/xml/ns/descriptor'}
    path=getDetectorPath(runNo)

    try:
        _file = glob.glob(path+"CSNS-TS1-BL02-DAQ-summary-*.xml")
        _file=_file[-1]
    except:
        return

    with open(_file) as f:
        xmlstring = f.read()
    
    if 'descriptor' in xmlstring: 
        #xmlstring=re.sub(' xmlns="[^"]+"', '', xmlstring, count=1)
        xmlstring=re.sub('\<daqDescriptor.+', '<root>', xmlstring)
        xmlstring=re.sub('\<\/daqDescriptor\>', '</root>', xmlstring, count=1)
    else:
        xmlstring = re.sub('\<\?xml version="1.0" encoding="UTF-8"\?\>', '<?xml version="1.0" encoding="UTF-8"?>\n <root>', xmlstring)
        xmlstring +="</root>"

    _files=[]

    try:
        root = ET.fromstring(xmlstring)
        _modules=root.findall("module")
        for a in _modules:
            #print a.attrib['id']
            _child=a.getchildren()[0].find(".//file")
            for _f in _child:
                _files.append(_f.text)
    except:
        pass

    return _files

def getDetectorSummaryFile(runNo):
    path=getDetectorPath(runNo)

    try:
        _file = glob.glob(path+"CSNS-TS1-BL02-DAQ-summary-*.xml")
        _file=_file[-1]
    except:
        _file=None

    return _file

def getDetectorData(runNo):
    path=getDetectorPath(runNo)

    try:
        _file = glob.glob(path+"BL02*.dat")
    except:
        _file=None

    return _file

def hasDetectorPath(runNo):
    _tmp1=DAQpath+"RUN"+str(runNo).zfill(7)+"/"
    _tmp2=DAQpath+"RUN"+str(runNo)+"/"
    if os.path.exists(_tmp1):
        _result=True
    else:
        if os.path.exists(_tmp2):
            _result=True
        else:
            _result= False

    return _result

def hasNexusPath(runNo):
    _tmp=Nexuspath+getRunString(runNo)+"/"
    if os.path.exists(_tmp):
        _result=True
    else:
        _result= False

    return _result

def getMONhisPath(runNo):
    _path="/opt/CSNSDATA/TS1/BL02/Monitor/Histogram/"
    _tmp=_path+"RUN"+str(runNo).zfill(7)+"/"
    if os.path.exists(_tmp):
        _file=_tmp
    else:
        _file=None
    return _file

def hasMonitorHisPath(runNo):
    _path="/opt/CSNSDATA/TS1/BL02/Monitor/Histogram/"+"RUN"+str(runNo).zfill(7)+"/"

    if os.path.exists(_path):
        _result=True
    else:
        _result=False
    
    return _result

def getMonitorhisFiles(runNo):
    _path=getMONhisPath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.bin")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Monitor"+str(i)+"/Histogram/"+_filename
        _dataDescription="monitor-histogram"
        _datafileFormatName="raw_monitor"
        # for test
        #_datafileFormatName="dat"
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def getMONhisFiles(runNo):
    _path=getMONhisPath(runNo)
    try:
        _file = glob.glob(_path+"BL02*.bin")
    except:
        _file=None

    return _file

def getMONevtPath(runNo):
    _path="/opt/CSNSDATA/TS1/BL02/Monitor/Event/"
    _tmp=_path+"RUN"+str(runNo).zfill(7)+"/"
    if os.path.exists(_tmp):
        _file=_tmp
    else:
        _file=None

    return _file

def hasMonitorEvtPath(runNo):
    _path="/opt/CSNSDATA/TS1/BL02/Monitor/Event/"+"RUN"+str(runNo).zfill(7)+"/"

    if os.path.exists(_path):
        _result=True
    else:
        _result=False

    return _result

def getMonitorevtFiles(runNo):
    _path=getMONevtPath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.h5")
        #_file2=glob.glob(_path+"*.bin")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Monitor"+str(i)+"/Event/"+_filename
        _dataDescription="monitor-nexus"
        _datafileFormatName="nexus_monitor"
        # for test
        #_datafileFormatName="dat"
 
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def getNexusPath(runNo):
    runString=getRunString(runNo)
    return "/home/transfer/nexus/CSNSDATA/TS1/BL02/"+runString+"/"

def getSoftwarePath(runNo):
    runString=getRunString(runNo)
    return "/home/transfer/xml/CSNSDATA/TS1/BL02/"+runString+"/"

def getNexusFiles(runNo):
    _path=getNexusPath(runNo)
    
    _files=[]
    try:
        _file1=glob.glob(_path+"*.nxs")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/nexus/CSNS/TS1/BL02/" +getRunString(runNo)+"/"+_filename
        _dataDescription="nexus"
        _datafileFormatName="nexus"
        # for test
        #_datafileFormatName="nxs"
    
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    
    return filelist

def getSoftwareFiles(runNo):
    _path=getSoftwarePath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.xml")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL02/" +getRunString(runNo)+"/Software/"+_filename
        _dataDescription="software summary"
        _datafileFormatName="software_summary"
        # for test
        #_datafileFormatName="xml"

        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])

    return filelist

def getMONevtFiles(runNo, i):
    _path=getMONevtPath(runNo, i)
    try:
        _file = glob.glob(_path+"BL02*.h5")
    except:
        _file=None

    return _file

def getControlSummaryFile(runNo):
    _path=getControlPath(runNo)
    _files = glob.glob(_path+"CSNS-TS1-BL02-CTRL-Summary-*.xml")
    if _files:
        _file=_files[0]
    else:
        _file=None
    return _file

def getControlFiles(runNo):
    _path=getControlPath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.xml")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Control/"+_filename
        _dataDescription="control-raw"
        _datafileFormatName="control_summary"
        # for test
        #_datafileFormatName="xml"
    
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def hasControlSummaryFile(runNo):
    _path=getControlPath(runNo)
    _files = glob.glob(_path+"CSNS-TS1-BL02-CTRL-Summary-*.xml")
    if _files:
        _result=True
    else:
        _result=False
    return _result

def getRunTime(runNo):
    _file=getControlSummaryFile(runNo)

    tree = ET.parse(_file)
    root = tree.getroot()

    _tmp = root.findall("NXentry/start_time_utc")[0].text
    if _tmp:
        _tmp=re.sub(' ', 'T', _tmp)
        _tmp+=".000+08:00"
        beginDate=_tmp
    else:
        beginData=""

    _tmp = root.findall('NXentry/end_time_utc')[0].text
    if _tmp:
        _tmp=re.sub(' ', 'T', _tmp)
        _tmp+=".000+08:00"
        endDate=_tmp
    else:
        endData=""

    return beginDate, endDate

def readControlSummaryFile(runNo):
    _file=getControlSummaryFile(runNo)

    if _file is not None:
        with open(_file) as f:
            xmlstring = f.read()

        xmlstring=re.sub('\<NXroot.+', '<NXroot>', xmlstring)
        root = ET.fromstring(xmlstring)

        _tmp = root.findall("NXentry/start_time_utc")[0].text
        if _tmp:
            _tmp=re.sub(' ', 'T', _tmp)
            _tmp+=".000+08:00"
            startDatetime=_tmp
        else:
            startDatetime="unknown"

        _tmp = root.findall('NXentry/end_time_utc')[0].text
        if _tmp:
            _tmp=re.sub(' ', 'T', _tmp)
            _tmp+=".000+08:00"
            endDatetime=_tmp
        else:
            endDatetime="unknown"

        if startDatetime=="" and endDatetime!="":
            startDatetime=endDatetime
        elif startDatetime!="" and endDatetime=="":
            endDatetime=startDatetime

        _tmp1 = root.findall('NXentry/description')[0].text
        _tmp2 = root.findall('NXentry/measurement_type')[0].text
        if _tmp1 and _tmp2:
            datasetDescription=_tmp1+":"+_tmp2
        elif _tmp1:
            datasetDescription=_tmp1
        elif _tmp2:
            datasetDescription=_tmp2
        else:
            datasetDescription="unknown"

        user_id = root.findall('NXentry/user_id')[0].text
        proposal_id = root.findall('NXentry/proposal_id')[0].text

        # create and get id from ICAT
        _tmp = root.findall("NXentry/NXinstrument/NXsample/name")[0].text
        if _tmp:
            sampleTypeName=_tmp
        else:
            sampleTypeName="unknown"

        sampleName=sampleTypeName

        _tmp = root.findall("NXentry/NXinstrument/NXsample/chemical_formula")[0].text
        if _tmp:
            sampleTypeMolecularFormula=_tmp
        else:
            sampleTypeMolecularFormula="unknown"
    else:
        startDatetime="unknown"
        endDatetime="unknown"
        datasetDescription="unknown"
        sampleTypeName="unknown"
        sampleName="unknown"
        sampleTypeMolecularFormula="unknown"

    datasetType="commissioning"
    investigationName="commissioning-BL02"
    investigationTitleName="commissioning-BL02"
    visitName="commissioning-BL02-0"
    datasetName=getRunString(runNo)
    dataLocation="/CSNS/TS1/BL02/"+datasetName

    _dict={}
    _dict['startDatetime']=startDatetime
    _dict['endDatetime']=endDatetime
    _dict['datasetType']=datasetType
    _dict['investigationName']=investigationName
    _dict['investigationTitleName']=investigationTitleName
    _dict['visitName']=visitName
    _dict['datasetName']=datasetName
    _dict['dataLocation']=dataLocation
    _dict['datasetDescription']=datasetDescription
    _dict['sampleTypeName']=sampleTypeName
    _dict['sampleName']=sampleName
    _dict['sampleTypeMolecularFormula']=sampleTypeMolecularFormula

    return _dict

def has_CTRL(path):
    if not path:
        return False

    _file = glob.glob(path+"CSNS-TS1-BL02-CTRL-Summary-*.xml")
    if _file:
        return True
    else:
        return False

def has_DAQ(path):
    if not path:
        return False
    
    _file = glob.glob(path+"CSNS-TS1-BL02-DAQ-summary-*.xml")
    if _file:
        return True
    else:
        return False

def has_MONH(path):
    if not path:
        return False
    
    _file = glob.glob(path+"*.bin")
    if _file:
        return True
    else:
        return False

def has_MONE(path):
    if not path:
        return False
    
    _file = glob.glob(path+"*.h5")
    if _file:
        return True
    else:
        return False

#0: check done
#1: nexus begin
#2: nexus done
#3: irods begin
#4: irods done
#5: icat begin
#6: icat done

def getControl(runNoList):
    for i in runNoList:
        print i
        print "   control: ", getControlPath(i)
        j=getControlSummaryFile(i)
        readControlSummaryFile(j)
        print getFileName(j)
        print getFileSize(j)
        print j
        print getCreationDate(j)

def getDetector(runNoList):
    for i in runNoList:
        print i
        print "   DAQ: ", getDetectorPath(i), getDetectorSummaryFile(i), getDetectorFiles(i)
        if getDetectorFiles(i):
            for j in getDetectorFiles(i):
                print getFileName(j)
                print getFileSize(j)
                print j
                print getCreationDate(j)

def getMonitor(runNoList):
    for i in runNoList:
        print i
        print "   MON histogram:", getMONhisPath(i)
        if getMONhisFiles(i):
            for j in getMONhisFiles(i):
                print getFileName(j)
                print getFileSize(j)
                print j
                print getCreationDate(j)
        print "   MON     event:", getMONevtPath(i)
        if getMONevtFiles(i):
            for j in getMONevtFiles(i, 1):
                print getFileName(j)
                print getFileSize(j)
                print j
                print getCreationDate(j)

def getIcatInfo():
    global BLname, BLfullname
    investigationTypeName="commissioning"
    investigationName = "commissioning-BL02"
    titleName="commissioning-BL02"
    visitName="commissioning-BL02-0"

    sessionId = getSessionId()
    facilityId = getFacilityId(sessionId)
    instrumentId = getInstrumentId(sessionId, "BL02")

    try:
        setUser(sessionId, BLname, BLfullname)
    except:
        pass

    userId=getUserId(sessionId, "ldap/"+BLname)
    #print "get userId: ", userId

    investigationTypeId = getInvestigationTypeId(sessionId, investigationTypeName)
    #print "get investigationTypeId: ", investigationTypeId

    try:
        setInvestigation(sessionId, facilityId, investigationTypeId, investigationName, titleName, visitName)
        #print "set investigationId: ", investigationId
    except:
        pass

    investigationId = getInvestigationId(sessionId, investigationName, visitName)
    #print "get investigationId: ", investigationId

    try:
        investigationUserId = setInvestigationUser(sessionId, investigationId, userId)
        #print "set investigationUserId: ", investigationUserId
    except:
        pass

    try:
        investigationInstrumentId = setInvestigationInstrument(sessionId, investigationId, instrumentId)
        #print "set investigationInstrumentId: ", investigationInstrumentId
    except:
        pass

    return sessionId, facilityId, investigationId

def setIcatDataset(sessionId, facilityId, investigationId, sampleTypeName, sampleName, molecularFormula, datasetName, dataLocation, startDatetime, endDatetime, dataDescription):
    try:
        setSampleType(sessionId, facilityId, sampleTypeName, molecularFormula)
    except:
        pass
        
    sampleTypeId = getSampleTypeId(sessionId, sampleTypeName)
    #print "get sampleTypeId: ", sampleTypeId

    try:
        setSample(sessionId, investigationId, sampleTypeId, sampleName)
        #print "set sampleId: ", sampleId
    except:
        pass

    sampleId =  getSampleId(sessionId, str(investigationId), sampleName)

    try:
        investigationSampleId= setInvestigationSample(sessionId, investigationId, sampleTypeId, sampleName)
        #print "set investigationSampleId: ", investigationSampleId
    except:
        pass
    

    datasetTypeId= getDatasetTypeId(sessionId, "raw")
    #print "get datasetTypeId: ", datasetTypeId

    try:
        setDataset(sessionId, investigationId, datasetTypeId, sampleId, datasetName, dataLocation, startDatetime, endDatetime, dataDescription)
    except:
        pass

    datasetId = getDatasetId(sessionId, str(investigationId), datasetName) 
    #print "set datasetId: ", datasetId
    
    return datasetId

def setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation):
    try:
        datafileFormatId = getDatafileFormatId(sessionId, datafileFormatName, datafileFormatVersion="1.0")
        print "datafileFormatId: ", datafileFormatId

        result = setDatafile(sessionId, datasetId, datafileFormatId, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)
        print " set datafile: ", result
    except:
        pass

def writeXml(runNo, beginTime, endTime, controlFiles, detectorFiles, monitorhisFiles, monitorevtFiles, nexusFiles):
    #from ElementTree_pretty import prettify

    runString = getRunString(runNo)
    _tmp="mkdir -p "+getSoftwarePath(runNo)
    subprocess.check_output(_tmp, shell=True)


    top = ET.Element('root')

    child = ET.SubElement(top, 'run')
    child.text=runString

    child = ET.SubElement(top, 'begin')
    child.text=beginTime

    child = ET.SubElement(top, 'end')
    child.text=endTime

    _num=len(controlFiles)
    control = ET.SubElement(top, 'contorl')
    control.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in controlFiles:
        _file = ET.SubElement(control, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename
        
        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize
    
        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation

        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

    _num=len(detectorFiles)
    detector = ET.SubElement(top, 'detector')
    detector.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in detectorFiles:
        _file = ET.SubElement(detector, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename

        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize

        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation

        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation
        
    _num=len(monitorhisFiles)
    _monitor = ET.SubElement(top, "monitor_histogram")
    _monitor.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in monitorhisFiles:
        _file = ET.SubElement(_monitor, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename

        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize

        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation
            
        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

     
    _num=len(monitorevtFiles)
    _monitor = ET.SubElement(top, "monitor_event")
    _monitor.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in monitorevtFiles:
        _file = ET.SubElement(_monitor, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename

        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize

        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation
            
        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

    _num=len(nexusFiles)
    nexus = ET.SubElement(top, 'nexus')
    nexus.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in nexusFiles:
        _file = ET.SubElement(nexus, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename

        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize

        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation

        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

    from xml.dom import minidom

    xmlstr = minidom.parseString(ET.tostring(top)).toprettyxml(indent="   ")
    with open(getSoftwarePath(runNo)+runString+".xml", "w") as f:
        f.write(xmlstr)

def setControlLocation(runNo, _filename):
    backup="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Control/"+_filename
    return backup
    
def setDetectorLocation(runNo, _filename):
    backup="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Detector/"+_filename
    return backup
    
def setMonitorhisLocation(runNo, k, _filename):
    backup="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Monitor"+str(k)+"/Histogram/"+_filename
    return backup
    
def setMonitorevtLocation(runNo, k, _filename):
    backup="/raw/CSNS/TS1/BL02/"+getRunString(runNo)+"/Monitor"+str(k)+"/Event/"+_filename
    return backup
    
def setNexusLocation(runNo, k, _filename):
    backup="/nexus/CSNS/TS1/BL02/" +getRunString(runNo)+"/"+_filename
    return backup

def getRunString(runNo):
    return "RUN"+str(runNo).zfill(7)

def writeIcat(runNo):
    global icatTime

    global sessionId, facilityId, investigationId

    if time.time()-icatTime>5400:
        icatTime=time.time()
        sessionId, facilityId, investigationId = getIcatInfo()

    conf = readControlSummaryFile(runNo)
    datasetId =setIcatDataset(sessionId, facilityId, investigationId, conf['sampleTypeName'], conf['sampleName'], conf['sampleTypeMolecularFormula'], conf['datasetName'], conf['dataLocation'], conf['startDatetime'], conf['endDatetime'], conf['datasetDescription'])

    _controlFiles=getControlFiles(runNo)
    _detectorFiles=getDetectorFiles(runNo)
    _monitorhisFiles = getMonitorhisFiles(runNo)
    _monitorevtFiles = getMonitorevtFiles(runNo)
    _nexusFiles       = getNexusFiles(runNo)
    _softwareFiles    = getSoftwareFiles(runNo)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _controlFiles:  
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _detectorFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)
    
    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitorhisFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)
    
    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitorevtFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _nexusFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _softwareFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    return True

def mkdirRods(runNo):
    runString=getRunString(runNo)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL02/"+runString+"/Control"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL02/"+runString+"/Detector"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL02/"+runString+"/Monitor/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL02/"+runString+"/Monitor/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL02/"+runString+"/Software"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/nexus/CSNS/TS1/BL02/"+runString
    subprocess.check_output(_tmp, shell=True) 

def mkdirPublic(runNo):
    runString=getRunString(runNo)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL02/"+runString+"/Control"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL02/"+runString+"/Detector"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL02/"+runString+"/Monitor/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL02/"+runString+"/Monitor/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/nexus/CSNS/TS1/BL02/"+runString
    subprocess.check_output(_tmp, shell=True)

def addGroup():
    global BLname
    _tmp="iadmin mkuser "+BLname+"#csnsZone rodsuser"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin mkgroup "+"bl02admin"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin atg bl02admin "+BLname+"#csnsZone"
    subprocess.check_output(_tmp, shell=True)

    _tmp="iadmin mkgroup "+"bl02commissioning"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin atg bl02commissioning "+BLname+"#csnsZone"
    subprocess.check_output(_tmp, shell=True)

    _tmp="iadmin mkgroup "+"csnsuser"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin atg csnsuser "+BLname+"#csnsZone"
    subprocess.check_output(_tmp, shell=True)

def addAcl(runNo):
    _tmp="ichmod -r read bl02commissioning /csnsZone/home/public/nexus/CSNS/TS1/BL02/"+getRunString(runNo)
    subprocess.check_output(_tmp, shell=True)
    _tmp="ichmod -r read bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/"+getRunString(runNo)
    subprocess.check_output(_tmp, shell=True)
    _tmp="ichmod -r read bl02admin /csnsZone/home/public/nexus/CSNS/TS1/BL02/"+getRunString(runNo)
    subprocess.check_output(_tmp, shell=True)
    
def putRods(sourcePath, targetPath):
    retries=0
    backupResc="csnsBackupDataResc"
    restartFile="./rodsbase/restartFile"
    lfRestartFile="./rodsbase/lfRestartFile"

    putComOption="-KrTfP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile

    _tmp = "iput -R " + backupResc +" "+putComOption +" "+ sourcePath +" "+ targetPath
    
    subprocess.call(_tmp, shell=True)

    return True

def putPublic(sourcePath, targetPath):
    retries=0
    backupResc="csnsResc"
    restartFile="./rodsbase/restartFile"
    lfRestartFile="./rodsbase/lfRestartFile"

    putComOption="-KrTfP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile

    _tmp = "iput -R " + backupResc +" "+putComOption +" "+ sourcePath +" "+ targetPath

    subprocess.call(_tmp, shell=True)
    
    return True

def transferData(runNo):
    runString=getRunString(runNo)

    mkdirRods(runNo)
    mkdirPublic(runNo)

    _b=time.time()
    
    _controlFiles=getControlFiles(runNo)
    _detectorFiles=getDetectorFiles(runNo)
    _monitorhisFiles = getMonitorhisFiles(runNo)
    _monitorevtFiles = getMonitorevtFiles(runNo)

    _nexusFiles      = getNexusFiles(runNo)
    conf = readControlSummaryFile(runNo)
    writeXml(runNo, conf['startDatetime'], conf['endDatetime'], _controlFiles, _detectorFiles, _monitorhisFiles,  _monitorevtFiles, _nexusFiles)
    _softwareFiles       = getSoftwareFiles(runNo)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _controlFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _detectorFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitorhisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitorevtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _nexusFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _softwareFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    addAcl(runNo)

    print time.time()-_b
    return True

def transferNexus(runNo):
    runString=getRunString(runNo)

    mkdirRods(runNo)
    mkdirPublic(runNo)

    _controlFiles=getControlFiles(runNo)
    _detectorFiles=getDetectorFiles(runNo)
    _monitorhisFiles = getMonitorhisFiles(runNo)
    _monitorevtFiles = getMonitorevtFiles(runNo)
    _nexusFiles      = getNexusFiles(runNo)
    conf = readControlSummaryFile(runNo)
    writeXml(runNo, conf['startDatetime'], conf['endDatetime'], _controlFiles, _detectorFiles, _monitorhisFiles,  _monitorevtFiles, _nexusFiles)

    _softwareFiles       = getSoftwareFiles(runNo)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _nexusFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)
    
    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _softwareFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)
        
    addAcl(runNo)

    return True

# ==============================
icatTime=time.time()
sessionId, facilityId, investigationId = getIcatInfo()
# ==============================
try:
    addGroup()
except:
    pass

#!/usr/bin/python
import sys
import time
import os
import threading

class main(threading.Thread):
    def __init__(self):
        threading.Thread.__init__(self)
        self.getDb()

    def hasNexus(self, runNo):
        _path=getNexusPath(runNo)+"/complete"
        _tmp=glob.glob(_path)
        try:
            if len(_tmp)==1:
                _r=True
            else:
                _r=False
        except:
            _r=False

        return _r

    def getRunString(self, runNo):
        return "RUN"+str(runNo).zfill(7)


    def getDb(self):
        dbfile='bl02.db'
        if os.path.exists(dbfile):
            self.db = sqlite3.connect(dbfile,check_same_thread = False)
            self.cur = self.db.cursor()
        else:
            self.db = sqlite3.connect(dbfile,check_same_thread = False)
            self.cur = self.db.cursor()
            tb = 'CREATE TABLE data (ID INTEGER PRIMARY KEY, BEAMLINE TEXT, RUN TEXT, CTRL INTEGER, DAQ INTEGER, MONHIS INTEGER, MONEVT INTEGER, NEXUS INTEGER,  BEGIN TEXT, END TEXT, STAT INTEGER)'
            self.cur.execute(tb)
            self.db.commit()

    def setDb(self, runNo):
        # ==============================
        # has control summary file
        hasControl = hasControlSummaryFile(runNo)
        conf = readControlSummaryFile(runNo)
        # ==============================
        # has detector path
        hasDetector = hasDetectorPath(runNo)
        # ==============================
        # has monitor histogram path
        hasMonitorHis = hasMonitorHisPath(runNo)
        # has monitor event path
        hasMonitorEvt = hasMonitorEvtPath(runNo)
        # ==============================
        # has nexus path
        hasNexus = hasNexusPath(runNo)

        runString=getRunString(runNo)
        self.writeDb(runString, hasControl, hasDetector, hasMonitorHis, hasMonitorEvt, hasNexus,conf['startDatetime'], conf['endDatetime'], 0)

    def deleteDb(self, STAT):
        cur = self.db.cursor()
        query = "delete from data where STAT = %d " % STAT
        cur.execute(query)
        self.db.commit()

    def writeDb(self, RUN, CTRL, DAQ, MONHIS, MONEVT, NEXUS, BEGIN, END, STAT):
        sqlstring = 'INSERT INTO data (ID, BEAMLINE, RUN, CTRL, DAQ, MONHIS, MONEVT, NEXUS,BEGIN, END, STAT) VALUES(NULL, "%s", "%s", "%d","%d", "%d", "%d", "%d", "%s", "%s", "%d")' %("BL02", RUN, CTRL, DAQ, MONHIS, MONEVT, NEXUS, BEGIN, END, STAT)
        self.cur.execute(sqlstring)
        self.db.commit()

    def readDb(self):
        self.cur.execute('SELECT * FROM data')
        dbList = self.cur.fetchall()
        #for i in dbList:
        #    print i

    def setDbStat(self, runNo, value):
        runString=self.getRunString(runNo)
        _tmp ="update data set STAT='%d' where run = '%s'" % (value, runString)
        self.cur.execute(_tmp)

    def fetchDbStat(self, id):
        _tmp ="SELECT * FROM data where id = %d" % (id)
        self.cur.execute(_tmp)
        dbList = self.cur.fetchall()
        for i in dbList:
            print i

    def getDbStat(self, runNo):
        runString=self.getRunString(runNo)
        self.cur.execute('SELECT * FROM data where run = ?', (runString,))
        dbList = self.cur.fetchone()

        return dbList[10]

    def process(self):
        self.readDb() 
        runNoList=getRunNoList(Nexuspath)

        for runNo in runNoList:
            try:
                stat=self.getDbStat(runNo)
            except:
                stat=-1

            print "begin: ", runNo, stat
            
            _hasnxs=self.hasNexus(runNo)
            if not _hasnxs:
                print "wanrning:", runNo, " not reconstructed."

            if stat==-1:
                self.setDb(runNo)

                _raw=transferData(runNo)
                if _raw:
                    self.setDbStat(runNo, 2)
                    success = writeIcat(runNo)
                    if success: self.setDbStat(runNo, 3)

            elif stat==0:
                _raw=transferData(runNo)
                if _raw:
                    self.setDbStat(runNo, 2)
                    success = writeIcat(runNo)
                    if success: self.setDbStat(runNo, 3)

            elif stat==1:
		pass
                '''
		if _hasnxs:
                    _nexus= transferNexus(runNo)
                    if _nexus:
                        self.setDbStat(runNo, 2)
                        success = writeIcat(runNo)
                        if success: self.setDbStat(runNo, 3)
		'''

            elif stat==2:
                success = writeIcat(runNo)
                if success: self.setDbStat(runNo, 3)
            else:
                pass

            print "end: ", runNo

    def run(self):
        while True:
            try:
                self.process()
            except:
                pass
            time.sleep(300.0)

if __name__=="__main__":

    threadDaemon = main()
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()

