package cn.ac.csns.microscope.entity;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(name = "BL02")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "BL02Status.findAll",
            query = "SELECT b FROM BL02Status b"),
    @NamedQuery(name = "BL02Status.findById",
            query = "SELECT b FROM BL02Status b WHERE b.id = :id"),
    @NamedQuery(name = "BL02Status.findByBeamline",
            query = "SELECT b FROM BL02Status b WHERE b.beamline = :beamline"),
    @NamedQuery(name = "BL02Status.findByRun",
            query = "SELECT b FROM BL02Status b WHERE b.run = :run"),
    @NamedQuery(name = "BL02Status.findByCtrl",
            query = "SELECT b FROM BL02Status b WHERE b.ctrl = :ctrl"),
    @NamedQuery(name = "BL02Status.findByDaq",
            query = "SELECT b FROM BL02Status b WHERE b.daq = :daq"),
    @NamedQuery(name = "BL02Status.findByMonHis",
            query = "SELECT b FROM BL02Status b WHERE b.monHis = :monhis"),
    @NamedQuery(name = "BL02Status.findByMonEvt",
            query = "SELECT b FROM BL02Status b WHERE b.monEvt = :monevt"),
    @NamedQuery(name = "BL02Status.findByNexus",
            query = "SELECT b FROM BL02Status b WHERE b.nexus = :nexus"),
    @NamedQuery(name = "BL02Status.findByBegin",
            query = "SELECT b FROM BL02Status b WHERE b.begin = :begin"),
    @NamedQuery(name = "BL02Status.findByEnd",
            query = "SELECT b FROM BL02Status b WHERE b.end = :end"),
    @NamedQuery(name = "BL02Status.findByStat",
            query = "SELECT b FROM BL02Status b WHERE b.stat = :stat")})
public class BL02Status implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "ID")
    private Integer id;

    @Basic(optional = false)
    @NotNull
    @Size(min = 4, max = 4)
    @Column(name = "BEAMLINE")
    private String beamline;

    @Basic(optional = false)
    @NotNull
    @Size(min = 10, max = 10)
    @Column(name = "RUN")
    private String run;

    @Basic(optional = false)
    @NotNull
    @Column(name = "CTRL")
    private Boolean ctrl;

    @Basic(optional = false)
    @NotNull
    @Column(name = "DAQ")
    private Boolean daq;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONHIS")
    private Boolean monHis;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONEVT")
    private Boolean monEvt;

    @Basic(optional = false)
    @NotNull
    @Column(name = "NEXUS")
    private Boolean nexus;

    @Size(max = 50)
    @Column(name = "BEGIN")
    private String begin;

    @Size(max = 50)
    @Column(name = "END")
    private String end;

    @Column(name = "STAT")
    private Short stat;

    public BL02Status() {
    }

    public BL02Status(Integer id) {
        this.id = id;
    }

    public BL02Status(Integer id,
            String beamline,
            String run,
            Boolean ctrl,
            Boolean daq,
            Boolean monhis,
            Boolean monevt,
            Boolean nexus) {
        this.id = id;
        this.beamline = beamline;
        this.run = run;
        this.ctrl = ctrl;
        this.daq = daq;
        this.monHis = monhis;
        this.monEvt = monevt;
        this.nexus = nexus;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBeamline() {
        return beamline;
    }

    public void setBeamline(String beamline) {
        this.beamline = beamline;
    }

    public String getRun() {
        return run;
    }

    public void setRun(String run) {
        this.run = run;
    }

    public Boolean getCtrl() {
        return ctrl;
    }

    public void setCtrl(Boolean ctrl) {
        this.ctrl = ctrl;
    }

    public Boolean getDaq() {
        return daq;
    }

    public void setDaq(Boolean daq) {
        this.daq = daq;
    }

    public Boolean getMonHis() {
        return monHis;
    }

    public void setMonHis(Boolean monHis) {
        this.monHis = monHis;
    }

    public Boolean getMonEvt() {
        return monEvt;
    }

    public void setMonEvt(Boolean monEvt) {
        this.monEvt = monEvt;
    }

    public Boolean getNexus() {
        return nexus;
    }

    public void setNexus(Boolean nexus) {
        this.nexus = nexus;
    }

    public String getBegin() {
        return begin;
    }

    public void setBegin(String begin) {
        this.begin = begin;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public Short getStat() {
        return stat;
    }

    public void setStat(Short stat) {
        this.stat = stat;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof BL02Status)) {
            return false;
        }
        BL02Status other = (BL02Status) object;
        if ((this.id == null && other.id != null)
                || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + id + "]";
    }

}
