package cn.ac.csns.microscope.entity;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(name = "BL01",
        uniqueConstraints = {
            @UniqueConstraint(columnNames = {"RUN"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "BL01Status.findAll",
            query = "SELECT b FROM BL01Status b"),
    @NamedQuery(name = "BL01Status.findById",
            query = "SELECT b FROM BL01Status b WHERE b.id = :id"),
    @NamedQuery(name = "BL01Status.findByBeamline",
            query = "SELECT b FROM BL01Status b WHERE b.beamline = :beamline"),
    @NamedQuery(name = "BL01Status.findByRun",
            query = "SELECT b FROM BL01Status b WHERE b.run = :run"),
    @NamedQuery(name = "BL01Status.findByCtrl",
            query = "SELECT b FROM BL01Status b WHERE b.ctrl = :ctrl"),
    @NamedQuery(name = "BL01Status.findByDaq",
            query = "SELECT b FROM BL01Status b WHERE b.daq = :daq"),
    @NamedQuery(name = "BL01Status.findByMonHis1",
            query = "SELECT b FROM BL01Status b WHERE b.monHis1 = :monhis1"),
    @NamedQuery(name = "BL01Status.findByMonHis2",
            query = "SELECT b FROM BL01Status b WHERE b.monHis2 = :monhis2"),
    @NamedQuery(name = "BL01Status.findByMonHis3",
            query = "SELECT b FROM BL01Status b WHERE b.monHis3 = :monhis3"),
    @NamedQuery(name = "BL01Status.findByMonEvt1",
            query = "SELECT b FROM BL01Status b WHERE b.monEvt1 = :monevt1"),
    @NamedQuery(name = "BL01Status.findByMonEvt2",
            query = "SELECT b FROM BL01Status b WHERE b.monEvt2 = :monevt2"),
    @NamedQuery(name = "BL01Status.findByMonEvt3",
            query = "SELECT b FROM BL01Status b WHERE b.monEvt3 = :monevt3"),
    @NamedQuery(name = "BL01Status.findByNexus",
            query = "SELECT b FROM BL01Status b WHERE b.nexus = :nexus"),
    @NamedQuery(name = "BL01Status.findByBegin",
            query = "SELECT b FROM BL01Status b WHERE b.begin = :begin"),
    @NamedQuery(name = "BL01Status.findByEnd",
            query = "SELECT b FROM BL01Status b WHERE b.end = :end"),
    @NamedQuery(name = "BL01Status.findByStat",
            query = "SELECT b FROM BL01Status b WHERE b.stat = :stat")})
public class BL01Status implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Basic(optional = false)
    @Column(name = "ID")
    private Integer id;

    @Basic(optional = false)
    @NotNull
    @Size(min = 4, max = 4)
    @Column(name = "BEAMLINE")
    private String beamline;

    @Basic(optional = false)
    @NotNull
    @Size(min = 10, max = 10)
    @Column(name = "RUN")
    private String run;

    @Basic(optional = false)
    @NotNull
    @Column(name = "CTRL")
    private Boolean ctrl;

    @Basic(optional = false)
    @NotNull
    @Column(name = "DAQ")
    private Boolean daq;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONHIS1")
    private Boolean monHis1;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONHIS2")
    private Boolean monHis2;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONHIS3")
    private Boolean monHis3;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONEVT1")
    private Boolean monEvt1;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONEVT2")
    private Boolean monEvt2;

    @Basic(optional = false)
    @NotNull
    @Column(name = "MONEVT3")
    private Boolean monEvt3;

    @Basic(optional = false)
    @NotNull
    @Column(name = "NEXUS")
    private Boolean nexus;

    @Size(max = 50)
    @Column(name = "BEGIN")
    private String begin;

    @Size(max = 50)
    @Column(name = "END")
    private String end;

    @Column(name = "STAT")
    private Short stat;

    public BL01Status() {
    }

    public BL01Status(Integer id) {
        this.id = id;
    }

    public BL01Status(Integer id,
            String beamline,
            String run,
            Boolean ctrl,
            Boolean daq,
            Boolean monhis1,
            Boolean monhis2,
            Boolean monhis3,
            Boolean monevt1,
            Boolean monevt2,
            Boolean monevt3,
            Boolean nexus) {
        this.id = id;
        this.beamline = beamline;
        this.run = run;
        this.ctrl = ctrl;
        this.daq = daq;
        this.monHis1 = monhis1;
        this.monHis2 = monhis2;
        this.monHis3 = monhis3;
        this.monEvt1 = monevt1;
        this.monEvt2 = monevt2;
        this.monEvt3 = monevt3;
        this.nexus = nexus;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBeamline() {
        return beamline;
    }

    public void setBeamline(String beamline) {
        this.beamline = beamline;
    }

    public String getRun() {
        return run;
    }

    public void setRun(String run) {
        this.run = run;
    }

    public Boolean getCtrl() {
        return ctrl;
    }

    public void setCtrl(Boolean ctrl) {
        this.ctrl = ctrl;
    }

    public Boolean getDaq() {
        return daq;
    }

    public void setDaq(Boolean daq) {
        this.daq = daq;
    }

    public Boolean getMonHis1() {
        return monHis1;
    }

    public void seMonHis1(Boolean monHis1) {
        this.monHis1 = monHis1;
    }

    public Boolean getMonHis2() {
        return monHis2;
    }

    public void setMonHis2(Boolean monHis2) {
        this.monHis2 = monHis2;
    }

    public Boolean getMonHis3() {
        return monHis3;
    }

    public void setMonHis3(Boolean monHis3) {
        this.monHis3 = monHis3;
    }

    public Boolean getMonEvt1() {
        return monEvt1;
    }

    public void setMonEvt1(Boolean monEvt1) {
        this.monEvt1 = monEvt1;
    }

    public Boolean getMonEvt2() {
        return monEvt2;
    }

    public void setMonEvt2(Boolean monEvt2) {
        this.monEvt2 = monEvt2;
    }

    public Boolean getMonEvt3() {
        return monEvt3;
    }

    public void setMonEvt3(Boolean monEvt3) {
        this.monEvt3 = monEvt3;
    }

    public Boolean getNexus() {
        return nexus;
    }

    public void setNexus(Boolean nexus) {
        this.nexus = nexus;
    }

    public String getBegin() {
        return begin;
    }

    public void setBegin(String begin) {
        this.begin = begin;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public Short getStat() {
        return stat;
    }

    public void setStat(Short stat) {
        this.stat = stat;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof BL01Status)) {
            return false;
        }
        BL01Status other = (BL01Status) object;
        if ((this.id == null && other.id != null)
                || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + id + "]";
    }

}
