package cn.ac.csns.microscope.managed;

import cn.ac.csns.microscope.StatusMapper;
import cn.ac.csns.microscope.ejb.BL18StatusFacade;
import cn.ac.csns.microscope.entity.BL18Status;
import cn.ac.csns.microscope.exception.TransferException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class BL18StatusController implements Serializable {

    private static final long serialVersionUID = 1L;
    private List<BL18Status> status;
    private List<BL18Status> filteredStatus;
    private Calendar updateTime;
    private boolean updating;
    private int updateInterval = 10;

    @EJB
    BL18StatusFacade facade;

    /**
     * Creates a new instance of BL18Controller
     */
    public BL18StatusController() {
        status = new ArrayList<>();
    }

    @PostConstruct
    private void init() {
        updateStatus();
    }

    synchronized public void updateStatus() {
        if (updating) {
            return;
        }
        updating = true;
        try {
            status = facade.findAll();
            status.sort((p1, p2) -> p2.getRun().compareToIgnoreCase(p1.getRun()));
            updateTime = Calendar.getInstance();
        } catch (TransferException ex) {
            Logger.getLogger(BL18StatusController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_ERROR,
                                    ex.getLocalizedMessage(),
                                    ex.getLocalizedMessage()));
        }
        updating = false;
    }

    public String getStringStatus(Integer statusId) {
        return StatusMapper.getStringStatus(statusId);
    }

    public List<BL18Status> getStatus() {
        return status;
    }

    public List<BL18Status> getFilteredStatus() {
        return filteredStatus;
    }

    public void setFilteredStatus(List<BL18Status> filteredStatus) {
        this.filteredStatus = filteredStatus;
    }

    public Calendar getUpdateTime() {
        return updateTime;
    }

    public int getUpdateInterval() {
        return updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

}
