package cn.ac.csns.microscope;

import java.io.Serializable;
import java.util.Objects;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
public abstract class DataStatus implements Serializable {
    
    protected final String run;
    protected int control;
    protected int detector;
    protected int nexus;
    protected int software;

    public DataStatus(String run) {
        this.run = run;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.run);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final BL01DataStatus other = (BL01DataStatus) obj;
        return this.run.equalsIgnoreCase(other.run);
    }

    public String getRun() {
        return run;
    }

    public int getControl() {
        return control;
    }

    public void setControl(int control) {
        this.control = control;
    }

    public int getDetector() {
        return detector;
    }

    public void setDetector(int detector) {
        this.detector = detector;
    }

    public int getNexus() {
        return nexus;
    }

    public void setNexus(int nexus) {
        this.nexus = nexus;
    }

    public int getSoftware() {
        return software;
    }

    public void setSoftware(int software) {
        this.software = software;
    }
    
}
