function setHighchartsOptions() {
    var colors = ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'];
    Highcharts.setOptions({
        colors: Highcharts.map(colors, function (color) {
            return {
                radialGradient: {
                    cx: 0.5,
                    cy: 0.3,
                    r: 0.7
                },
                stops: [
                    [0, color],
                    [1, Highcharts.Color(color).brighten(-0.3).get('rgb')] // darken
                ]
            };
        })
    });
}

function addBeamlineChart(containerId, titleText, seriesName,
        transferredNum, transferringNum, notTransferredNum) {
    Highcharts.chart(containerId, {
        credits: {
            enabled: false
        },
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie',
            spacingTop: -10,
            spacingBottom: -10,
            options3d: {
                enabled: true,
                alpha: 45,
                beta: 0
            }
        },
        title: {
            text: titleText,
            y: 40,
            floating: true
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.y}, {point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                depth: 35,
                dataLabels: {
                    enabled: false,
                    format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                    connectorColor: 'silver'
                }
            },
            series: {
                events: {
                    click: function (event) {
                        var name = event.point.name.toLowerCase();
                        var prefix = window.location.origin;
                        var pathname = window.location.pathname;
                        prefix = prefix + pathname.substring(0, pathname.indexOf('/', 1)) + '/';
                        switch (event.point.name.toLowerCase()) {
                            case 'transferred':
                                window.location.href = prefix + this.name + 'status.xhtml';
                                break;
                            case 'not transferred':
                                window.location.href = prefix + this.name + 'data.xhtml';
                                break;
                            default:
                                break;
                        }
                    }
                }
            }
        },
        series: [{
                name: seriesName,
                data: [
                    {name: 'Transferred', y: transferredNum, sliced: true},
                    {name: 'Transferring', y: transferringNum},
                    {name: 'Not transferred', y: notTransferredNum}
                ]
            }]
    });
}

